/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.serialization;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.AstNodePropertyIterator;
import de.fau.cs.osr.ptk.common.ast.AstStringNode;
import de.fau.cs.osr.ptk.common.serialization.AstConverterBase;
import de.fau.cs.osr.ptk.common.serialization.IncompatibleAstNodeClassException;
import de.fau.cs.osr.ptk.common.serialization.NodeFactory;
import de.fau.cs.osr.ptk.common.serialization.SimpleNodeFactory;
import de.fau.cs.osr.utils.ReflectionUtils;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AstNodeConverterBase<T extends AstNode<T>>
extends AstConverterBase {
    private static final int LOWER_CAPACITY = 256;
    private static final int UPPER_CAPACITY = 384;
    private static final float LOAD_FACTOR = 0.6f;
    private static final ConcurrentHashMap<Getter, Getter> CACHE = new ConcurrentHashMap(256, 0.6f);
    private final Class<T> nodeType;
    private NodeFactory<T> nodeFactory = new SimpleNodeFactory();
    private boolean alwaysStoreType = false;
    private Set<Class<?>> suppressTypeInfo = null;
    private boolean storeLocation = true;
    private boolean storeAttributes = true;
    private Set<String> suppressAttributes = null;
    private boolean suppressEmptyStringProperties = false;
    private Set<String> suppressProperties = null;
    private Set<Class<? extends T>> suppressNodes = null;
    private Class<? extends AstStringNode<T>> stringNodeType;
    private boolean suppressEmptyStringNodes = false;

    public AstNodeConverterBase(Class<T> nodeType) {
        this.nodeType = nodeType;
    }

    public void setNodeFactory(NodeFactory<T> nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public NodeFactory<T> getNodeFactory() {
        return this.nodeFactory;
    }

    public void setAlwaysStoreType(boolean alwaysStoreType) {
        this.alwaysStoreType = alwaysStoreType;
    }

    public void suppressTypeInfo(Class<?> type) {
        if (this.suppressTypeInfo == null) {
            this.suppressTypeInfo = new HashSet();
        }
        this.suppressTypeInfo.add(type);
    }

    public void setStoreLocation(boolean storeLocation) {
        this.storeLocation = storeLocation;
    }

    public void setStoreAttributes(boolean storeAttributes) {
        this.storeAttributes = storeAttributes;
    }

    public void suppressAttribute(String name) {
        if (this.suppressAttributes == null) {
            this.suppressAttributes = new HashSet<String>();
        }
        this.suppressAttributes.add(name);
    }

    public void setSuppressEmptyStringProperties(boolean suppressEmptyStringProperties) {
        this.suppressEmptyStringProperties = suppressEmptyStringProperties;
    }

    public void suppressProperty(String name) {
        if (this.suppressProperties == null) {
            this.suppressProperties = new HashSet<String>();
        }
        this.suppressProperties.add(name);
    }

    public void suppressNode(Class<? extends T> nodeType) {
        if (this.suppressNodes == null) {
            this.suppressNodes = new HashSet<Class<? extends T>>();
        }
        this.suppressNodes.add(nodeType);
    }

    public void setStringNodeType(Class<? extends AstStringNode<T>> stringNodeType) {
        this.stringNodeType = stringNodeType;
    }

    public void setSuppressEmptyStringNodes(boolean suppressEmptyStringNodes) {
        this.suppressEmptyStringNodes = suppressEmptyStringNodes;
    }

    protected Class<T> getNodeType() {
        return this.nodeType;
    }

    public boolean isAlwaysStoreType() {
        return this.alwaysStoreType;
    }

    protected boolean isTypeInfoSuppressed(Class<?> type) {
        return !this.alwaysStoreType && this.suppressTypeInfo != null && this.suppressTypeInfo.contains(type);
    }

    protected boolean isLocationSuppressed() {
        return !this.storeLocation;
    }

    protected boolean isAttributesSuppressed() {
        return !this.storeAttributes;
    }

    protected boolean isAttributeSuppressed(String name) {
        return this.isAttributesSuppressed() || this.suppressAttributes != null && this.suppressAttributes.contains(name);
    }

    protected boolean isPropertySuppressed(String name) {
        return this.suppressProperties != null && this.suppressProperties.contains(name);
    }

    protected boolean isSuppressed(Object n) {
        String content;
        Class<?> objType = n.getClass();
        if (this.suppressNodes != null && this.suppressNodes.contains(objType)) {
            return true;
        }
        return this.suppressEmptyStringNodes && this.isStringNode(objType) ? (content = ((AstStringNode)n).getContent()).isEmpty() : this.suppressEmptyStringProperties && String.class == objType && (content = (String)n).isEmpty();
    }

    protected boolean isStringNode(Class<?> clazz) {
        return this.stringNodeType == clazz;
    }

    public Class<? extends AstStringNode<T>> getStringNodeType() {
        return this.stringNodeType;
    }

    protected T instantiateNode(Class<?> clazz) {
        return this.nodeFactory.instantiateNode(clazz);
    }

    protected T instantiateDefaultChild(T n, String name, Class<?> child) {
        return this.nodeFactory.instantiateDefaultChild(new NodeFactory.NamedMemberId(n.getClass(), name), child);
    }

    protected void setDefaultChild(T n, int childIndex, String childName) {
        Class<?> type = this.getGetterType((AstNode<T>)n, childName);
        T value = this.instantiateDefaultChild(n, childName, type);
        n.set(childIndex, value);
    }

    private Object instantiateDefaultProperty(T n, String name, Class<?> type) {
        return this.nodeFactory.instantiateDefaultProperty(new NodeFactory.NamedMemberId(n.getClass(), name), type);
    }

    protected void setDefaultProperty(T n, AstNodePropertyIterator i) {
        String name = i.getName();
        Class<?> type = this.getGetterType((AstNode<T>)n, name);
        Object value = this.instantiateDefaultProperty(n, name, type);
        i.setValue(value);
    }

    protected String getTypeAlias(AstNode<T> n) {
        return ((AstConverterBase)this).getTypeAlias(n.getClass());
    }

    protected boolean serializedTypeIsExpectedType(Class<?> expectedType, Class<?> childType) {
        if (childType == expectedType) {
            return true;
        }
        if (expectedType.isPrimitive()) {
            return ReflectionUtils.mapPrimitiveToUcType(expectedType) == childType;
        }
        return false;
    }

    protected boolean serializedTypeIsExpectedType(AstNode<T> parent, String name, Class<?> valueType) {
        return this.serializedTypeIsExpectedType(this.getGetterType(parent, name), valueType);
    }

    protected boolean isTypeInfoRequired(AstNode<T> parentNode, String name, Class<?> valueType) {
        return this.alwaysStoreType || !this.serializedTypeIsExpectedType(parentNode, name, valueType) && !this.isTypeInfoSuppressed(valueType);
    }

    protected Class<?> getGetterType(AstNode<T> n, String name) {
        Class<?> nodeType = n.getClass();
        Getter getter = new Getter(nodeType, name);
        Getter cached = CACHE.get(getter);
        if (cached != null) {
            return cached.getGetterType();
        }
        return this.analyzeGetter(name, nodeType);
    }

    private Class<?> analyzeGetter(String name, Class<?> nodeType) {
        Method getterMethod;
        try {
            getterMethod = new PropertyDescriptor(name, nodeType).getReadMethod();
        }
        catch (IntrospectionException e) {
            throw new IncompatibleAstNodeClassException("Class '" + nodeType.getName() + "' is malformed", e);
        }
        Class<?> getterType = getterMethod.getReturnType();
        this.rememberGetter(name, nodeType, getterType);
        return getterType;
    }

    private void rememberGetter(String name, Class<?> nodeType, Class<?> getterType) {
        Getter getter = new Getter(nodeType, name, getterType);
        Getter cached = CACHE.putIfAbsent(getter, getter);
        if (cached == null) {
            getter.touch();
            if (CACHE.size() > 384) {
                AstNodeConverterBase.sweepCache();
            }
        }
    }

    private static synchronized void sweepCache() {
        if (CACHE.size() <= 384) {
            return;
        }
        Object[] keys = new Getter[CACHE.size()];
        Enumeration<Getter> keysEnum = CACHE.keys();
        int i = 0;
        while (i < keys.length && keysEnum.hasMoreElements()) {
            keys[i++] = keysEnum.nextElement();
        }
        int length = i;
        Arrays.sort(keys, 0, length);
        int to = length - 256;
        for (int j = 0; j < to; ++j) {
            CACHE.remove(keys[j]);
        }
    }

    protected static final class Getter
    implements Comparable<Getter> {
        private static long useCounter = 0L;
        private long lastUse = -1L;
        private Class<?> nodeType;
        private String fieldName;
        private Class<?> getterType;

        public Getter(Class<?> nodeType, String fieldName) {
            this.nodeType = nodeType;
            this.fieldName = fieldName;
            this.getterType = null;
        }

        public Getter(Class<?> nodeType, String fieldName, Class<?> getterType) {
            this.nodeType = nodeType;
            this.fieldName = fieldName;
            this.getterType = getterType;
        }

        public Class<?> getNodeType() {
            return this.nodeType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Class<?> getGetterType() {
            return this.getterType;
        }

        public int hashCode() {
            return this.fieldName.hashCode() + 31 * this.nodeType.hashCode();
        }

        public boolean equals(Object obj) {
            Getter other = (Getter)obj;
            if (!this.fieldName.equals(other.fieldName)) {
                return false;
            }
            return this.nodeType == other.nodeType;
        }

        public void touch() {
            this.lastUse = ++useCounter;
        }

        @Override
        public int compareTo(Getter o) {
            return this.lastUse < o.lastUse ? -1 : 1;
        }
    }
}

