/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.helpers.DatamodelMapper;
import org.wikidata.wdtk.datamodel.helpers.JsonSerializer;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.wikibaseapi.GuidGenerator;
import org.wikidata.wdtk.wikibaseapi.RandomGuidGenerator;
import org.wikidata.wdtk.wikibaseapi.WbEditingAction;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class StatementUpdate {
    static final Logger logger = LoggerFactory.getLogger(StatementUpdate.class);
    private GuidGenerator guidGenerator = new RandomGuidGenerator();
    private final ObjectMapper mapper;
    @JsonIgnore
    final HashMap<PropertyIdValue, List<StatementWithUpdate>> toKeep;
    @JsonIgnore
    final List<String> toDelete;
    @JsonIgnore
    StatementDocument currentDocument;

    public StatementUpdate(StatementDocument currentDocument, List<Statement> addStatements, List<Statement> deleteStatements) {
        this.currentDocument = currentDocument;
        this.toKeep = new HashMap();
        this.toDelete = new ArrayList<String>();
        this.markStatementsForUpdate(currentDocument, addStatements, deleteStatements);
        this.mapper = new DatamodelMapper(currentDocument.getEntityId().getSiteIri());
    }

    @JsonIgnore
    public String getJsonUpdateString() {
        try {
            return this.mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "Failed to serialize statement update to JSON: " + e.toString();
        }
    }

    public StatementDocument performEdit(WbEditingAction action, boolean editAsBot, String summary, List<String> tags) throws IOException, MediaWikiApiErrorException {
        if (this.isEmptyEdit()) {
            return this.currentDocument;
        }
        if (this.toDelete.isEmpty() && this.getUpdatedStatements().size() == 1) {
            List<Statement> statements = this.getUpdatedStatements();
            Statement statement = statements.get(0);
            if (statement.getStatementId() == null || statement.getStatementId().isEmpty()) {
                statement = statement.withStatementId(this.guidGenerator.freshStatementId(this.currentDocument.getEntityId().getId()));
            }
            JsonNode response = action.wbSetClaim(JsonSerializer.getJsonString((Statement)statement), editAsBot, this.currentDocument.getRevisionId(), summary, tags);
            StatementImpl.PreStatement preStatement = this.getDatamodelObjectFromResponse(response, Collections.singletonList("claim"), StatementImpl.PreStatement.class);
            StatementImpl returnedStatement = preStatement.withSubject(statement.getClaim().getSubject());
            long revisionId = this.getRevisionIdFromResponse(response);
            return this.currentDocument.withStatement((Statement)returnedStatement).withRevisionId(revisionId);
        }
        if (!this.toDelete.isEmpty() && this.getUpdatedStatements().size() == this.toDelete.size() && this.toDelete.size() <= 50) {
            JsonNode response = action.wbRemoveClaims(this.toDelete, editAsBot, this.currentDocument.getRevisionId(), summary, tags);
            long revisionId = this.getRevisionIdFromResponse(response);
            return this.currentDocument.withoutStatementIds(new HashSet<String>(this.toDelete)).withRevisionId(revisionId);
        }
        return (StatementDocument)action.wbEditEntity(this.currentDocument.getEntityId().getId(), null, null, null, this.getJsonUpdateString(), false, editAsBot, this.currentDocument.getRevisionId(), summary, tags);
    }

    @JsonProperty(value="claims")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Statement> getUpdatedStatements() {
        ArrayList<Statement> updatedStatements = new ArrayList<Statement>();
        for (List<StatementWithUpdate> swus : this.toKeep.values()) {
            for (StatementWithUpdate swu : swus) {
                if (!swu.write) continue;
                updatedStatements.add(swu.statement);
            }
        }
        for (String id : this.toDelete) {
            updatedStatements.add(new DeletedStatement(id));
        }
        return updatedStatements;
    }

    @JsonIgnore
    public boolean isEmptyEdit() {
        return this.getUpdatedStatements().isEmpty();
    }

    protected void markStatementsForUpdate(StatementDocument currentDocument, List<Statement> addStatements, List<Statement> deleteStatements) {
        this.markStatementsForDeletion(currentDocument, deleteStatements);
        this.markStatementsForInsertion(currentDocument, addStatements);
    }

    protected void markStatementsForDeletion(StatementDocument currentDocument, List<Statement> deleteStatements) {
        for (Statement statement : deleteStatements) {
            boolean found = false;
            for (StatementGroup sg : currentDocument.getStatementGroups()) {
                if (!sg.getProperty().equals(statement.getMainSnak().getPropertyId())) continue;
                Statement changedStatement = null;
                for (Statement existingStatement : sg) {
                    if (existingStatement.equals(statement)) {
                        found = true;
                        this.toDelete.add(statement.getStatementId());
                        continue;
                    }
                    if (!existingStatement.getStatementId().equals(statement.getStatementId())) continue;
                    changedStatement = existingStatement;
                    break;
                }
                if (found) continue;
                StringBuilder warning = new StringBuilder();
                warning.append("Cannot delete statement (id ").append(statement.getStatementId()).append(") since it is not present in data. Statement was:\n").append(statement);
                if (changedStatement != null) {
                    warning.append("\nThe data contains another statement with the same id: maybe it has been edited? Other statement was:\n").append(changedStatement);
                }
                logger.warn(warning.toString());
            }
        }
    }

    protected void markStatementsForInsertion(StatementDocument currentDocument, List<Statement> addStatements) {
        for (Statement statement : addStatements) {
            this.addStatement(statement, true);
        }
        for (StatementGroup sg : currentDocument.getStatementGroups()) {
            if (!this.toKeep.containsKey(sg.getProperty())) continue;
            for (Statement statement : sg) {
                if (this.toDelete.contains(statement.getStatementId())) continue;
                this.addStatement(statement, false);
            }
        }
    }

    protected void addStatement(Statement statement, boolean isNew) {
        PropertyIdValue pid = statement.getMainSnak().getPropertyId();
        if (this.toKeep.containsKey(pid)) {
            List<StatementWithUpdate> statements = this.toKeep.get(pid);
            for (int i = 0; i < statements.size(); ++i) {
                Statement currentStatement = statements.get((int)i).statement;
                boolean currentIsNew = statements.get((int)i).write;
                if (!"".equals(currentStatement.getStatementId()) && currentStatement.getStatementId().equals(statement.getStatementId())) {
                    return;
                }
                Statement newStatement = this.mergeStatements(statement, currentStatement);
                if (newStatement == null) continue;
                boolean writeNewStatement = !(!isNew && newStatement.equals(statement) || !currentIsNew && newStatement.equals(currentStatement));
                statements.set(i, new StatementWithUpdate(newStatement, writeNewStatement));
                if (!"".equals(statement.getStatementId()) && !newStatement.getStatementId().equals(statement.getStatementId())) {
                    this.toDelete.add(statement.getStatementId());
                }
                if (!"".equals(currentStatement.getStatementId()) && !newStatement.getStatementId().equals(currentStatement.getStatementId())) {
                    this.toDelete.add(currentStatement.getStatementId());
                }
                return;
            }
            statements.add(new StatementWithUpdate(statement, isNew));
        } else {
            ArrayList<StatementWithUpdate> statements = new ArrayList<StatementWithUpdate>();
            statements.add(new StatementWithUpdate(statement, isNew));
            this.toKeep.put(pid, statements);
        }
    }

    private Statement mergeStatements(Statement statement1, Statement statement2) {
        if (!this.equivalentClaims(statement1.getClaim(), statement2.getClaim())) {
            return null;
        }
        StatementRank newRank = statement1.getRank();
        if (newRank == StatementRank.NORMAL) {
            newRank = statement2.getRank();
        } else if (statement2.getRank() != StatementRank.NORMAL && newRank != statement2.getRank()) {
            return null;
        }
        String newStatementId = statement1.getStatementId();
        if ("".equals(newStatementId)) {
            newStatementId = statement2.getStatementId();
        }
        List<Reference> newReferences = this.mergeReferences(statement1.getReferences(), statement2.getReferences());
        return Datamodel.makeStatement((Claim)statement1.getClaim(), newReferences, (StatementRank)newRank, (String)newStatementId);
    }

    protected List<Reference> mergeReferences(List<? extends Reference> references1, List<? extends Reference> references2) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        for (Reference reference : references1) {
            this.addBestReferenceToList(reference, result);
        }
        for (Reference reference : references2) {
            this.addBestReferenceToList(reference, result);
        }
        return result;
    }

    protected void addBestReferenceToList(Reference reference, List<Reference> referenceList) {
        for (Reference existingReference : referenceList) {
            if (!this.isSameSnakSet(existingReference.getAllSnaks(), reference.getAllSnaks())) continue;
            return;
        }
        referenceList.add(reference);
    }

    protected boolean equivalentClaims(Claim claim1, Claim claim2) {
        return claim1.getMainSnak().equals(claim2.getMainSnak()) && this.isSameSnakSet(claim1.getAllQualifiers(), claim2.getAllQualifiers());
    }

    protected boolean isSameSnakSet(Iterator<Snak> snaks1, Iterator<Snak> snaks2) {
        ArrayList<Snak> snakList1 = new ArrayList<Snak>(5);
        while (snaks1.hasNext()) {
            snakList1.add(snaks1.next());
        }
        int snakCount2 = 0;
        while (snaks2.hasNext()) {
            ++snakCount2;
            Snak snak2 = snaks2.next();
            boolean found = false;
            for (int i = 0; i < snakList1.size(); ++i) {
                if (!snak2.equals(snakList1.get(i))) continue;
                snakList1.set(i, null);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return snakCount2 == snakList1.size();
    }

    public void setGuidGenerator(GuidGenerator generator) {
        this.guidGenerator = generator;
    }

    protected long getRevisionIdFromResponse(JsonNode response) throws JsonMappingException {
        if (response == null) {
            throw new JsonMappingException("API response is null");
        }
        JsonNode entity = null;
        if (response.has("entity")) {
            entity = response.path("entity");
        } else if (response.has("pageinfo")) {
            entity = response.path("pageinfo");
        }
        if (entity != null && entity.has("lastrevid")) {
            return entity.path("lastrevid").asLong();
        }
        throw new JsonMappingException("The last revision id could not be found in API response");
    }

    protected <T> T getDatamodelObjectFromResponse(JsonNode response, List<String> path, Class<T> targetClass) throws JsonProcessingException {
        if (response == null) {
            throw new JsonMappingException("The API response is null");
        }
        JsonNode currentNode = response;
        for (String field : path) {
            if (!currentNode.has(field)) {
                throw new JsonMappingException("Field '" + field + "' not found in API response.");
            }
            currentNode = currentNode.path(field);
        }
        return (T)this.mapper.treeToValue((TreeNode)currentNode, targetClass);
    }

    static class StatementWithUpdate {
        public final Statement statement;
        public final boolean write;

        public StatementWithUpdate(Statement statement, boolean write) {
            this.statement = statement;
            this.write = write;
        }
    }

    static class DeletedStatement
    implements Statement {
        private String id;

        public DeletedStatement(String id) {
            this.id = id;
        }

        @JsonIgnore
        public Claim getClaim() {
            return null;
        }

        @JsonIgnore
        public EntityIdValue getSubject() {
            return null;
        }

        @JsonIgnore
        public Snak getMainSnak() {
            return null;
        }

        @JsonIgnore
        public List<SnakGroup> getQualifiers() {
            return null;
        }

        @JsonIgnore
        public Iterator<Snak> getAllQualifiers() {
            return null;
        }

        @JsonIgnore
        public StatementRank getRank() {
            return null;
        }

        @JsonIgnore
        public List<Reference> getReferences() {
            return null;
        }

        @JsonProperty(value="id")
        public String getStatementId() {
            return this.id;
        }

        @JsonIgnore
        public Value getValue() {
            return null;
        }

        @JsonProperty(value="remove")
        public String getRemoveCommand() {
            return "";
        }

        public Statement withStatementId(String id) {
            return null;
        }
    }
}

