/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.util.WebResourceFetcherImpl;
import org.wikidata.wdtk.wikibaseapi.BasicApiConnection;
import org.wikidata.wdtk.wikibaseapi.LoginFailedException;
import org.wikidata.wdtk.wikibaseapi.NeedLoginTokenException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorHandler;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ApiConnection {
    static final Logger logger = LoggerFactory.getLogger(ApiConnection.class);
    public static final String URL_WIKIDATA_API = "https://www.wikidata.org/w/api.php";
    public static final String URL_TEST_WIKIDATA_API = "https://test.wikidata.org/w/api.php";
    public static final String URL_WIKIMEDIA_COMMONS_API = "https://commons.wikimedia.org/w/api.php";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_LOGIN_USERNAME = "lgname";
    public static final String PARAM_LOGIN_PASSWORD = "lgpassword";
    public static final String PARAM_LOGIN_TOKEN = "lgtoken";
    public static final String PARAM_FORMAT = "format";
    public static final String PARAM_COOKIE = "Cookie";
    static final String HEADER_FIELD_SET_COOKIE = "Set-Cookie";
    static final String LOGIN_RESULT_SUCCESS = "Success";
    static final String LOGIN_WRONG_PASS = "WrongPass";
    static final String LOGIN_WRONG_PLUGIN_PASS = "WrongPluginPass";
    static final String LOGIN_NO_NAME = "NoName";
    static final String LOGIN_NOT_EXISTS = "NotExists";
    static final String LOGIN_ILLEGAL = "Illegal";
    static final String LOGIN_THROTTLED = "Throttled";
    static final String LOGIN_EMPTY_PASS = "EmptyPass";
    static final String LOGIN_CREATE_BLOCKED = "CreateBlocked";
    static final String LOGIN_BLOCKED = "Blocked";
    static final String LOGIN_NEEDTOKEN = "NeedToken";
    static final String LOGIN_WRONG_TOKEN = "WrongToken";
    private static final String ASSERT_PARAMETER = "assert";
    final String apiBaseUrl;
    boolean loggedIn = false;
    String username = "";
    @JsonIgnore
    String password = "";
    final Map<String, String> cookies;
    final Map<String, String> tokens;
    int connectTimeout = -1;
    int readTimeout = -1;
    final ObjectMapper mapper = new ObjectMapper();

    @Deprecated
    public ApiConnection(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
        this.cookies = new HashMap<String, String>();
        this.tokens = new HashMap<String, String>();
    }

    @JsonCreator
    @Deprecated
    protected ApiConnection(@JsonProperty(value="baseUrl") String apiBaseUrl, @JsonProperty(value="cookies") Map<String, String> cookies, @JsonProperty(value="username") String username, @JsonProperty(value="loggedIn") boolean loggedIn, @JsonProperty(value="tokens") Map<String, String> tokens) {
        this.apiBaseUrl = apiBaseUrl;
        this.username = username;
        this.cookies = cookies;
        this.loggedIn = loggedIn;
        this.tokens = tokens;
    }

    @Deprecated
    public static BasicApiConnection getWikidataApiConnection() {
        return new BasicApiConnection(URL_WIKIDATA_API);
    }

    @Deprecated
    public static BasicApiConnection getTestWikidataApiConnection() {
        return new BasicApiConnection(URL_TEST_WIKIDATA_API);
    }

    public static String implodeObjects(Iterable<?> objects) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object o : objects) {
            if (first) {
                first = false;
            } else {
                builder.append("|");
            }
            builder.append(o.toString());
        }
        return builder.toString();
    }

    @Deprecated
    public void login(String username, String password) throws LoginFailedException {
        try {
            String token = this.fetchToken("login");
            try {
                this.confirmLogin(token, username, password);
            }
            catch (NeedLoginTokenException e) {
                token = this.fetchToken("login");
                this.confirmLogin(token, username, password);
            }
        }
        catch (IOException | MediaWikiApiErrorException e1) {
            throw new LoginFailedException(e1.getMessage(), e1);
        }
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public String getCurrentUser() {
        return this.username;
    }

    public void logout() throws IOException, MediaWikiApiErrorException {
        if (this.loggedIn) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(PARAM_ACTION, "logout");
            params.put(PARAM_FORMAT, "json");
            params.put("token", this.getOrFetchToken("csrf"));
            this.sendJsonRequest("POST", params);
            this.loggedIn = false;
            this.username = "";
            this.password = "";
        }
    }

    public void clearCookies() throws IOException, MediaWikiApiErrorException {
        this.logout();
        this.cookies.clear();
        this.tokens.clear();
    }

    String getOrFetchToken(String tokenType) throws IOException, MediaWikiApiErrorException {
        if (this.tokens.containsKey(tokenType)) {
            return this.tokens.get(tokenType);
        }
        String value = this.fetchToken(tokenType);
        this.tokens.put(tokenType, value);
        return value;
    }

    void clearToken(String tokenType) {
        this.tokens.remove(tokenType);
    }

    private String fetchToken(String tokenType) throws IOException, MediaWikiApiErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAM_ACTION, "query");
        params.put("meta", "tokens");
        params.put("type", tokenType);
        JsonNode root = this.sendJsonRequest("POST", params);
        return root.path("query").path("tokens").path(tokenType + "token").textValue();
    }

    public JsonNode sendJsonRequest(String requestMethod, Map<String, String> parameters) throws IOException, MediaWikiApiErrorException {
        parameters.put(PARAM_FORMAT, "json");
        if (this.loggedIn) {
            parameters.put(ASSERT_PARAMETER, "user");
        }
        try (InputStream response = this.sendRequest(requestMethod, parameters);){
            JsonNode root = this.mapper.readTree(response);
            this.checkErrors(root);
            this.logWarnings(root);
            JsonNode jsonNode = root;
            return jsonNode;
        }
    }

    public InputStream sendRequest(String requestMethod, Map<String, String> parameters) throws IOException {
        String queryString = this.getQueryString(parameters);
        URL url = new URL(this.apiBaseUrl);
        HttpURLConnection connection = (HttpURLConnection)WebResourceFetcherImpl.getUrlConnection((URL)url);
        this.setupConnection(requestMethod, queryString, connection);
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(queryString);
        writer.flush();
        writer.close();
        int rc = connection.getResponseCode();
        if (rc != 200) {
            logger.warn("Error: API request returned response code " + rc);
        }
        InputStream iStream = connection.getInputStream();
        this.fillCookies(connection.getHeaderFields());
        return iStream;
    }

    public void checkErrors(JsonNode root) throws MediaWikiApiErrorException {
        if (root.has("error")) {
            JsonNode errorNode = root.path("error");
            MediaWikiApiErrorHandler.throwMediaWikiApiErrorException(errorNode.path("code").asText("UNKNOWN"), errorNode.path("info").asText("No details provided"));
        }
    }

    public void logWarnings(JsonNode root) {
        for (String warning : this.getWarnings(root)) {
            logger.warn("API warning " + warning);
        }
    }

    public void checkCredentials() throws IOException, MediaWikiApiErrorException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(PARAM_ACTION, "query");
        this.sendJsonRequest("POST", parameters);
    }

    List<String> getWarnings(JsonNode root) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (root.has("warnings")) {
            JsonNode warningNode = root.path("warnings");
            Iterator moduleIterator = warningNode.fields();
            while (moduleIterator.hasNext()) {
                Map.Entry moduleNode = (Map.Entry)moduleIterator.next();
                Iterator moduleOutputIterator = ((JsonNode)moduleNode.getValue()).elements();
                while (moduleOutputIterator.hasNext()) {
                    JsonNode moduleOutputNode = (JsonNode)moduleOutputIterator.next();
                    if (moduleOutputNode.isTextual()) {
                        warnings.add("[" + (String)moduleNode.getKey() + "]: " + moduleOutputNode.textValue());
                        continue;
                    }
                    if (moduleOutputNode.isArray()) {
                        Iterator messageIterator = moduleOutputNode.elements();
                        while (messageIterator.hasNext()) {
                            JsonNode messageNode = (JsonNode)messageIterator.next();
                            warnings.add("[" + (String)moduleNode.getKey() + "]: " + messageNode.path("html").path("*").asText(messageNode.toString()));
                        }
                        continue;
                    }
                    warnings.add("[" + (String)moduleNode.getKey() + "]: Warning was not understood. Please report this to Wikidata Toolkit. JSON source: " + moduleOutputNode.toString());
                }
            }
        }
        return warnings;
    }

    @Deprecated
    void confirmLogin(String token, String username, String password) throws IOException, LoginFailedException, MediaWikiApiErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAM_ACTION, "login");
        params.put(PARAM_LOGIN_USERNAME, username);
        params.put(PARAM_LOGIN_PASSWORD, password);
        params.put(PARAM_LOGIN_TOKEN, token);
        JsonNode root = this.sendJsonRequest("POST", params);
        String result = root.path("login").path("result").textValue();
        if (!LOGIN_RESULT_SUCCESS.equals(result)) {
            String message = this.getLoginErrorMessage(result);
            logger.warn(message);
            if (LOGIN_WRONG_TOKEN.equals(result)) {
                throw new NeedLoginTokenException(message);
            }
            throw new LoginFailedException(message);
        }
        this.loggedIn = true;
        this.username = username;
        this.password = password;
    }

    @Deprecated
    String getLoginErrorMessage(String loginResult) {
        switch (loginResult) {
            case "WrongPass": {
                return loginResult + ": Wrong Password.";
            }
            case "WrongPluginPass": {
                return loginResult + ": Wrong Password. An authentication plugin rejected the password.";
            }
            case "NotExists": {
                return loginResult + ": Username does not exist.";
            }
            case "Blocked": {
                return loginResult + ": User is blocked.";
            }
            case "EmptyPass": {
                return loginResult + ": Password is empty.";
            }
            case "NoName": {
                return loginResult + ": No user name given.";
            }
            case "CreateBlocked": {
                return loginResult + ": The wiki tried to automatically create a new account for you, but your IP address has been blocked from account creation.";
            }
            case "Illegal": {
                return loginResult + ": Username is illegal.";
            }
            case "Throttled": {
                return loginResult + ": Too many login attempts in a short time.";
            }
            case "WrongToken": {
                return loginResult + ": Token is wrong.";
            }
            case "NeedToken": {
                return loginResult + ": Token or session ID is missing.";
            }
        }
        return "Login Error: " + loginResult;
    }

    @Deprecated
    void fillCookies(Map<String, List<String>> headerFields) {
        ArrayList headerCookies = new ArrayList();
        for (Map.Entry<String, List<String>> headers : headerFields.entrySet()) {
            if (!HEADER_FIELD_SET_COOKIE.equalsIgnoreCase(headers.getKey())) continue;
            headerCookies.addAll(headers.getValue());
        }
        if (!headerCookies.isEmpty()) {
            for (String cookie : headerCookies) {
                String[] cookieResponse;
                for (String cookieLine : cookieResponse = cookie.split(";\\p{Space}??")) {
                    String[] entry = cookieLine.split("=");
                    if (entry.length == 2) {
                        this.cookies.put(entry[0], entry[1]);
                    }
                    if (entry.length != 1) continue;
                    this.cookies.put(entry[0], "");
                }
            }
        }
    }

    @Deprecated
    String getCookieString() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("; ");
            }
            result.append(entry.getKey());
            if ("".equals(entry.getValue())) continue;
            result.append("=").append(entry.getValue());
        }
        return result.toString();
    }

    String getQueryString(Map<String, String> params) {
        StringBuilder builder = new StringBuilder();
        try {
            boolean first = true;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append("&");
                }
                builder.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                builder.append("=");
                builder.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Your Java version does not support UTF-8 encoding.");
        }
        return builder.toString();
    }

    void setupConnection(String requestMethod, String queryString, HttpURLConnection connection) throws IOException {
        connection.setRequestMethod(requestMethod);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        if (this.connectTimeout >= 0) {
            connection.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout >= 0) {
            connection.setReadTimeout(this.readTimeout);
        }
        connection.setRequestProperty(PARAM_COOKIE, this.getCookieString());
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }
}

