/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.interfaces;

import org.wikidata.wdtk.datamodel.helpers.DatamodelFilter;
import org.wikidata.wdtk.datamodel.implementation.DataObjectFactoryImpl;
import org.wikidata.wdtk.datamodel.interfaces.DocumentDataFilter;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentProcessor;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;

public class EntityDocumentProcessorFilter
implements EntityDocumentProcessor {
    private final EntityDocumentProcessor entityDocumentProcessor;
    private final DatamodelFilter datamodelFilter;

    public EntityDocumentProcessorFilter(EntityDocumentProcessor entityDocumentProcessor, DocumentDataFilter filter) {
        this.entityDocumentProcessor = entityDocumentProcessor;
        this.datamodelFilter = new DatamodelFilter(new DataObjectFactoryImpl(), filter);
    }

    @Override
    public void processItemDocument(ItemDocument itemDocument) {
        this.entityDocumentProcessor.processItemDocument(this.datamodelFilter.filter(itemDocument));
    }

    @Override
    public void processPropertyDocument(PropertyDocument propertyDocument) {
        this.entityDocumentProcessor.processPropertyDocument(this.datamodelFilter.filter(propertyDocument));
    }

    @Override
    public void processLexemeDocument(LexemeDocument lexemeDocument) {
        this.entityDocumentProcessor.processLexemeDocument(this.datamodelFilter.filter(lexemeDocument));
    }
}

