/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.utils;

import de.fau.cs.osr.utils.PrinterBase;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.sweble.wikitext.parser.WtRtData;
import org.sweble.wikitext.parser.nodes.WtContentNode;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtStringNode;
import org.sweble.wikitext.parser.nodes.WtText;

public class WtRtDataPrinter {
    protected final PrinterBase p;

    protected void iterate(WtNode node) {
        Iterator iterator = node.iterator();
        while (iterator.hasNext()) {
            WtNode c = (WtNode)iterator.next();
            this.dispatch(c);
        }
    }

    protected void dispatch(WtNode node) {
        switch (node.getNodeType()) {
            case 4097: {
                this.printText((WtText)node);
                break;
            }
            case 2: {
                this.printNodeList((WtNodeList)node);
                break;
            }
            default: {
                WtRtData rtd = node.getRtd();
                if (node instanceof WtStringNode) {
                    this.printStringNode(rtd, (WtStringNode)node);
                    break;
                }
                if (node instanceof WtContentNode) {
                    this.printContentNode(rtd, (WtContentNode)node);
                    break;
                }
                this.printAnyOtherNode(rtd, node);
            }
        }
    }

    protected void printText(WtText text) {
        this.p.verbatim(text.getContent());
    }

    protected void printNodeList(WtNodeList node) {
        this.iterate(node);
    }

    protected void printContentNode(WtRtData rtd, WtContentNode contentNode) {
        if (rtd != null) {
            if (!rtd.isSuppress()) {
                this.printRtd(rtd.getField(0));
                this.iterate(contentNode);
                this.printRtd(rtd.getField(1));
            }
        } else {
            this.iterate(contentNode);
        }
    }

    protected void printStringNode(WtRtData rtd, WtStringNode contentNode) {
        if (rtd != null) {
            if (!rtd.isSuppress()) {
                this.printRtd(rtd.getField(0));
            }
        } else {
            this.p.verbatim(contentNode.getContent());
        }
    }

    protected void printAnyOtherNode(WtRtData rtd, WtNode node) {
        if (rtd != null) {
            if (!rtd.isSuppress()) {
                int i = 0;
                Iterator iterator = node.iterator();
                while (iterator.hasNext()) {
                    WtNode n = (WtNode)iterator.next();
                    this.printRtd(rtd.getField(i++));
                    this.dispatch(n);
                }
                this.printRtd(rtd.getField(i));
            }
        } else {
            this.iterate(node);
        }
    }

    protected void printRtd(Object[] fields) {
        for (Object o : fields) {
            if (o instanceof WtNode) {
                this.dispatch((WtNode)o);
                continue;
            }
            this.p.verbatim(String.valueOf(o));
        }
    }

    public static String print(WtNode node) {
        return WtRtDataPrinter.print(new StringWriter(), node).toString();
    }

    public static Writer print(Writer writer, WtNode node) {
        new WtRtDataPrinter(writer).go(node);
        return writer;
    }

    protected WtRtDataPrinter(Writer writer) {
        this.p = new PrinterBase(writer);
        this.p.setMemoize(false);
    }

    protected void go(WtNode node) {
        this.dispatch(node);
        this.p.flush();
    }
}

