/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.postprocessor;

import de.fau.cs.osr.utils.DualHashBidiMap;
import org.sweble.wikitext.parser.nodes.WtImageLink;
import org.sweble.wikitext.parser.nodes.WtNamedXmlElement;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.postprocessor.TreeBuilder;

public enum ElementType {
    PAGE,
    SECTION,
    SECTION_HEADING,
    SECTION_BODY,
    SEMIPRE,
    INLINE_IMG,
    FRAMED_IMG,
    LCT_VAR_CONV,
    UNKNOWN,
    INT_LINK,
    EXT_LINK,
    URL,
    ABBR,
    ACRONYM,
    ADDRESS,
    AREA,
    B,
    BDO,
    BIG,
    BLOCKQUOTE,
    BR,
    CAPTION,
    CENTER,
    CITE,
    CODE,
    COL,
    COLGROUP,
    DD,
    DEL,
    DFN,
    DIR,
    DIV,
    DL,
    DT,
    EM,
    FONT,
    H1,
    H2,
    H3,
    H4,
    H5,
    H6,
    HR,
    I,
    IMG,
    INS,
    KBD,
    LI,
    MAP,
    MENU,
    OL,
    P,
    PRE,
    Q,
    S,
    SAMP,
    SMALL,
    SPAN,
    STRIKE,
    STRONG,
    SUB,
    SUP,
    TABLE,
    TBODY,
    TD,
    TFOOT,
    TH,
    THEAD,
    TR,
    TT,
    U,
    UL,
    VAR;

    private static final DualHashBidiMap xmlElementTypeMap;

    public String getXmlTagName() {
        return (String)xmlElementTypeMap.getKey((Object)this);
    }

    public boolean isSpecial() {
        switch (this) {
            case PAGE: 
            case SECTION: 
            case SECTION_HEADING: 
            case SEMIPRE: 
            case INLINE_IMG: 
            case FRAMED_IMG: 
            case ADDRESS: 
            case AREA: 
            case BLOCKQUOTE: 
            case BR: 
            case CAPTION: 
            case CENTER: 
            case COL: 
            case COLGROUP: 
            case DD: 
            case DIR: 
            case DIV: 
            case DL: 
            case DT: 
            case H1: 
            case H2: 
            case H3: 
            case H4: 
            case H5: 
            case H6: 
            case HR: 
            case IMG: 
            case LI: 
            case MENU: 
            case OL: 
            case P: 
            case PRE: 
            case TABLE: 
            case TBODY: 
            case TD: 
            case TFOOT: 
            case TH: 
            case THEAD: 
            case TR: 
            case UL: {
                return true;
            }
        }
        return false;
    }

    public boolean isFormatting() {
        switch (this) {
            case INT_LINK: 
            case EXT_LINK: 
            case URL: 
            case LCT_VAR_CONV: 
            case B: 
            case BIG: 
            case CODE: 
            case EM: 
            case FONT: 
            case I: 
            case S: 
            case SMALL: 
            case STRIKE: 
            case STRONG: 
            case TT: 
            case U: {
                return true;
            }
        }
        return false;
    }

    public static ElementType getType(WtNode n) {
        switch (n.getNodeType()) {
            case 720897: {
                return PAGE;
            }
            case 720938: {
                return SECTION;
            }
            case 720937: {
                return SECTION_HEADING;
            }
            case 720941: {
                return SECTION_BODY;
            }
            case 720921: {
                return DL;
            }
            case 720923: {
                return OL;
            }
            case 720898: {
                return P;
            }
            case 720925: {
                return UL;
            }
            case 720926: {
                return LI;
            }
            case 720920: {
                return DD;
            }
            case 720922: {
                return DT;
            }
            case 720911: {
                return TABLE;
            }
            case 720912: {
                return CAPTION;
            }
            case 720914: {
                return TD;
            }
            case 720915: {
                return TH;
            }
            case 720913: {
                return TR;
            }
            case 720946: {
                return TBODY;
            }
            case 720917: {
                return B;
            }
            case 720918: {
                return I;
            }
            case 720927: {
                return SEMIPRE;
            }
            case 720899: {
                return HR;
            }
            case 720903: {
                return TreeBuilder.isInlineImage((WtImageLink)n) ? INLINE_IMG : FRAMED_IMG;
            }
            case 720902: {
                return INT_LINK;
            }
            case 720901: {
                return EXT_LINK;
            }
            case 720900: {
                return URL;
            }
            case 720932: 
            case 720934: 
            case 720935: 
            case 720936: 
            case 720944: 
            case 720945: {
                return ElementType.getType((WtNamedXmlElement)n);
            }
            case 720950: {
                return LCT_VAR_CONV;
            }
        }
        throw new AssertionError();
    }

    public static ElementType getType(WtNamedXmlElement e) {
        String name = e.getName().toLowerCase();
        if (name.isEmpty()) {
            throw new AssertionError();
        }
        if (name.charAt(0) == '@') {
            return (ElementType)((Object)xmlElementTypeMap.get((Object)name.substring(1)));
        }
        ElementType type = (ElementType)((Object)xmlElementTypeMap.get((Object)name));
        if (type == null) {
            return UNKNOWN;
        }
        return type;
    }

    static {
        xmlElementTypeMap = new DualHashBidiMap();
        xmlElementTypeMap.put((Object)"#int-link", (Object)INT_LINK);
        xmlElementTypeMap.put((Object)"#ext-link", (Object)EXT_LINK);
        xmlElementTypeMap.put((Object)"#url", (Object)URL);
        xmlElementTypeMap.put((Object)"abbr", (Object)ABBR);
        xmlElementTypeMap.put((Object)"acronym", (Object)ACRONYM);
        xmlElementTypeMap.put((Object)"address", (Object)ADDRESS);
        xmlElementTypeMap.put((Object)"area", (Object)AREA);
        xmlElementTypeMap.put((Object)"b", (Object)B);
        xmlElementTypeMap.put((Object)"bdo", (Object)BDO);
        xmlElementTypeMap.put((Object)"big", (Object)BIG);
        xmlElementTypeMap.put((Object)"blockquote", (Object)BLOCKQUOTE);
        xmlElementTypeMap.put((Object)"br", (Object)BR);
        xmlElementTypeMap.put((Object)"caption", (Object)CAPTION);
        xmlElementTypeMap.put((Object)"center", (Object)CENTER);
        xmlElementTypeMap.put((Object)"cite", (Object)CITE);
        xmlElementTypeMap.put((Object)"code", (Object)CODE);
        xmlElementTypeMap.put((Object)"col", (Object)COL);
        xmlElementTypeMap.put((Object)"colgroup", (Object)COLGROUP);
        xmlElementTypeMap.put((Object)"dd", (Object)DD);
        xmlElementTypeMap.put((Object)"del", (Object)DEL);
        xmlElementTypeMap.put((Object)"dfn", (Object)DFN);
        xmlElementTypeMap.put((Object)"dir", (Object)DIR);
        xmlElementTypeMap.put((Object)"div", (Object)DIV);
        xmlElementTypeMap.put((Object)"dl", (Object)DL);
        xmlElementTypeMap.put((Object)"dt", (Object)DT);
        xmlElementTypeMap.put((Object)"em", (Object)EM);
        xmlElementTypeMap.put((Object)"font", (Object)FONT);
        xmlElementTypeMap.put((Object)"h1", (Object)H1);
        xmlElementTypeMap.put((Object)"h2", (Object)H2);
        xmlElementTypeMap.put((Object)"h3", (Object)H3);
        xmlElementTypeMap.put((Object)"h4", (Object)H4);
        xmlElementTypeMap.put((Object)"h5", (Object)H5);
        xmlElementTypeMap.put((Object)"h6", (Object)H6);
        xmlElementTypeMap.put((Object)"hr", (Object)HR);
        xmlElementTypeMap.put((Object)"i", (Object)I);
        xmlElementTypeMap.put((Object)"ins", (Object)INS);
        xmlElementTypeMap.put((Object)"kbd", (Object)KBD);
        xmlElementTypeMap.put((Object)"li", (Object)LI);
        xmlElementTypeMap.put((Object)"map", (Object)MAP);
        xmlElementTypeMap.put((Object)"menu", (Object)MENU);
        xmlElementTypeMap.put((Object)"ol", (Object)OL);
        xmlElementTypeMap.put((Object)"p", (Object)P);
        xmlElementTypeMap.put((Object)"pre", (Object)PRE);
        xmlElementTypeMap.put((Object)"q", (Object)Q);
        xmlElementTypeMap.put((Object)"s", (Object)S);
        xmlElementTypeMap.put((Object)"samp", (Object)SAMP);
        xmlElementTypeMap.put((Object)"small", (Object)SMALL);
        xmlElementTypeMap.put((Object)"span", (Object)SPAN);
        xmlElementTypeMap.put((Object)"strike", (Object)STRIKE);
        xmlElementTypeMap.put((Object)"strong", (Object)STRONG);
        xmlElementTypeMap.put((Object)"sub", (Object)SUB);
        xmlElementTypeMap.put((Object)"sup", (Object)SUP);
        xmlElementTypeMap.put((Object)"table", (Object)TABLE);
        xmlElementTypeMap.put((Object)"tbody", (Object)TBODY);
        xmlElementTypeMap.put((Object)"td", (Object)TD);
        xmlElementTypeMap.put((Object)"tfoot", (Object)TFOOT);
        xmlElementTypeMap.put((Object)"th", (Object)TH);
        xmlElementTypeMap.put((Object)"thead", (Object)THEAD);
        xmlElementTypeMap.put((Object)"tr", (Object)TR);
        xmlElementTypeMap.put((Object)"tt", (Object)TT);
        xmlElementTypeMap.put((Object)"u", (Object)U);
        xmlElementTypeMap.put((Object)"ul", (Object)UL);
        xmlElementTypeMap.put((Object)"var", (Object)VAR);
        xmlElementTypeMap.put((Object)"#inline-img", (Object)INLINE_IMG);
        xmlElementTypeMap.put((Object)"#framed-img", (Object)FRAMED_IMG);
        xmlElementTypeMap.put((Object)"#semipre", (Object)SEMIPRE);
        xmlElementTypeMap.put((Object)"#lct-var-conv", (Object)LCT_VAR_CONV);
    }
}

