/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.parser;

import de.fau.cs.osr.utils.StringTools;
import de.fau.cs.osr.utils.XmlEntityResolver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.parser.LinkTargetException;

public class LinkTargetParser {
    private String title;
    private String fragment;
    private String namespace;
    private String interwiki;
    private boolean initialColon;
    private static final Pattern bidiCharPattern = Pattern.compile("[\u200e\u200f\u202a-\u202e]");
    private static final Pattern spacePlusPattern = Pattern.compile("[ _\u00a0\u1680\u180e\u2000-\u200a\u2028\u2029\u202f\u205f\u3000]+");
    private static final Pattern namespaceSeparatorPattern = Pattern.compile("^(.+?)_*:_*(.*)$");
    private static final Pattern invalidTitle = Pattern.compile("(%[0-9A-Fa-f]{2})|(&((?::|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\ud800\\uDC00-\udb7f\udfff])(?:(?::|[A-Z]|_|[a-z]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u02FF]|[\\u0370-\\u037D]|[\\u037F-\\u1FFF]|[\\u200C-\\u200D]|[\\u2070-\\u218F]|[\\u2C00-\\u2FEF]|[\\u3001-\\uD7FF]|[\\uF900-\\uFDCF]|[\\uFDF0-\\uFFFD]|[\ud800\\uDC00-\udb7f\udfff])|-|\\.|[0-9]|\\u00B7|[\\u0300-\\u036F]|[\\u203F-\\u2040])*);)|((&#[0-9]+;)|(&#x[0-9A-Fa-f]+;))|(^\\.\\.?($|/))|(/\\.\\.?/)|(/\\.\\.?$)|(~~~)|[\\u0000-\\u001F\\u007F\\uFFFD<>{}\\|\\[\\]]");

    public void parse(ParserConfig config, String target) throws LinkTargetException {
        String result = target;
        result = LinkTargetParser.urlDecode(result);
        result = LinkTargetParser.xmlDecode(config, result);
        Matcher matcher = bidiCharPattern.matcher(result);
        result = matcher.replaceAll("");
        if ((result = StringTools.trim((String)result)).isEmpty()) {
            throw new LinkTargetException(LinkTargetException.Reason.EMPTY_TARGET, target);
        }
        if (result.charAt(0) == ':') {
            this.initialColon = true;
            result = result.substring(1);
            result = StringTools.trimUnderscores((String)result);
        }
        result = this.identifyNamespaces(config, target, result);
        result = this.extractFragment(result);
        matcher = invalidTitle.matcher(result = result.replace('_', ' '));
        if (matcher.find()) {
            throw new LinkTargetException(LinkTargetException.Reason.INVALID_ENTITIES, target, matcher.group());
        }
        matcher = spacePlusPattern.matcher(result);
        if ((result = matcher.replaceAll("_")).isEmpty() && this.interwiki == null && this.namespace != null) {
            throw new LinkTargetException(LinkTargetException.Reason.ONLY_NAMESPACE, target);
        }
        this.title = result;
    }

    private String identifyNamespaces(ParserConfig config, String target, String result) throws LinkTargetException {
        Matcher matcher = namespaceSeparatorPattern.matcher(result);
        if (matcher.matches()) {
            String nsName = matcher.group(1);
            if (config.isNamespace(nsName)) {
                result = matcher.group(2);
                this.namespace = nsName;
                this.checkNoNsAfterTalkNs(config, target, result, nsName);
            } else if (config.isInterwikiName(nsName)) {
                result = matcher.group(2);
                if (config.isIwPrefixOfThisWiki(nsName)) {
                    if (result.isEmpty()) {
                        throw new LinkTargetException(LinkTargetException.Reason.NO_ARTICLE_TITLE, target);
                    }
                    matcher = namespaceSeparatorPattern.matcher(result);
                    if (matcher.matches()) {
                        nsName = matcher.group(1);
                        if (config.isNamespace(nsName)) {
                            result = matcher.group(2);
                            this.namespace = nsName;
                            this.checkNoNsAfterTalkNs(config, target, result, nsName);
                        } else if (config.isInterwikiName(nsName)) {
                            throw new LinkTargetException(LinkTargetException.Reason.IW_IW_LINK, target, nsName);
                        }
                    }
                } else {
                    this.interwiki = nsName;
                    if (!result.isEmpty() && result.charAt(0) == ':') {
                        this.initialColon = true;
                        result = result.substring(1);
                        result = StringTools.trimUnderscores((String)result);
                    }
                }
            }
        }
        return result;
    }

    private void checkNoNsAfterTalkNs(ParserConfig config, String target, String result, String nsName) throws LinkTargetException {
        Matcher matcher;
        if (config.isTalkNamespace(nsName) && (matcher = namespaceSeparatorPattern.matcher(result)).matches() && (config.isNamespace(nsName = matcher.group(1)) || config.isInterwikiName(nsName))) {
            throw new LinkTargetException(LinkTargetException.Reason.TALK_NS_IW_LINK, target, nsName);
        }
    }

    private String extractFragment(String result) {
        int i = result.indexOf(35);
        if (i != -1) {
            String fragment = result.substring(i + 1);
            this.fragment = StringTools.trimUnderscores((String)fragment);
            result = result.substring(0, i);
            result = StringTools.trimUnderscores((String)result);
        }
        return result;
    }

    private static String urlDecode(String text) {
        if (text.indexOf(37) >= 0) {
            return StringTools.urlDecode((String)text);
        }
        return text;
    }

    private static String xmlDecode(ParserConfig config, String text) {
        if (text.indexOf(38) >= 0) {
            return StringTools.xmlDecode((String)text, (XmlEntityResolver)config);
        }
        return text;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getInterwiki() {
        return this.interwiki;
    }

    public boolean isInitialColon() {
        return this.initialColon;
    }
}

