/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.comparer;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.comparer.AstComparer;
import de.fau.cs.osr.utils.ComparisonException;
import de.fau.cs.osr.utils.DeepComparer;
import de.fau.cs.osr.utils.DeepComparerDelegate;
import java.util.HashSet;
import java.util.Set;
import org.sweble.wikitext.parser.nodes.WtBody;
import org.sweble.wikitext.parser.nodes.WtContentNode;
import org.sweble.wikitext.parser.nodes.WtLinkOptions;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtTemplateArguments;
import org.sweble.wikitext.parser.nodes.WtXmlAttributes;

public class WtComparer {
    private static DeepComparerDelegate delegate;

    public static void compareAndThrow(AstNode<?> rootA, AstNode<?> rootB, boolean compareAttributes, boolean compareLocation) throws ComparisonException {
        WtComparer.makeComparer(compareAttributes, compareLocation).compare(rootA, rootB);
    }

    public static boolean compareNoThrow(AstNode<?> rootA, AstNode<?> rootB, boolean compareAttributes, boolean compareLocation) {
        try {
            WtComparer.compareAndThrow(rootA, rootB, compareAttributes, compareLocation);
            return true;
        }
        catch (ComparisonException e) {
            return false;
        }
    }

    public static synchronized DeepComparer makeComparer(boolean compareAttributes, boolean compareLocation) {
        if (delegate == null) {
            delegate = new EmptyContentNodeComparer();
        }
        DeepComparer comparer = AstComparer.makeComparer((boolean)compareAttributes, (boolean)compareLocation);
        comparer.addComparer(delegate);
        return comparer;
    }

    public static class EmptyContentNodeComparer
    implements DeepComparerDelegate {
        private final Set<WtNode> emptyImmutables = new HashSet<WtNode>();

        public EmptyContentNodeComparer() {
            this.emptyImmutables.add(WtBody.EMPTY);
            this.emptyImmutables.add(WtLinkOptions.EMPTY);
            this.emptyImmutables.add(WtNodeList.EMPTY);
            this.emptyImmutables.add(WtTemplateArguments.EMPTY);
            this.emptyImmutables.add(WtXmlAttributes.EMPTY);
        }

        public boolean compare(Object a, Object b, DeepComparer comparer) throws ComparisonException {
            if (this.emptyImmutables.contains(a)) {
                if (!((WtContentNode.WtEmptyContentNode)a).equals(b)) {
                    throw new ComparisonException(a, b);
                }
                return true;
            }
            if (this.emptyImmutables.contains(b)) {
                if (((WtContentNode.WtEmptyContentNode)b).equals(a)) {
                    throw new ComparisonException(a, b);
                }
                return true;
            }
            return false;
        }
    }
}

