/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.block;

import java.util.Iterator;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.tdb.base.block.Block;
import org.apache.jena.tdb.base.block.BlockException;
import org.apache.jena.tdb.base.block.BlockMgr;
import org.slf4j.Logger;

public abstract class BlockMgrBase
implements BlockMgr {
    protected final int blockSize;
    private String label;

    protected abstract Logger log();

    protected BlockMgrBase(String label, int blockSize) {
        this.label = FileOps.basename((String)label);
        this.blockSize = blockSize;
    }

    @Override
    public final Block allocate(int blkSize) {
        if (blkSize > 0 && blkSize != this.blockSize) {
            throw new BlockException("Fixed blocksize BlockMgr: request= " + blkSize + "  fixed size=" + this.blockSize);
        }
        return this.allocate();
    }

    protected abstract Block allocate();

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public void beginIterator(Iterator<?> iter) {
    }

    @Override
    public void endIterator(Iterator<?> iter) {
    }

    @Override
    public void endUpdate() {
    }

    @Override
    public void beginUpdate() {
    }

    @Override
    public void beginRead() {
    }

    @Override
    public void endRead() {
    }
}

