/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.javassist.support;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.NotFoundException;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.FieldInfo;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.powermock.core.IndicateReloadClass;
import org.powermock.core.MockGateway;
import org.powermock.core.transformers.TransformStrategy;
import org.powermock.core.transformers.javassist.support.TransformerHelper;

public final class PowerMockExpressionEditor
extends ExprEditor {
    private final CtClass clazz;
    private final Class<?> mockGetawayClass;
    private final TransformStrategy strategy;

    public PowerMockExpressionEditor(TransformStrategy strategy, CtClass clazz, Class<?> mockGetawayClass) {
        this.strategy = strategy;
        this.clazz = clazz;
        this.mockGetawayClass = mockGetawayClass;
    }

    public void edit(NewExpr e) throws CannotCompileException {
        String code = "Object instance =" + MockGateway.class.getName() + ".newInstanceCall($type,$args,$sig);if(instance != " + MockGateway.class.getName() + ".PROCEED) {\tif(instance instanceof java.lang.reflect.Constructor) {\t\t$_ = ($r) sun.reflect.ReflectionFactory.getReflectionFactory().newConstructorForSerialization($type, java.lang.Object.class.getDeclaredConstructor(null)).newInstance(null);\t} else {\t\t$_ = ($r) instance;\t}} else {\t$_ = $proceed($$);}";
        e.replace(code);
    }

    public void edit(MethodCall m) throws CannotCompileException {
        try {
            CtMethod method = m.getMethod();
            CtClass declaringClass = method.getDeclaringClass();
            if (declaringClass != null && TransformerHelper.shouldTreatAsSystemClassCall(declaringClass)) {
                StringBuilder code = new StringBuilder();
                code.append("{Object classOrInstance = null; if($0!=null){classOrInstance = $0;} else { classOrInstance = $class;}");
                code.append("Object value =  ").append(MockGateway.class.getName()).append(".methodCall(").append("classOrInstance,\"").append(m.getMethodName()).append("\",$args, $sig,\"").append(TransformerHelper.getReturnTypeAsString(method)).append("\");");
                code.append("if(value == ").append(MockGateway.class.getName()).append(".PROCEED) {");
                code.append("\t$_ = $proceed($$);");
                code.append("} else {");
                String correctReturnValueType = TransformerHelper.getCorrectReturnValueType(method.getReturnType());
                if (!"".equals(correctReturnValueType)) {
                    code.append("\t$_ = ").append(correctReturnValueType).append(";");
                }
                code.append("}}");
                m.replace(code.toString());
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public void edit(ConstructorCall c) throws CannotCompileException {
        if (this.strategy != TransformStrategy.INST_REDEFINE && !c.getClassName().startsWith("java.lang")) {
            CtClass superclass;
            try {
                superclass = this.clazz.getSuperclass();
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
            this.addNewDeferConstructor(this.clazz);
            StringBuilder code = new StringBuilder();
            code.append("{Object value =").append(this.mockGetawayClass.getName()).append(".constructorCall($class, $args, $sig);");
            code.append("if (value != ").append(MockGateway.class.getName()).append(".PROCEED){");
            if (superclass.getName().equals(Object.class.getName())) {
                code.append(" super();");
            } else {
                code.append(" super((").append(IndicateReloadClass.class.getName()).append(") null);");
            }
            code.append("} else {");
            code.append("   $proceed($$);");
            code.append("}}");
            c.replace(code.toString());
        }
    }

    public void edit(FieldAccess f) throws CannotCompileException {
        if (f.isReader()) {
            FieldInfo fieldInfo;
            CtClass returnTypeAsCtClass;
            try {
                CtField field = f.getField();
                returnTypeAsCtClass = field.getType();
                fieldInfo = field.getFieldInfo2();
            }
            catch (NotFoundException e) {
                return;
            }
            if (TransformerHelper.isNotSyntheticField(fieldInfo)) {
                String code = "{Object value =  " + MockGateway.class.getName() + ".fieldCall($0,$class,\"" + f.getFieldName() + "\",$type);if(value == " + MockGateway.class.getName() + ".PROCEED) {\t$_ = $proceed($$);} else {\t$_ = " + TransformerHelper.getCorrectReturnValueType(returnTypeAsCtClass) + ";}}";
                f.replace(code);
            }
        }
    }

    private void addNewDeferConstructor(CtClass clazz) throws CannotCompileException {
        CtClass constructorType;
        CtClass superClass;
        try {
            superClass = clazz.getSuperclass();
        }
        catch (NotFoundException e1) {
            throw new IllegalArgumentException("Internal error: Failed to get superclass for " + clazz.getName() + " when about to create a new default constructor.");
        }
        ClassPool classPool = clazz.getClassPool();
        try {
            constructorType = classPool.get(IndicateReloadClass.class.getName());
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Internal error: failed to get the " + IndicateReloadClass.class.getName() + " when added defer constructor.");
        }
        clazz.defrost();
        if (superClass.getName().equals(Object.class.getName())) {
            try {
                clazz.addConstructor(CtNewConstructor.make((CtClass[])new CtClass[]{constructorType}, (CtClass[])new CtClass[0], (String)"{super();}", (CtClass)clazz));
            }
            catch (DuplicateMemberException duplicateMemberException) {}
        } else {
            this.addNewDeferConstructor(superClass);
            try {
                clazz.addConstructor(CtNewConstructor.make((CtClass[])new CtClass[]{constructorType}, (CtClass[])new CtClass[0], (String)"{super($$);}", (CtClass)clazz));
            }
            catch (DuplicateMemberException duplicateMemberException) {
                // empty catch block
            }
        }
    }
}

