/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.SnakGroupImpl;
import org.wikidata.wdtk.datamodel.implementation.SnakImpl;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.util.NestedIterator;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ReferenceImpl
implements Reference {
    private List<SnakGroup> snakGroups;
    private final Map<String, List<Snak>> snaks;
    private final List<String> propertyOrder;
    private final String hash;

    public ReferenceImpl(List<SnakGroup> groups) {
        this.propertyOrder = new ArrayList<String>(groups.size());
        this.snaks = new HashMap<String, List<Snak>>(groups.size());
        this.hash = null;
        for (SnakGroup group : groups) {
            this.propertyOrder.add(group.getProperty().getId());
            this.snaks.put(group.getProperty().getId(), group.getSnaks());
        }
    }

    @JsonCreator
    protected ReferenceImpl(@JsonProperty(value="snaks") Map<String, List<SnakImpl>> snaks, @JsonProperty(value="snaks-order") List<String> propertyOrder, @JsonProperty(value="hash") String hash) {
        this.snaks = new HashMap<String, List<Snak>>(snaks.size());
        for (Map.Entry<String, List<SnakImpl>> entry : snaks.entrySet()) {
            this.snaks.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        this.propertyOrder = propertyOrder;
        this.hash = hash;
    }

    @Override
    @JsonIgnore
    public List<SnakGroup> getSnakGroups() {
        if (this.snakGroups == null) {
            this.snakGroups = SnakGroupImpl.makeSnakGroups(this.snaks, this.propertyOrder);
        }
        return this.snakGroups;
    }

    @JsonProperty(value="snaks")
    public Map<String, List<Snak>> getSnaks() {
        return Collections.unmodifiableMap(this.snaks);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getHash() {
        return this.hash;
    }

    @JsonProperty(value="snaks-order")
    public List<String> getPropertyOrder() {
        return Collections.unmodifiableList(this.propertyOrder);
    }

    @Override
    @JsonIgnore
    public Iterator<Snak> getAllSnaks() {
        return new NestedIterator(this.getSnakGroups());
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsReference(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

