/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import org.wikidata.wdtk.datamodel.helpers.EntityDocumentBuilder;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;

public class PropertyDocumentBuilder
extends EntityDocumentBuilder<PropertyDocumentBuilder, PropertyDocument> {
    private final DatatypeIdValue datatype;

    protected PropertyDocumentBuilder(PropertyIdValue propertyIdValue, DatatypeIdValue datatype) {
        super(propertyIdValue);
        this.datatype = datatype;
    }

    protected PropertyDocumentBuilder(PropertyDocument initialDocument) {
        super(initialDocument);
        this.datatype = initialDocument.getDatatype();
    }

    public static PropertyDocumentBuilder forPropertyIdAndDatatype(PropertyIdValue propertyIdValue, DatatypeIdValue datatype) {
        return new PropertyDocumentBuilder(propertyIdValue, datatype);
    }

    public static PropertyDocumentBuilder fromPropertyDocument(PropertyDocument initialDocument) {
        return new PropertyDocumentBuilder(initialDocument);
    }

    public static PropertyDocumentBuilder forPropertyIdAndDatatype(PropertyIdValue propertyIdValue, String datatypeId) {
        return PropertyDocumentBuilder.forPropertyIdAndDatatype(propertyIdValue, factory.getDatatypeIdValue(datatypeId));
    }

    @Override
    public PropertyDocumentBuilder withEntityId(EntityIdValue entityId) {
        if (!(entityId instanceof PropertyIdValue)) {
            throw new IllegalArgumentException("The entity id of a PropertyDocument must be an PropertyIdValue.");
        }
        return (PropertyDocumentBuilder)super.withEntityId(entityId);
    }

    @Override
    public PropertyDocument build() {
        this.prepareBuild();
        return factory.getPropertyDocument((PropertyIdValue)this.entityIdValue, this.labels, this.descriptions, this.aliases, this.getStatementGroups(), this.datatype, this.revisionId);
    }

    @Override
    protected PropertyDocumentBuilder getThis() {
        return this;
    }
}

