/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import java.io.IOException;
import java.util.ArrayList;

public class CSVParser {
    @Deprecated
    final char separator;
    private final String sepString;
    final char quotechar;
    final char escape;
    final boolean strictQuotes;
    private String pending;
    private boolean inField = false;
    final boolean ignoreLeadingWhiteSpace;
    final boolean ignoreQuotations;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final int INITIAL_READ_SIZE = 128;
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';
    public static final boolean DEFAULT_STRICT_QUOTES = false;
    public static final boolean DEFAULT_IGNORE_LEADING_WHITESPACE = true;
    public static final boolean DEFAULT_IGNORE_QUOTATIONS = false;
    static final char NULL_CHARACTER = '\u0000';

    public CSVParser() {
        this(',', '\"', '\\');
    }

    public CSVParser(char separator) {
        this(String.valueOf(separator), '\"', '\\');
    }

    public CSVParser(String separator) {
        this(separator, '\"', '\\');
    }

    public CSVParser(char separator, char quotechar) {
        this(String.valueOf(separator), quotechar, '\\');
    }

    public CSVParser(String separator, char quotechar) {
        this(separator, quotechar, '\\');
    }

    public CSVParser(char separator, char quotechar, char escape) {
        this(String.valueOf(separator), quotechar, escape, false);
    }

    public CSVParser(String separator, char quotechar, char escape) {
        this(separator, quotechar, escape, false);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes) {
        this(String.valueOf(separator), quotechar, escape, strictQuotes, true);
    }

    public CSVParser(String separator, char quotechar, char escape, boolean strictQuotes) {
        this(separator, quotechar, escape, strictQuotes, true);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(String.valueOf(separator), quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, false);
    }

    public CSVParser(String separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, false);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean ignoreQuotations) {
        this(String.valueOf(separator), quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, ignoreQuotations);
    }

    public CSVParser(String separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean ignoreQuotations) {
        if (separator == null || separator.length() == 1 && separator.charAt(0) == '\u0000') {
            throw new UnsupportedOperationException("The separator character must be defined!");
        }
        if (this.anyCharactersAreTheSame(separator, quotechar, escape)) {
            throw new UnsupportedOperationException("The separator, quote, and escape characters must be different!");
        }
        this.separator = separator.length() == 1 ? separator.charAt(0) : (char)'\u0000';
        this.sepString = separator;
        this.quotechar = quotechar;
        this.escape = escape;
        this.strictQuotes = strictQuotes;
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
        this.ignoreQuotations = ignoreQuotations;
    }

    private boolean anyCharactersAreTheSame(String separator, char quotechar, char escape) {
        return separator.indexOf(quotechar) > -1 || separator.indexOf(escape) > -1 || this.isSameCharacter(quotechar, escape);
    }

    private boolean isSameCharacter(char c1, char c2) {
        return c1 != '\u0000' && c1 == c2;
    }

    public boolean isPending() {
        return this.pending != null;
    }

    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    private String[] parseLine(String nextLine, boolean multi) throws IOException {
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending != null) {
                String s = this.pending;
                this.pending = null;
                return new String[]{s};
            }
            return null;
        }
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(128);
        boolean inQuotes = false;
        int separatorLength = this.sepString.length();
        int lineLength = nextLine.length();
        if (this.pending != null) {
            sb.append(this.pending);
            this.pending = null;
            inQuotes = !this.ignoreQuotations;
        } else {
            this.inField = false;
        }
        int i = 0;
        while (i < lineLength) {
            char c = nextLine.charAt(i);
            if (this.escape != '\u0000' && c == this.escape) {
                if (this.inField && this.isNextCharacterEscapable(nextLine, i)) {
                    sb.append(nextLine.charAt(i + 1));
                    ++i;
                }
            } else if (c == this.quotechar) {
                if (this.inField && this.isNextCharacterEscapedQuote(nextLine, i)) {
                    sb.append(nextLine.charAt(i + 1));
                    ++i;
                } else {
                    boolean shouldToggle = false;
                    if (!(this.strictQuotes || i <= 0 || separatorLength <= i && nextLine.substring(i - separatorLength, i).equals(this.sepString) || i >= lineLength - 1 || i + separatorLength < lineLength && nextLine.substring(i + 1, i + 1 + separatorLength).equals(this.sepString))) {
                        if (this.ignoreLeadingWhiteSpace && sb.length() > 0 && this.isAllWhiteSpace(sb)) {
                            sb = new StringBuilder(128);
                            inQuotes = true;
                            this.inField = true;
                        } else {
                            sb.append(c);
                        }
                    } else {
                        shouldToggle = true;
                    }
                    if (shouldToggle) {
                        inQuotes = !inQuotes;
                        this.inField = !this.inField;
                    }
                }
            } else if ((!inQuotes || this.ignoreQuotations) && c == this.sepString.charAt(0) && lineLength >= i + separatorLength && nextLine.substring(i, i + separatorLength).equals(this.sepString)) {
                tokensOnThisLine.add(sb.toString());
                sb = new StringBuilder(128);
                i += separatorLength - 1;
                this.inField = false;
            } else if (!this.strictQuotes || inQuotes && !this.ignoreQuotations) {
                sb.append(c);
                this.inField = true;
            }
            ++i;
        }
        if (inQuotes && !this.ignoreQuotations) {
            if (multi) {
                sb.append("\n");
                this.pending = sb.toString();
                sb = null;
            } else {
                throw new IOException("Un-terminated quoted field at end of CSV line");
            }
        }
        if (sb != null) {
            tokensOnThisLine.add(sb.toString());
        }
        return tokensOnThisLine.toArray(new String[tokensOnThisLine.size()]);
    }

    private boolean isNextCharacterEscapedQuote(String nextLine, int i) {
        return nextLine.length() > i + 1 && nextLine.charAt(i + 1) == this.quotechar;
    }

    protected boolean isNextCharacterEscapable(String nextLine, int i) {
        return this.escape != '\u0000' && nextLine.length() > i + 1 && (nextLine.charAt(i + 1) == this.quotechar || nextLine.charAt(i + 1) == this.escape);
    }

    protected boolean isAllWhiteSpace(CharSequence sb) {
        boolean result = true;
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++i;
        }
        return result;
    }

    public String getSeparator() {
        return this.sepString;
    }
}

