/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.vicino;

import edu.mit.simile.vicino.Operator;
import edu.mit.simile.vicino.clustering.Clusterer;
import edu.mit.simile.vicino.clustering.NGramClusterer;
import edu.mit.simile.vicino.clustering.VPTreeClusterer;
import edu.mit.simile.vicino.distances.Distance;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Cluster
extends Operator {
    public static void main(String[] args) throws Exception {
        new Cluster().init(args);
    }

    public void init(String[] args) throws Exception {
        Distance distance = Cluster.getDistance(args[0]);
        List<String> strings = Cluster.getStrings(args[1]);
        double radius = Double.parseDouble(args[2]);
        int blocking_size = Integer.parseInt(args[3]);
        long vptree_start = System.currentTimeMillis();
        VPTreeClusterer vptree_clusterer = new VPTreeClusterer(distance);
        for (String s : strings) {
            ((Clusterer)vptree_clusterer).populate(s);
        }
        List<Set<Serializable>> vptree_clusters = ((Clusterer)vptree_clusterer).getClusters(radius);
        long vptree_elapsed = System.currentTimeMillis() - vptree_start;
        int vptree_distances = distance.getCount();
        distance.resetCounter();
        long ngram_start = System.currentTimeMillis();
        NGramClusterer ngram_clusterer = new NGramClusterer(distance, blocking_size);
        for (String s : strings) {
            ((Clusterer)ngram_clusterer).populate(s);
        }
        List<Set<Serializable>> ngram_clusters = ((Clusterer)ngram_clusterer).getClusters(radius);
        long ngram_elapsed = System.currentTimeMillis() - ngram_start;
        int ngram_distances = distance.getCount();
        distance.resetCounter();
        Cluster.log("VPTree found " + vptree_clusters.size() + " in " + vptree_elapsed + " ms with " + vptree_distances + " distances\n");
        Cluster.log("NGram  found " + ngram_clusters.size() + " in " + ngram_elapsed + " ms with " + ngram_distances + " distances\n");
        if (vptree_clusters.size() > ngram_clusters.size()) {
            Cluster.log("VPTree clusterer found these clusters the other method couldn't: ");
            this.diff(vptree_clusters, ngram_clusters);
        } else if (ngram_clusters.size() > vptree_clusters.size()) {
            Cluster.log("NGram clusterer found these clusters the other method couldn't: ");
            this.diff(ngram_clusters, vptree_clusters);
        }
        System.exit(0);
    }

    private void diff(List<Set<Serializable>> more, List<Set<Serializable>> base) {
        HashSet<Set<Serializable>> holder = new HashSet<Set<Serializable>>(base.size());
        for (Set<Serializable> s : base) {
            holder.add(s);
        }
        for (Set<Serializable> s : more) {
            if (holder.contains(s)) continue;
            this.printCluster(s);
        }
    }

    private void printCluster(Set<Serializable> cluster) {
        for (Serializable s : cluster) {
            Cluster.log(s.toString());
        }
        Cluster.log("");
    }
}

