/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.walker;

import org.apache.jena.sparql.algebra.walker.ExprVisitorFunction;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprNone;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementDataset;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.ElementVisitor;

public class ElementWalker_New {
    public static void walk(Element el, ElementVisitor visitor) {
        ElementWalker_New.walk(el, visitor, null);
    }

    public static void walk(Element el, ElementVisitor elVisitor, ExprVisitor exprVisitor) {
        EltWalker w = new EltWalker(elVisitor, exprVisitor);
        el.visit(w);
    }

    public static class EltWalker
    implements ElementVisitor,
    ExprVisitorFunction {
        protected final ElementVisitor elementVisitor;
        protected final ExprVisitor exprVisitor;

        protected EltWalker(ElementVisitor visitor, ExprVisitor exprVisitor) {
            this.elementVisitor = visitor;
            this.exprVisitor = exprVisitor;
        }

        @Override
        public void visit(ElementTriplesBlock el) {
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementFilter el) {
            el.getExpr().visit(this);
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementAssign el) {
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementBind el) {
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementData el) {
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementUnion el) {
            for (Element e2 : el.getElements()) {
                e2.visit(this);
            }
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementGroup el) {
            for (Element e2 : el.getElements()) {
                e2.visit(this);
            }
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementOptional el) {
            if (el.getOptionalElement() != null) {
                el.getOptionalElement().visit(this);
            }
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementDataset el) {
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementNamedGraph el) {
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementService el) {
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementExists el) {
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementNotExists el) {
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementMinus el) {
            if (el.getMinusElement() != null) {
                el.getMinusElement().visit(this);
            }
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementSubQuery el) {
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ElementPathBlock el) {
            this.elementVisitor.visit(el);
        }

        @Override
        public void visit(ExprFunction0 func) {
            this.visitExprFunction(func);
        }

        @Override
        public void visit(ExprFunction1 func) {
            this.visitExprFunction(func);
        }

        @Override
        public void visit(ExprFunction2 func) {
            this.visitExprFunction(func);
        }

        @Override
        public void visit(ExprFunction3 func) {
            this.visitExprFunction(func);
        }

        @Override
        public void visit(ExprFunctionN func) {
            this.visitExprFunction(func);
        }

        @Override
        public void visitExprFunction(ExprFunction func) {
            for (int i = 1; i <= func.numArgs(); ++i) {
                Expr expr = func.getArg(i);
                if (expr == null) {
                    Expr.NONE.visit(this);
                    continue;
                }
                expr.visit(this);
            }
            func.visit(this.exprVisitor);
        }

        @Override
        public void visit(ExprFunctionOp funcOp) {
            funcOp.getElement().visit(this);
            funcOp.visit(this.exprVisitor);
        }

        @Override
        public void visit(NodeValue nv) {
            nv.visit(this.exprVisitor);
        }

        @Override
        public void visit(ExprVar v) {
            v.visit(this.exprVisitor);
        }

        @Override
        public void visit(ExprNone v) {
            v.visit(this.exprVisitor);
        }

        @Override
        public void visit(ExprAggregator eAgg) {
            eAgg.visit(this.exprVisitor);
        }
    }
}

