/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetReader;
import org.apache.jena.riot.resultset.ResultSetReaderFactory;
import org.apache.jena.riot.thrift.BinRDF;
import org.apache.jena.sparql.resultset.CSVInput;
import org.apache.jena.sparql.resultset.JSONInput;
import org.apache.jena.sparql.resultset.TSVInput;
import org.apache.jena.sparql.resultset.XMLInput;
import org.apache.jena.sparql.util.Context;

public class ResultSetReaderRegistry {
    private static Map<Lang, ResultSetReaderFactory> registry = new HashMap<Lang, ResultSetReaderFactory>();
    private static boolean initialized = false;
    private static ResultSetReader readerXML = new ResultSetReader(){

        @Override
        public ResultSet read(InputStream in, Context context) {
            return XMLInput.fromXML(in);
        }

        @Override
        public ResultSet read(Reader in, Context context) {
            return XMLInput.fromXML(in);
        }
    };
    private static ResultSetReader readerJSON = new ResultSetReader(){

        @Override
        public ResultSet read(InputStream in, Context context) {
            return JSONInput.fromJSON(in);
        }

        @Override
        public ResultSet read(Reader in, Context context) {
            throw new NotImplemented("Reader");
        }
    };
    private static ResultSetReader readerCSV = new ResultSetReader(){

        @Override
        public ResultSet read(InputStream in, Context context) {
            return CSVInput.fromCSV(in);
        }

        @Override
        public ResultSet read(Reader in, Context context) {
            throw new NotImplemented("Reader");
        }
    };
    private static ResultSetReader readerTSV = new ResultSetReader(){

        @Override
        public ResultSet read(InputStream in, Context context) {
            return TSVInput.fromTSV(in);
        }

        @Override
        public ResultSet read(Reader in, Context context) {
            throw new NotImplemented("Reader");
        }
    };
    private static ResultSetReader readerThrift = new ResultSetReader(){

        @Override
        public ResultSet read(InputStream in, Context context) {
            return BinRDF.readResultSet(in);
        }

        @Override
        public ResultSet read(Reader in, Context context) {
            throw new NotImplemented("Reading binary data from a java.io.Reader is not possible");
        }
    };
    private static ResultSetReader readerNo = new ResultSetReader(){

        @Override
        public ResultSet read(InputStream in, Context context) {
            return null;
        }

        @Override
        public ResultSet read(Reader in, Context context) {
            return null;
        }
    };

    public static ResultSetReaderFactory getFactory(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.get(lang);
    }

    public static void register(Lang lang, ResultSetReaderFactory factory) {
        Objects.requireNonNull(lang);
        Objects.requireNonNull(factory);
        registry.put(lang, factory);
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        ResultSetReaderFactoryStd factory = new ResultSetReaderFactoryStd();
        ResultSetReaderRegistry.register(ResultSetLang.SPARQLResultSetXML, factory);
        ResultSetReaderRegistry.register(ResultSetLang.SPARQLResultSetJSON, factory);
        ResultSetReaderRegistry.register(ResultSetLang.SPARQLResultSetCSV, factory);
        ResultSetReaderRegistry.register(ResultSetLang.SPARQLResultSetTSV, factory);
        ResultSetReaderRegistry.register(ResultSetLang.SPARQLResultSetThrift, factory);
    }

    private static class ResultSetReaderThriftFactory
    implements ResultSetReaderFactory {
        private ResultSetReaderThriftFactory() {
        }

        @Override
        public ResultSetReader create(Lang lang) {
            return new ResultSetReader(){

                @Override
                public ResultSet read(InputStream in, Context context) {
                    return BinRDF.readResultSet(in);
                }

                @Override
                public ResultSet read(Reader in, Context context) {
                    throw new NotImplemented("Reading binary data from a java.io.Reader is not possible");
                }
            };
        }
    }

    private static class ResultSetReaderFactoryStd
    implements ResultSetReaderFactory {
        private ResultSetReaderFactoryStd() {
        }

        @Override
        public ResultSetReader create(Lang lang) {
            if ((lang = Objects.requireNonNull(lang, "Language must not be null")).equals(ResultSetLang.SPARQLResultSetXML)) {
                return readerXML;
            }
            if (lang.equals(ResultSetLang.SPARQLResultSetJSON)) {
                return readerJSON;
            }
            if (lang.equals(ResultSetLang.SPARQLResultSetCSV)) {
                return readerCSV;
            }
            if (lang.equals(ResultSetLang.SPARQLResultSetTSV)) {
                return readerTSV;
            }
            if (lang.equals(ResultSetLang.SPARQLResultSetThrift)) {
                return readerThrift;
            }
            throw new RiotException("Lang not registered (ResultSet reader)");
        }
    }
}

