/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.util.concurrent.TimeoutException;

public class TimeoutProcess
extends Thread {
    private final Process process;
    private Integer exit;

    protected TimeoutProcess(Process process) {
        this.process = process;
    }

    public static int waitFor(Process process, int millis) throws TimeoutException, InterruptedException {
        TimeoutProcess waiter = new TimeoutProcess(process);
        waiter.start();
        try {
            waiter.join(millis);
            if (waiter.exit == null) {
                throw new TimeoutException();
            }
            int n = waiter.exit;
            return n;
        }
        catch (InterruptedException e) {
            waiter.interrupt();
            Thread.currentThread().interrupt();
            throw e;
        }
        finally {
            process.destroy();
        }
    }

    @Override
    public void run() {
        try {
            this.exit = this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Integer getExit() {
        return this.exit;
    }
}

