/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import de.fau.cs.osr.utils.AccumulatingRingBufferLong;

public class SpeedMeter {
    private static final int MAX_BUFFER_SIZE = 65536;
    private final double windowSizeInSeconds;
    private final AccumulatingRingBufferLong measurements;
    private final AccumulatingRingBufferLong timestamps;

    public SpeedMeter(double windowSizeInSeconds, double expectedMeasurementsPerSecond) {
        this(windowSizeInSeconds, (int)(windowSizeInSeconds * expectedMeasurementsPerSecond));
    }

    public SpeedMeter(double windowSizeInSeconds, int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (bufferSize > 65536) {
            throw new IllegalArgumentException();
        }
        this.windowSizeInSeconds = windowSizeInSeconds;
        this.measurements = new AccumulatingRingBufferLong(bufferSize);
        this.timestamps = new AccumulatingRingBufferLong(bufferSize);
    }

    public void addValue(long value) {
        this.addValue(value, System.nanoTime());
    }

    public void addValue(long value, long nanoTime) {
        double age;
        while (this.timestamps.getN() > 0 && !((age = (double)(nanoTime - this.timestamps.getOldest()) / 1.0E9) < this.windowSizeInSeconds)) {
            this.timestamps.removeOldestN(1);
            this.measurements.removeOldestN(1);
        }
        this.timestamps.add(nanoTime);
        this.measurements.add(value);
    }

    public void addValueIfNew(long value, long nowNano) {
        if (this.measurements.getN() == 0 || this.measurements.getNewest() != value) {
            this.addValue(value, nowNano);
        }
    }

    public double speed() {
        return this.speed(this.timestamps.getNewest());
    }

    public double speed(long nowNanos) {
        long deltaX = this.measurements.getNewest() - this.measurements.getOldest();
        long deltaT = nowNanos - this.timestamps.getOldest();
        return (double)deltaX / ((double)deltaT / 1.0E9);
    }

    public double average() {
        return this.measurements.getSum().doubleValue() / (double)this.measurements.getN();
    }

    public boolean hasMeasurements() {
        return this.measurements.getN() > 0;
    }
}

