/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class NestedIterator<T>
implements Iterator<T> {
    Iterator<? extends Iterable<T>> outerIterator;
    Iterator<T> innerIterator;

    public NestedIterator(Iterable<? extends Iterable<T>> iterableOfIterables) {
        this.outerIterator = iterableOfIterables.iterator();
        this.advanceOuterIterator();
    }

    @Override
    public boolean hasNext() {
        return this.innerIterator != null;
    }

    @Override
    public T next() {
        if (this.innerIterator == null) {
            throw new NoSuchElementException();
        }
        T result = this.innerIterator.next();
        if (!this.innerIterator.hasNext()) {
            this.advanceOuterIterator();
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void advanceOuterIterator() {
        while ((this.innerIterator == null || !this.innerIterator.hasNext()) && this.outerIterator.hasNext()) {
            this.innerIterator = this.outerIterator.next().iterator();
        }
        if (this.innerIterator != null && !this.innerIterator.hasNext()) {
            this.innerIterator = null;
        }
    }
}

