# only add PUBLIC dependencies as well
#   https://cmake.org/cmake/help/latest/manual/cmake-packages.7.html#creating-a-package-configuration-file
include(CMakeFindDependencyMacro)

list(APPEND CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}/Modules")

set(openPMD_HAVE_MPI FALSE)
if(openPMD_HAVE_MPI)
    find_dependency(MPI)
    # deselect parallel installs if explicitly a serial install is requested
    set(openPMD_NOMPI_FOUND FALSE)
else()
    set(openPMD_NOMPI_FOUND TRUE)
endif()
set(openPMD_MPI_FOUND ${openPMD_HAVE_MPI})

set(openPMD_HAVE_HDF5 TRUE)
if(openPMD_HAVE_HDF5)
    find_dependency(HDF5)
endif()
set(openPMD_HDF5_FOUND ${openPMD_HAVE_HDF5})

set(openPMD_HAVE_ADIOS1 FALSE)
if(openPMD_HAVE_ADIOS1)
    find_dependency(ADIOS)
endif()
set(openPMD_ADIOS1_FOUND ${openPMD_HAVE_ADIOS1})

set(openPMD_HAVE_ADIOS2 FALSE)
if(openPMD_HAVE_ADIOS2)
    find_dependency(ADIOS2)
endif()
set(openPMD_ADIOS2_FOUND ${openPMD_HAVE_ADIOS2})

include("${CMAKE_CURRENT_LIST_DIR}/openPMDTargets.cmake")

# check if components are fulfilled and set openPMD_<COMPONENT>_FOUND vars
foreach(comp ${openPMD_FIND_COMPONENTS})
    if(NOT openPMD_${comp}_FOUND)
        if(openPMD_FIND_REQUIRED_${comp})
            set(openPMD_FOUND FALSE)
        endif()
    endif()
endforeach()
