/* Swig input file,
   generated by D:/bld/openmm_1622799350838/work/build/python/src/swig_doxygen/swigInputBuilder.py on Fri Jun  4 09:52:04 2021
*/



namespace OpenMM {


/* Declare factories */

%factory(OpenMM::Force& OpenMM::System::getForce,
         OpenMM::AmoebaAngleForce,
         OpenMM::AmoebaBondForce,
         OpenMM::AmoebaGeneralizedKirkwoodForce,
         OpenMM::AmoebaInPlaneAngleForce,
         OpenMM::AmoebaMultipoleForce,
         OpenMM::AmoebaOutOfPlaneBendForce,
         OpenMM::AmoebaPiTorsionForce,
         OpenMM::AmoebaStretchBendForce,
         OpenMM::AmoebaTorsionTorsionForce,
         OpenMM::AmoebaVdwForce,
         OpenMM::AmoebaWcaDispersionForce,
         OpenMM::AndersenThermostat,
         OpenMM::CMAPTorsionForce,
         OpenMM::CMMotionRemover,
         OpenMM::CustomAngleForce,
         OpenMM::CustomBondForce,
         OpenMM::CustomCVForce,
         OpenMM::CustomCentroidBondForce,
         OpenMM::CustomCompoundBondForce,
         OpenMM::CustomExternalForce,
         OpenMM::CustomGBForce,
         OpenMM::CustomHbondForce,
         OpenMM::CustomManyParticleForce,
         OpenMM::CustomNonbondedForce,
         OpenMM::CustomTorsionForce,
         OpenMM::DrudeForce,
         OpenMM::GBSAOBCForce,
         OpenMM::GayBerneForce,
         OpenMM::HarmonicAngleForce,
         OpenMM::HarmonicBondForce,
         OpenMM::HippoNonbondedForce,
         OpenMM::MonteCarloAnisotropicBarostat,
         OpenMM::MonteCarloBarostat,
         OpenMM::MonteCarloMembraneBarostat,
         OpenMM::NonbondedForce,
         OpenMM::PeriodicTorsionForce,
         OpenMM::RBTorsionForce,
         OpenMM::RMSDForce,
         OpenMM::RPMDMonteCarloBarostat);

%factory(OpenMM::Force* OpenMM::Force::__copy__,
         OpenMM::AmoebaAngleForce,
         OpenMM::AmoebaBondForce,
         OpenMM::AmoebaGeneralizedKirkwoodForce,
         OpenMM::AmoebaInPlaneAngleForce,
         OpenMM::AmoebaMultipoleForce,
         OpenMM::AmoebaOutOfPlaneBendForce,
         OpenMM::AmoebaPiTorsionForce,
         OpenMM::AmoebaStretchBendForce,
         OpenMM::AmoebaTorsionTorsionForce,
         OpenMM::AmoebaVdwForce,
         OpenMM::AmoebaWcaDispersionForce,
         OpenMM::AndersenThermostat,
         OpenMM::CMAPTorsionForce,
         OpenMM::CMMotionRemover,
         OpenMM::CustomAngleForce,
         OpenMM::CustomBondForce,
         OpenMM::CustomCVForce,
         OpenMM::CustomCentroidBondForce,
         OpenMM::CustomCompoundBondForce,
         OpenMM::CustomExternalForce,
         OpenMM::CustomGBForce,
         OpenMM::CustomHbondForce,
         OpenMM::CustomManyParticleForce,
         OpenMM::CustomNonbondedForce,
         OpenMM::CustomTorsionForce,
         OpenMM::DrudeForce,
         OpenMM::GBSAOBCForce,
         OpenMM::GayBerneForce,
         OpenMM::HarmonicAngleForce,
         OpenMM::HarmonicBondForce,
         OpenMM::HippoNonbondedForce,
         OpenMM::MonteCarloAnisotropicBarostat,
         OpenMM::MonteCarloBarostat,
         OpenMM::MonteCarloMembraneBarostat,
         OpenMM::NonbondedForce,
         OpenMM::PeriodicTorsionForce,
         OpenMM::RBTorsionForce,
         OpenMM::RMSDForce,
         OpenMM::RPMDMonteCarloBarostat);

%factory(OpenMM::Force* OpenMM_XmlSerializer__deserializeForce,
         OpenMM::AmoebaAngleForce,
         OpenMM::AmoebaBondForce,
         OpenMM::AmoebaGeneralizedKirkwoodForce,
         OpenMM::AmoebaInPlaneAngleForce,
         OpenMM::AmoebaMultipoleForce,
         OpenMM::AmoebaOutOfPlaneBendForce,
         OpenMM::AmoebaPiTorsionForce,
         OpenMM::AmoebaStretchBendForce,
         OpenMM::AmoebaTorsionTorsionForce,
         OpenMM::AmoebaVdwForce,
         OpenMM::AmoebaWcaDispersionForce,
         OpenMM::AndersenThermostat,
         OpenMM::CMAPTorsionForce,
         OpenMM::CMMotionRemover,
         OpenMM::CustomAngleForce,
         OpenMM::CustomBondForce,
         OpenMM::CustomCVForce,
         OpenMM::CustomCentroidBondForce,
         OpenMM::CustomCompoundBondForce,
         OpenMM::CustomExternalForce,
         OpenMM::CustomGBForce,
         OpenMM::CustomHbondForce,
         OpenMM::CustomManyParticleForce,
         OpenMM::CustomNonbondedForce,
         OpenMM::CustomTorsionForce,
         OpenMM::DrudeForce,
         OpenMM::GBSAOBCForce,
         OpenMM::GayBerneForce,
         OpenMM::HarmonicAngleForce,
         OpenMM::HarmonicBondForce,
         OpenMM::HippoNonbondedForce,
         OpenMM::MonteCarloAnisotropicBarostat,
         OpenMM::MonteCarloBarostat,
         OpenMM::MonteCarloMembraneBarostat,
         OpenMM::NonbondedForce,
         OpenMM::PeriodicTorsionForce,
         OpenMM::RBTorsionForce,
         OpenMM::RMSDForce,
         OpenMM::RPMDMonteCarloBarostat);

%factory(OpenMM::Force& OpenMM::CustomCVForce::getCollectiveVariable,
         OpenMM::AmoebaAngleForce,
         OpenMM::AmoebaBondForce,
         OpenMM::AmoebaGeneralizedKirkwoodForce,
         OpenMM::AmoebaInPlaneAngleForce,
         OpenMM::AmoebaMultipoleForce,
         OpenMM::AmoebaOutOfPlaneBendForce,
         OpenMM::AmoebaPiTorsionForce,
         OpenMM::AmoebaStretchBendForce,
         OpenMM::AmoebaTorsionTorsionForce,
         OpenMM::AmoebaVdwForce,
         OpenMM::AmoebaWcaDispersionForce,
         OpenMM::AndersenThermostat,
         OpenMM::CMAPTorsionForce,
         OpenMM::CMMotionRemover,
         OpenMM::CustomAngleForce,
         OpenMM::CustomBondForce,
         OpenMM::CustomCVForce,
         OpenMM::CustomCentroidBondForce,
         OpenMM::CustomCompoundBondForce,
         OpenMM::CustomExternalForce,
         OpenMM::CustomGBForce,
         OpenMM::CustomHbondForce,
         OpenMM::CustomManyParticleForce,
         OpenMM::CustomNonbondedForce,
         OpenMM::CustomTorsionForce,
         OpenMM::DrudeForce,
         OpenMM::GBSAOBCForce,
         OpenMM::GayBerneForce,
         OpenMM::HarmonicAngleForce,
         OpenMM::HarmonicBondForce,
         OpenMM::HippoNonbondedForce,
         OpenMM::MonteCarloAnisotropicBarostat,
         OpenMM::MonteCarloBarostat,
         OpenMM::MonteCarloMembraneBarostat,
         OpenMM::NonbondedForce,
         OpenMM::PeriodicTorsionForce,
         OpenMM::RBTorsionForce,
         OpenMM::RMSDForce,
         OpenMM::RPMDMonteCarloBarostat);

%factory(OpenMM::Integrator* OpenMM::Integrator::__copy__,
         OpenMM::BrownianIntegrator,
         OpenMM::CompoundIntegrator,
         OpenMM::CustomIntegrator,
         OpenMM::DrudeIntegrator,
         OpenMM::LangevinIntegrator,
         OpenMM::LangevinMiddleIntegrator,
         OpenMM::NoseHooverIntegrator,
         OpenMM::RPMDIntegrator,
         OpenMM::VariableLangevinIntegrator,
         OpenMM::VariableVerletIntegrator,
         OpenMM::VerletIntegrator);

%factory(OpenMM::Integrator* OpenMM_XmlSerializer__deserializeIntegrator,
         OpenMM::BrownianIntegrator,
         OpenMM::CompoundIntegrator,
         OpenMM::CustomIntegrator,
         OpenMM::DrudeIntegrator,
         OpenMM::LangevinIntegrator,
         OpenMM::LangevinMiddleIntegrator,
         OpenMM::NoseHooverIntegrator,
         OpenMM::RPMDIntegrator,
         OpenMM::VariableLangevinIntegrator,
         OpenMM::VariableVerletIntegrator,
         OpenMM::VerletIntegrator);

%factory(OpenMM::Integrator& OpenMM::Context::getIntegrator,
         OpenMM::BrownianIntegrator,
         OpenMM::CompoundIntegrator,
         OpenMM::CustomIntegrator,
         OpenMM::DrudeIntegrator,
         OpenMM::LangevinIntegrator,
         OpenMM::LangevinMiddleIntegrator,
         OpenMM::NoseHooverIntegrator,
         OpenMM::RPMDIntegrator,
         OpenMM::VariableLangevinIntegrator,
         OpenMM::VariableVerletIntegrator,
         OpenMM::VerletIntegrator);

%factory(OpenMM::Integrator& OpenMM::CompoundIntegrator::getIntegrator,
         OpenMM::BrownianIntegrator,
         OpenMM::CompoundIntegrator,
         OpenMM::CustomIntegrator,
         OpenMM::DrudeIntegrator,
         OpenMM::LangevinIntegrator,
         OpenMM::LangevinMiddleIntegrator,
         OpenMM::NoseHooverIntegrator,
         OpenMM::RPMDIntegrator,
         OpenMM::VariableLangevinIntegrator,
         OpenMM::VariableVerletIntegrator,
         OpenMM::VerletIntegrator);

%factory(OpenMM::TabulatedFunction* OpenMM::TabulatedFunction::__copy__,
         OpenMM::Continuous1DFunction,
         OpenMM::Continuous2DFunction,
         OpenMM::Continuous3DFunction,
         OpenMM::Discrete1DFunction,
         OpenMM::Discrete2DFunction,
         OpenMM::Discrete3DFunction);

%factory(OpenMM::TabulatedFunction* OpenMM_XmlSerializer__deserializeTabulatedFunction,
         OpenMM::Continuous1DFunction,
         OpenMM::Continuous2DFunction,
         OpenMM::Continuous3DFunction,
         OpenMM::Discrete1DFunction,
         OpenMM::Discrete2DFunction,
         OpenMM::Discrete3DFunction);

%factory(OpenMM::TabulatedFunction& OpenMM::CustomCentroidBondForce::getTabulatedFunction,
         OpenMM::Continuous1DFunction,
         OpenMM::Continuous2DFunction,
         OpenMM::Continuous3DFunction,
         OpenMM::Discrete1DFunction,
         OpenMM::Discrete2DFunction,
         OpenMM::Discrete3DFunction);

%factory(OpenMM::TabulatedFunction& OpenMM::CustomCompoundBondForce::getTabulatedFunction,
         OpenMM::Continuous1DFunction,
         OpenMM::Continuous2DFunction,
         OpenMM::Continuous3DFunction,
         OpenMM::Discrete1DFunction,
         OpenMM::Discrete2DFunction,
         OpenMM::Discrete3DFunction);

%factory(OpenMM::TabulatedFunction& OpenMM::CustomCVForce::getTabulatedFunction,
         OpenMM::Continuous1DFunction,
         OpenMM::Continuous2DFunction,
         OpenMM::Continuous3DFunction,
         OpenMM::Discrete1DFunction,
         OpenMM::Discrete2DFunction,
         OpenMM::Discrete3DFunction);

%factory(OpenMM::TabulatedFunction& OpenMM::CustomGBForce::getTabulatedFunction,
         OpenMM::Continuous1DFunction,
         OpenMM::Continuous2DFunction,
         OpenMM::Continuous3DFunction,
         OpenMM::Discrete1DFunction,
         OpenMM::Discrete2DFunction,
         OpenMM::Discrete3DFunction);

%factory(OpenMM::TabulatedFunction& OpenMM::CustomHbondForce::getTabulatedFunction,
         OpenMM::Continuous1DFunction,
         OpenMM::Continuous2DFunction,
         OpenMM::Continuous3DFunction,
         OpenMM::Discrete1DFunction,
         OpenMM::Discrete2DFunction,
         OpenMM::Discrete3DFunction);

%factory(OpenMM::TabulatedFunction& OpenMM::CustomIntegrator::getTabulatedFunction,
         OpenMM::Continuous1DFunction,
         OpenMM::Continuous2DFunction,
         OpenMM::Continuous3DFunction,
         OpenMM::Discrete1DFunction,
         OpenMM::Discrete2DFunction,
         OpenMM::Discrete3DFunction);

%factory(OpenMM::TabulatedFunction& OpenMM::CustomManyParticleForce::getTabulatedFunction,
         OpenMM::Continuous1DFunction,
         OpenMM::Continuous2DFunction,
         OpenMM::Continuous3DFunction,
         OpenMM::Discrete1DFunction,
         OpenMM::Discrete2DFunction,
         OpenMM::Discrete3DFunction);

%factory(OpenMM::TabulatedFunction& OpenMM::CustomNonbondedForce::getTabulatedFunction,
         OpenMM::Continuous1DFunction,
         OpenMM::Continuous2DFunction,
         OpenMM::Continuous3DFunction,
         OpenMM::Discrete1DFunction,
         OpenMM::Discrete2DFunction,
         OpenMM::Discrete3DFunction);

%factory(OpenMM::VirtualSite& OpenMM::System::getVirtualSite, OpenMM::TwoParticleAverageSite, OpenMM::ThreeParticleAverageSite, OpenMM::OutOfPlaneSite, OpenMM::LocalCoordinatesSite);


/* Global Constants */

static const double NmPerAngstrom =  0.1;
static const double AngstromsPerNm =  10.0;
static const double PsPerFs =  0.001;
static const double FsPerPs =  1000.0;
static const double KJPerKcal =  4.184;
static const double KcalPerKJ =  1.0/4.184;
static const double RadiansPerDegree =  3.1415926535897932385/180.0;
static const double DegreesPerRadian =  180.0/3.1415926535897932385;
static const double SigmaPerVdwRadius =  1.7817974362806786095;
static const double VdwRadiusPerSigma =  .56123102415468649070;


/* Forward Declarations */

class Force ;
%copyctor AmoebaAngleForce ;
class AmoebaAngleForce ;
%copyctor AmoebaBondForce ;
class AmoebaBondForce ;
%copyctor AmoebaGeneralizedKirkwoodForce ;
class AmoebaGeneralizedKirkwoodForce ;
%copyctor AmoebaInPlaneAngleForce ;
class AmoebaInPlaneAngleForce ;
%copyctor AmoebaMultipoleForce ;
class AmoebaMultipoleForce ;
%copyctor AmoebaOutOfPlaneBendForce ;
class AmoebaOutOfPlaneBendForce ;
%copyctor AmoebaPiTorsionForce ;
class AmoebaPiTorsionForce ;
%copyctor AmoebaStretchBendForce ;
class AmoebaStretchBendForce ;
%copyctor AmoebaTorsionTorsionForce ;
class AmoebaTorsionTorsionForce ;
%copyctor AmoebaVdwForce ;
class AmoebaVdwForce ;
%copyctor AmoebaWcaDispersionForce ;
class AmoebaWcaDispersionForce ;
%copyctor AndersenThermostat ;
class AndersenThermostat ;
%copyctor Integrator ;
class Integrator ;
%copyctor BrownianIntegrator ;
class BrownianIntegrator ;
%copyctor CMAPTorsionForce ;
class CMAPTorsionForce ;
%copyctor CMMotionRemover ;
class CMMotionRemover ;
%copyctor CompoundIntegrator ;
class CompoundIntegrator ;
%copyctor Context ;
class Context ;
class TabulatedFunction ;
class Continuous1DFunction ;
class Continuous2DFunction ;
class Continuous3DFunction ;
%copyctor CustomAngleForce ;
class CustomAngleForce ;
%copyctor CustomBondForce ;
class CustomBondForce ;
%copyctor CustomCentroidBondForce ;
class CustomCentroidBondForce ;
%copyctor CustomCompoundBondForce ;
class CustomCompoundBondForce ;
%copyctor CustomCVForce ;
class CustomCVForce ;
%copyctor CustomExternalForce ;
class CustomExternalForce ;
%copyctor CustomGBForce ;
class CustomGBForce ;
%copyctor CustomHbondForce ;
class CustomHbondForce ;
%copyctor CustomIntegrator ;
class CustomIntegrator ;
%copyctor CustomManyParticleForce ;
class CustomManyParticleForce ;
%copyctor CustomNonbondedForce ;
class CustomNonbondedForce ;
%copyctor CustomTorsionForce ;
class CustomTorsionForce ;
class Discrete1DFunction ;
class Discrete2DFunction ;
class Discrete3DFunction ;
%copyctor DrudeForce ;
class DrudeForce ;
%copyctor DrudeIntegrator ;
class DrudeIntegrator ;
%copyctor DrudeLangevinIntegrator ;
class DrudeLangevinIntegrator ;
%copyctor NoseHooverIntegrator ;
class NoseHooverIntegrator ;
%copyctor DrudeNoseHooverIntegrator ;
class DrudeNoseHooverIntegrator ;
%copyctor DrudeSCFIntegrator ;
class DrudeSCFIntegrator ;
%copyctor GayBerneForce ;
class GayBerneForce ;
%copyctor GBSAOBCForce ;
class GBSAOBCForce ;
%copyctor HarmonicAngleForce ;
class HarmonicAngleForce ;
%copyctor HarmonicBondForce ;
class HarmonicBondForce ;
%copyctor HippoNonbondedForce ;
class HippoNonbondedForce ;
%copyctor LangevinIntegrator ;
class LangevinIntegrator ;
%copyctor LangevinMiddleIntegrator ;
class LangevinMiddleIntegrator ;
class VirtualSite ;
%copyctor LocalCoordinatesSite ;
class LocalCoordinatesSite ;
class LocalEnergyMinimizer ;
%copyctor MonteCarloAnisotropicBarostat ;
class MonteCarloAnisotropicBarostat ;
%copyctor MonteCarloBarostat ;
class MonteCarloBarostat ;
%copyctor MonteCarloMembraneBarostat ;
class MonteCarloMembraneBarostat ;
%copyctor NonbondedForce ;
class NonbondedForce ;
%copyctor NoseHooverChain ;
class NoseHooverChain ;
%copyctor OutOfPlaneSite ;
class OutOfPlaneSite ;
%copyctor PeriodicTorsionForce ;
class PeriodicTorsionForce ;
class Platform ;
%copyctor RBTorsionForce ;
class RBTorsionForce ;
%copyctor RMSDForce ;
class RMSDForce ;
%copyctor RPMDIntegrator ;
class RPMDIntegrator ;
%copyctor RPMDMonteCarloBarostat ;
class RPMDMonteCarloBarostat ;
class SerializationNode ;
%copyctor SerializationProxy ;
class SerializationProxy ;
%copyctor State ;
class State ;
%copyctor System ;
class System ;
%copyctor ThreeParticleAverageSite ;
class ThreeParticleAverageSite ;
%copyctor TwoParticleAverageSite ;
class TwoParticleAverageSite ;
%copyctor VariableLangevinIntegrator ;
class VariableLangevinIntegrator ;
%copyctor VariableVerletIntegrator ;
class VariableVerletIntegrator ;
%copyctor VerletIntegrator ;
class VerletIntegrator ;
class XmlSerializer ;


/* Class Declarations */

class Force {
public:
   virtual ~Force() ;

   int getForceGroup() const ;
   void setForceGroup(int group) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class AmoebaAngleForce : public Force {
public:
   AmoebaAngleForce() ;

   int getNumAngles() const ;
   void setAmoebaGlobalAngleCubic(double cubicK) ;
   double getAmoebaGlobalAngleCubic() const ;
   void setAmoebaGlobalAngleQuartic(double quarticK) ;
   double getAmoebaGlobalAngleQuartic() const ;
   void setAmoebaGlobalAnglePentic(double penticK) ;
   double getAmoebaGlobalAnglePentic() const ;
   void setAmoebaGlobalAngleSextic(double sexticK) ;
   double getAmoebaGlobalAngleSextic() const ;
   int addAngle(int particle1, int particle2, int particle3, double length, double quadraticK) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply int & OUTPUT { int & particle3 };
   %apply double & OUTPUT { double & length };
   %apply double & OUTPUT { double & quadraticK };
   void getAngleParameters(int index, int &particle1, int &particle2, int &particle3, double &length, double &quadraticK) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear int & particle3;
   %clear double & length;
   %clear double & quadraticK;
   void setAngleParameters(int index, int particle1, int particle2, int particle3, double length, double quadraticK) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class AmoebaBondForce : public Force {
public:
   AmoebaBondForce() ;

   int getNumBonds() const ;
   void setAmoebaGlobalBondCubic(double cubicK) ;
   double getAmoebaGlobalBondCubic() const ;
   void setAmoebaGlobalBondQuartic(double quarticK) ;
   double getAmoebaGlobalBondQuartic() const ;
   int addBond(int particle1, int particle2, double length, double quadraticK) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply double & OUTPUT { double & length };
   %apply double & OUTPUT { double & quadraticK };
   void getBondParameters(int index, int &particle1, int &particle2, double &length, double &quadraticK) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear double & length;
   %clear double & quadraticK;
   void setBondParameters(int index, int particle1, int particle2, double length, double quadraticK) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class AmoebaGeneralizedKirkwoodForce : public Force {
public:
   AmoebaGeneralizedKirkwoodForce() ;

   int getNumParticles() const ;
   int addParticle(double charge, double radius, double scalingFactor) ;
   %apply double & OUTPUT { double & charge };
   %apply double & OUTPUT { double & radius };
   %apply double & OUTPUT { double & scalingFactor };
   void getParticleParameters(int index, double &charge, double &radius, double &scalingFactor) const ;
   %clear double & charge;
   %clear double & radius;
   %clear double & scalingFactor;
   void setParticleParameters(int index, double charge, double radius, double scalingFactor) ;
   double getSolventDielectric() const ;
   void setSolventDielectric(double dielectric) ;
   double getSoluteDielectric() const ;
   void setSoluteDielectric(double dielectric) ;
   int getIncludeCavityTerm() const ;
   void setIncludeCavityTerm(int includeCavityTerm) ;
   double getProbeRadius() const ;
   void setProbeRadius(double probeRadius) ;
   double getSurfaceAreaFactor() const ;
   void setSurfaceAreaFactor(double surfaceAreaFactor) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class AmoebaInPlaneAngleForce : public Force {
public:
   AmoebaInPlaneAngleForce() ;

   int getNumAngles() const ;
   void setAmoebaGlobalInPlaneAngleCubic(double cubicK) ;
   double getAmoebaGlobalInPlaneAngleCubic() const ;
   void setAmoebaGlobalInPlaneAngleQuartic(double quarticK) ;
   double getAmoebaGlobalInPlaneAngleQuartic() const ;
   void setAmoebaGlobalInPlaneAnglePentic(double penticK) ;
   double getAmoebaGlobalInPlaneAnglePentic() const ;
   void setAmoebaGlobalInPlaneAngleSextic(double sexticK) ;
   double getAmoebaGlobalInPlaneAngleSextic() const ;
   int addAngle(int particle1, int particle2, int particle3, int particle4, double length, double quadraticK) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply int & OUTPUT { int & particle3 };
   %apply int & OUTPUT { int & particle4 };
   %apply double & OUTPUT { double & length };
   %apply double & OUTPUT { double & quadraticK };
   void getAngleParameters(int index, int &particle1, int &particle2, int &particle3, int &particle4, double &length, double &quadraticK) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear int & particle3;
   %clear int & particle4;
   %clear double & length;
   %clear double & quadraticK;
   void setAngleParameters(int index, int particle1, int particle2, int particle3, int particle4, double length, double quadraticK) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class AmoebaMultipoleForce : public Force {
public:
   enum NonbondedMethod {
      NoCutoff =  0,
      PME =  1
   };
   enum PolarizationType {
      Mutual =  0,
      Direct =  1,
      Extrapolated =  2
   };
   enum MultipoleAxisTypes {
      ZThenX =  0,
      Bisector =  1,
      ZBisect =  2,
      ThreeFold =  3,
      ZOnly =  4,
      NoAxisType =  5,
      LastAxisTypeIndex =  6
   };
   enum CovalentType {
      Covalent12 =  0,
      Covalent13 =  1,
      Covalent14 =  2,
      Covalent15 =  3,
      PolarizationCovalent11 =  4,
      PolarizationCovalent12 =  5,
      PolarizationCovalent13 =  6,
      PolarizationCovalent14 =  7,
      CovalentEnd =  8
   };

   AmoebaMultipoleForce() ;

   int getNumMultipoles() const ;
   NonbondedMethod getNonbondedMethod() const ;
   void setNonbondedMethod(NonbondedMethod method) ;
   PolarizationType getPolarizationType() const ;
   void setPolarizationType(PolarizationType type) ;
   double getCutoffDistance() const ;
   void setCutoffDistance(double distance) ;
   %apply double & OUTPUT { double & alpha };
   %apply int & OUTPUT { int & nx };
   %apply int & OUTPUT { int & ny };
   %apply int & OUTPUT { int & nz };
   void getPMEParameters(double &alpha, int &nx, int &ny, int &nz) const ;
   %clear double & alpha;
   %clear int & nx;
   %clear int & ny;
   %clear int & nz;
   void setPMEParameters(double alpha, int nx, int ny, int nz) ;
   double getAEwald() const ;
   void setAEwald(double aewald) ;
   int getPmeBSplineOrder() const ;
   %apply std::vector< int > & OUTPUT { std::vector< int > & gridDimension };
   void getPmeGridDimensions(std::vector< int > &gridDimension) const ;
   %clear std::vector< int > & gridDimension;
   void setPmeGridDimensions(const std::vector< int > &gridDimension) ;
   %apply double & OUTPUT { double & alpha };
   %apply int & OUTPUT { int & nx };
   %apply int & OUTPUT { int & ny };
   %apply int & OUTPUT { int & nz };
   void getPMEParametersInContext(const Context &context, double &alpha, int &nx, int &ny, int &nz) const ;
   %clear double & alpha;
   %clear int & nx;
   %clear int & ny;
   %clear int & nz;
   int addMultipole(double charge, const std::vector< double > &molecularDipole, const std::vector< double > &molecularQuadrupole, int axisType, int multipoleAtomZ, int multipoleAtomX, int multipoleAtomY, double thole, double dampingFactor, double polarity) ;
   %apply double & OUTPUT { double & charge };
   %apply std::vector< double > & OUTPUT { std::vector< double > & molecularDipole };
   %apply std::vector< double > & OUTPUT { std::vector< double > & molecularQuadrupole };
   %apply int & OUTPUT { int & axisType };
   %apply int & OUTPUT { int & multipoleAtomZ };
   %apply int & OUTPUT { int & multipoleAtomX };
   %apply int & OUTPUT { int & multipoleAtomY };
   %apply double & OUTPUT { double & thole };
   %apply double & OUTPUT { double & dampingFactor };
   %apply double & OUTPUT { double & polarity };
   void getMultipoleParameters(int index, double &charge, std::vector< double > &molecularDipole, std::vector< double > &molecularQuadrupole, int &axisType, int &multipoleAtomZ, int &multipoleAtomX, int &multipoleAtomY, double &thole, double &dampingFactor, double &polarity) const ;
   %clear double & charge;
   %clear std::vector< double > & molecularDipole;
   %clear std::vector< double > & molecularQuadrupole;
   %clear int & axisType;
   %clear int & multipoleAtomZ;
   %clear int & multipoleAtomX;
   %clear int & multipoleAtomY;
   %clear double & thole;
   %clear double & dampingFactor;
   %clear double & polarity;
   void setMultipoleParameters(int index, double charge, const std::vector< double > &molecularDipole, const std::vector< double > &molecularQuadrupole, int axisType, int multipoleAtomZ, int multipoleAtomX, int multipoleAtomY, double thole, double dampingFactor, double polarity) ;
   void setCovalentMap(int index, CovalentType typeId, const std::vector< int > &covalentAtoms) ;
   %apply std::vector< int > & OUTPUT { std::vector< int > & covalentAtoms };
   void getCovalentMap(int index, CovalentType typeId, std::vector< int > &covalentAtoms) const ;
   %clear std::vector< int > & covalentAtoms;
   %apply std::vector< std::vector< int > > & OUTPUT { std::vector< std::vector< int > > & covalentLists };
   void getCovalentMaps(int index, std::vector< std::vector< int > > &covalentLists) const ;
   %clear std::vector< std::vector< int > > & covalentLists;
   int getMutualInducedMaxIterations(void) const ;
   void setMutualInducedMaxIterations(int inputMutualInducedMaxIterations) ;
   double getMutualInducedTargetEpsilon(void) const ;
   void setMutualInducedTargetEpsilon(double inputMutualInducedTargetEpsilon) ;
   void setExtrapolationCoefficients(const std::vector< double > &coefficients) ;
   const std::vector<double>& getExtrapolationCoefficients() const ;
   double getEwaldErrorTolerance() const ;
   void setEwaldErrorTolerance(double tol) ;
   %apply std::vector< Vec3 > & OUTPUT { std::vector< Vec3 > & dipoles };
   void getLabFramePermanentDipoles(Context &context, std::vector< Vec3 > &dipoles) ;
   %clear std::vector< Vec3 > & dipoles;
   %apply std::vector< Vec3 > & OUTPUT { std::vector< Vec3 > & dipoles };
   void getInducedDipoles(Context &context, std::vector< Vec3 > &dipoles) ;
   %clear std::vector< Vec3 > & dipoles;
   %apply std::vector< Vec3 > & OUTPUT { std::vector< Vec3 > & dipoles };
   void getTotalDipoles(Context &context, std::vector< Vec3 > &dipoles) ;
   %clear std::vector< Vec3 > & dipoles;
   %apply std::vector< double > & OUTPUT { std::vector< double > & outputElectrostaticPotential };
   void getElectrostaticPotential(const std::vector< Vec3 > &inputGrid, Context &context, std::vector< double > &outputElectrostaticPotential) ;
   %clear std::vector< double > & outputElectrostaticPotential;
   %apply Context & OUTPUT { Context & context };
   %apply std::vector< double > & OUTPUT { std::vector< double > & outputMultipoleMoments };
   void getSystemMultipoleMoments(Context &context, std::vector< double > &outputMultipoleMoments) ;
   %clear Context & context;
   %clear std::vector< double > & outputMultipoleMoments;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class AmoebaOutOfPlaneBendForce : public Force {
public:
   AmoebaOutOfPlaneBendForce() ;

   int getNumOutOfPlaneBends() const ;
   void setAmoebaGlobalOutOfPlaneBendCubic(double cubicK) ;
   double getAmoebaGlobalOutOfPlaneBendCubic() const ;
   void setAmoebaGlobalOutOfPlaneBendQuartic(double quarticK) ;
   double getAmoebaGlobalOutOfPlaneBendQuartic() const ;
   void setAmoebaGlobalOutOfPlaneBendPentic(double penticK) ;
   double getAmoebaGlobalOutOfPlaneBendPentic() const ;
   void setAmoebaGlobalOutOfPlaneBendSextic(double sexticK) ;
   double getAmoebaGlobalOutOfPlaneBendSextic() const ;
   int addOutOfPlaneBend(int particle1, int particle2, int particle3, int particle4, double k) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply int & OUTPUT { int & particle3 };
   %apply int & OUTPUT { int & particle4 };
   %apply double & OUTPUT { double & k };
   void getOutOfPlaneBendParameters(int index, int &particle1, int &particle2, int &particle3, int &particle4, double &k) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear int & particle3;
   %clear int & particle4;
   %clear double & k;
   void setOutOfPlaneBendParameters(int index, int particle1, int particle2, int particle3, int particle4, double k) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class AmoebaPiTorsionForce : public Force {
public:
   AmoebaPiTorsionForce() ;

   int getNumPiTorsions() const ;
   int addPiTorsion(int particle1, int particle2, int particle3, int particle4, int particle5, int particle6, double k) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply int & OUTPUT { int & particle3 };
   %apply int & OUTPUT { int & particle4 };
   %apply int & OUTPUT { int & particle5 };
   %apply int & OUTPUT { int & particle6 };
   %apply double & OUTPUT { double & k };
   void getPiTorsionParameters(int index, int &particle1, int &particle2, int &particle3, int &particle4, int &particle5, int &particle6, double &k) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear int & particle3;
   %clear int & particle4;
   %clear int & particle5;
   %clear int & particle6;
   %clear double & k;
   void setPiTorsionParameters(int index, int particle1, int particle2, int particle3, int particle4, int particle5, int particle6, double k) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class AmoebaStretchBendForce : public Force {
public:
   AmoebaStretchBendForce() ;

   int getNumStretchBends() const ;
   int addStretchBend(int particle1, int particle2, int particle3, double lengthAB, double lengthCB, double angle, double k1, double k2) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply int & OUTPUT { int & particle3 };
   %apply double & OUTPUT { double & lengthAB };
   %apply double & OUTPUT { double & lengthCB };
   %apply double & OUTPUT { double & angle };
   %apply double & OUTPUT { double & k1 };
   %apply double & OUTPUT { double & k2 };
   void getStretchBendParameters(int index, int &particle1, int &particle2, int &particle3, double &lengthAB, double &lengthCB, double &angle, double &k1, double &k2) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear int & particle3;
   %clear double & lengthAB;
   %clear double & lengthCB;
   %clear double & angle;
   %clear double & k1;
   %clear double & k2;
   void setStretchBendParameters(int index, int particle1, int particle2, int particle3, double lengthAB, double lengthCB, double angle, double k1, double k2) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class AmoebaTorsionTorsionForce : public Force {
public:
   AmoebaTorsionTorsionForce(void) ;

   int getNumTorsionTorsions(void) const ;
   int getNumTorsionTorsionGrids(void) const ;
   int addTorsionTorsion(int particle1, int particle2, int particle3, int particle4, int particle5, int chiralCheckAtomIndex, int gridIndex) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply int & OUTPUT { int & particle3 };
   %apply int & OUTPUT { int & particle4 };
   %apply int & OUTPUT { int & particle5 };
   %apply int & OUTPUT { int & chiralCheckAtomIndex };
   %apply int & OUTPUT { int & gridIndex };
   void getTorsionTorsionParameters(int index, int &particle1, int &particle2, int &particle3, int &particle4, int &particle5, int &chiralCheckAtomIndex, int &gridIndex) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear int & particle3;
   %clear int & particle4;
   %clear int & particle5;
   %clear int & chiralCheckAtomIndex;
   %clear int & gridIndex;
   void setTorsionTorsionParameters(int index, int particle1, int particle2, int particle3, int particle4, int particle5, int chiralCheckAtomIndex, int gridIndex) ;
   const std::vector<std::vector<std::vector<double> > >& getTorsionTorsionGrid(int index) const ;
   void setTorsionTorsionGrid(int index, const std::vector< std::vector< std::vector< double > > > &grid) ;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class AmoebaVdwForce : public Force {
public:
   enum NonbondedMethod {
      NoCutoff =  0,
      CutoffPeriodic =  1
   };
   enum PotentialFunction {
      Buffered147 =  0,
      LennardJones =  1
   };
   enum AlchemicalMethod {
      None =  0,
      Decouple =  1,
      Annihilate =  2
   };

   AmoebaVdwForce() ;

   static const std::string& Lambda() ;
   int getNumParticles() const ;
   int getNumParticleTypes() const ;
   int getNumTypePairs() const ;
   void setParticleParameters(int particleIndex, int parentIndex, double sigma, double epsilon, double reductionFactor, bool isAlchemical=false, int typeIndex=-1) ;
   %apply int & OUTPUT { int & parentIndex };
   %apply double & OUTPUT { double & sigma };
   %apply double & OUTPUT { double & epsilon };
   %apply double & OUTPUT { double & reductionFactor };
   %apply bool & OUTPUT { bool & isAlchemical };
   %apply int & OUTPUT { int & typeIndex };
   void getParticleParameters(int particleIndex, int &parentIndex, double &sigma, double &epsilon, double &reductionFactor, bool &isAlchemical, int &typeIndex) const ;
   %clear int & parentIndex;
   %clear double & sigma;
   %clear double & epsilon;
   %clear double & reductionFactor;
   %clear bool & isAlchemical;
   %clear int & typeIndex;
   int addParticle(int parentIndex, double sigma, double epsilon, double reductionFactor, bool isAlchemical=false) ;
   int addParticle(int parentIndex, int typeIndex, double reductionFactor, bool isAlchemical=false) ;
   int addParticleType(double sigma, double epsilon) ;
   %apply double & OUTPUT { double & sigma };
   %apply double & OUTPUT { double & epsilon };
   void getParticleTypeParameters(int typeIndex, double &sigma, double &epsilon) const ;
   %clear double & sigma;
   %clear double & epsilon;
   void setParticleTypeParameters(int typeIndex, double sigma, double epsilon) ;
   int addTypePair(int type1, int type2, double sigma, double epsilon) ;
   %apply int & OUTPUT { int & type1 };
   %apply int & OUTPUT { int & type2 };
   %apply double & OUTPUT { double & sigma };
   %apply double & OUTPUT { double & epsilon };
   void getTypePairParameters(int pairIndex, int &type1, int &type2, double &sigma, double &epsilon) const ;
   %clear int & type1;
   %clear int & type2;
   %clear double & sigma;
   %clear double & epsilon;
   void setTypePairParameters(int pairIndex, int type1, int type2, double sigma, double epsilon) ;
   void setSigmaCombiningRule(const std::string &sigmaCombiningRule) ;
   const std::string& getSigmaCombiningRule(void) const ;
   void setEpsilonCombiningRule(const std::string &epsilonCombiningRule) ;
   const std::string& getEpsilonCombiningRule(void) const ;
   bool getUseDispersionCorrection() const ;
   void setUseDispersionCorrection(bool useCorrection) ;
   bool getUseParticleTypes() const ;
   void setParticleExclusions(int particleIndex, const std::vector< int > &exclusions) ;
   %apply std::vector< int > & OUTPUT { std::vector< int > & exclusions };
   void getParticleExclusions(int particleIndex, std::vector< int > &exclusions) const ;
   %clear std::vector< int > & exclusions;
   double getCutoffDistance() const ;
   void setCutoffDistance(double distance) ;
   void setCutoff(double cutoff) ;
   double getCutoff() const ;
   NonbondedMethod getNonbondedMethod() const ;
   void setNonbondedMethod(NonbondedMethod method) ;
   PotentialFunction getPotentialFunction() const ;
   void setPotentialFunction(PotentialFunction potential) ;
   void setSoftcorePower(int n) ;
   int getSoftcorePower() const ;
   void setSoftcoreAlpha(double alpha) ;
   double getSoftcoreAlpha() const ;
   AlchemicalMethod getAlchemicalMethod() const ;
   void setAlchemicalMethod(AlchemicalMethod method) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class AmoebaWcaDispersionForce : public Force {
public:
   AmoebaWcaDispersionForce() ;

   int getNumParticles() const ;
   void setParticleParameters(int particleIndex, double radius, double epsilon) ;
   %apply double & OUTPUT { double & radius };
   %apply double & OUTPUT { double & epsilon };
   void getParticleParameters(int particleIndex, double &radius, double &epsilon) const ;
   %clear double & radius;
   %clear double & epsilon;
   int addParticle(double radius, double epsilon) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   double getEpso() const ;
   double getEpsh() const ;
   double getRmino() const ;
   double getRminh() const ;
   double getAwater() const ;
   double getShctd() const ;
   double getDispoff() const ;
   double getSlevy() const ;
   void setEpso(double inputValue) ;
   void setEpsh(double inputValue) ;
   void setRmino(double inputValue) ;
   void setRminh(double inputValue) ;
   void setAwater(double inputValue) ;
   void setShctd(double inputValue) ;
   void setDispoff(double inputValue) ;
   void setSlevy(double inputValue) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class AndersenThermostat : public Force {
public:
   AndersenThermostat(double defaultTemperature, double defaultCollisionFrequency) ;

   static const std::string& Temperature() ;
   static const std::string& CollisionFrequency() ;
   double getDefaultTemperature() const ;
   void setDefaultTemperature(double temperature) ;
   double getDefaultCollisionFrequency() const ;
   void setDefaultCollisionFrequency(double frequency) ;
   int getRandomNumberSeed() const ;
   void setRandomNumberSeed(int seed) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class Integrator {
public:
   Integrator() ;
   virtual ~Integrator() ;

   virtual double getStepSize() const ;
   virtual void setStepSize(double size) ;
   virtual double getConstraintTolerance() const ;
   virtual void setConstraintTolerance(double tol) ;
   virtual void step(int steps)=0 ;
   virtual int getIntegrationForceGroups() const ;
   virtual void setIntegrationForceGroups(int groups) ;
};

class BrownianIntegrator : public Integrator {
public:
   BrownianIntegrator(double temperature, double frictionCoeff, double stepSize) ;

   double getTemperature() const ;
   void setTemperature(double temp) ;
   double getFriction() const ;
   void setFriction(double coeff) ;
   int getRandomNumberSeed() const ;
   void setRandomNumberSeed(int seed) ;
   virtual void step(int steps) ;
};

class CMAPTorsionForce : public Force {
public:
   CMAPTorsionForce() ;

   int getNumMaps() const ;
   int getNumTorsions() const ;
   int addMap(int size, const std::vector< double > &energy) ;
   %apply int & OUTPUT { int & size };
   %apply std::vector< double > & OUTPUT { std::vector< double > & energy };
   void getMapParameters(int index, int &size, std::vector< double > &energy) const ;
   %clear int & size;
   %clear std::vector< double > & energy;
   void setMapParameters(int index, int size, const std::vector< double > &energy) ;
   int addTorsion(int map, int a1, int a2, int a3, int a4, int b1, int b2, int b3, int b4) ;
   %apply int & OUTPUT { int & map };
   %apply int & OUTPUT { int & a1 };
   %apply int & OUTPUT { int & a2 };
   %apply int & OUTPUT { int & a3 };
   %apply int & OUTPUT { int & a4 };
   %apply int & OUTPUT { int & b1 };
   %apply int & OUTPUT { int & b2 };
   %apply int & OUTPUT { int & b3 };
   %apply int & OUTPUT { int & b4 };
   void getTorsionParameters(int index, int &map, int &a1, int &a2, int &a3, int &a4, int &b1, int &b2, int &b3, int &b4) const ;
   %clear int & map;
   %clear int & a1;
   %clear int & a2;
   %clear int & a3;
   %clear int & a4;
   %clear int & b1;
   %clear int & b2;
   %clear int & b3;
   %clear int & b4;
   void setTorsionParameters(int index, int map, int a1, int a2, int a3, int a4, int b1, int b2, int b3, int b4) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class CMMotionRemover : public Force {
public:
   CMMotionRemover(int frequency=1) ;

   int getFrequency() const ;
   void setFrequency(int freq) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class CompoundIntegrator : public Integrator {
public:
   CompoundIntegrator() ;
   ~CompoundIntegrator() ;

   int getNumIntegrators() const ;
   int addIntegrator(Integrator *integrator) ;
   Integrator& getIntegrator(int index) ;
   const Integrator& getIntegrator(int index) const ;
   int getCurrentIntegrator() const ;
   void setCurrentIntegrator(int index) ;
   virtual double getStepSize() const ;
   virtual void setStepSize(double size) ;
   virtual double getConstraintTolerance() const ;
   virtual void setConstraintTolerance(double tol) ;
   virtual void step(int steps) ;
};

class Context {
public:
   Context(const System &system, Integrator &integrator) ;
   Context(const System &system, Integrator &integrator, Platform &platform) ;
   Context(const System &system, Integrator &integrator, Platform &platform, const std::map< std::string, std::string > &properties) ;
   ~Context() ;

   const System& getSystem() const ;
   const Platform& getPlatform() const ;
   Platform& getPlatform() ;
   State getState(int types, bool enforcePeriodicBox=false, int groups=0xFFFFFFFF) const ;
   void setState(const State &state) ;
   void setTime(double time) ;
%feature("autodoc", "setPositions(self, positions)") setPositions;
   void setPositions(const std::vector< Vec3 > &positions) ;
%feature("autodoc", "setVelocities(self, velocities)") setVelocities;
   void setVelocities(const std::vector< Vec3 > &velocities) ;
   void setVelocitiesToTemperature(double temperature, int randomSeed=osrngseed()) ;
   const std::map<std::string, double>& getParameters() const ;
   double getParameter(const std::string &name) const ;
   void setParameter(const std::string &name, double value) ;
   void setPeriodicBoxVectors(const Vec3 &a, const Vec3 &b, const Vec3 &c) ;
   void applyConstraints(double tol) ;
   void applyVelocityConstraints(double tol) ;
   void computeVirtualSites() ;
   void reinitialize(bool preserveState=false) ;
   const std::vector<std::vector<int> >& getMolecules() const ;
};

class TabulatedFunction {
public:
   virtual ~TabulatedFunction() ;

   virtual TabulatedFunction* Copy() const =0 ;
   bool getPeriodic() const ;
};

class Continuous1DFunction : public TabulatedFunction {
public:

   Continuous1DFunction::Continuous1DFunction(const std::vector< double > &values, double min, double max, bool periodic=false) ;
   %apply std::vector< double > & OUTPUT { std::vector< double > & values };
   %apply double & OUTPUT { double & min };
   %apply double & OUTPUT { double & max };
   void Continuous1DFunction::getFunctionParameters(std::vector< double > &values, double &min, double &max) const ;
   %clear std::vector< double > & values;
   %clear double & min;
   %clear double & max;
   void Continuous1DFunction::setFunctionParameters(const std::vector< double > &values, double min, double max) ;
   virtual Continuous1DFunction* Continuous1DFunction::Copy() const ;
};

class Continuous2DFunction : public TabulatedFunction {
public:

   Continuous2DFunction::Continuous2DFunction(int xsize, int ysize, const std::vector< double > &values, double xmin, double xmax, double ymin, double ymax, bool periodic=false) ;
   %apply int & OUTPUT { int & xsize };
   %apply int & OUTPUT { int & ysize };
   %apply std::vector< double > & OUTPUT { std::vector< double > & values };
   %apply double & OUTPUT { double & xmin };
   %apply double & OUTPUT { double & xmax };
   %apply double & OUTPUT { double & ymin };
   %apply double & OUTPUT { double & ymax };
   void Continuous2DFunction::getFunctionParameters(int &xsize, int &ysize, std::vector< double > &values, double &xmin, double &xmax, double &ymin, double &ymax) const ;
   %clear int & xsize;
   %clear int & ysize;
   %clear std::vector< double > & values;
   %clear double & xmin;
   %clear double & xmax;
   %clear double & ymin;
   %clear double & ymax;
   void Continuous2DFunction::setFunctionParameters(int xsize, int ysize, const std::vector< double > &values, double xmin, double xmax, double ymin, double ymax) ;
   virtual Continuous2DFunction* Continuous2DFunction::Copy() const ;
};

class Continuous3DFunction : public TabulatedFunction {
public:

   Continuous3DFunction::Continuous3DFunction(int xsize, int ysize, int zsize, const std::vector< double > &values, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax, bool periodic=false) ;
   %apply int & OUTPUT { int & xsize };
   %apply int & OUTPUT { int & ysize };
   %apply int & OUTPUT { int & zsize };
   %apply std::vector< double > & OUTPUT { std::vector< double > & values };
   %apply double & OUTPUT { double & xmin };
   %apply double & OUTPUT { double & xmax };
   %apply double & OUTPUT { double & ymin };
   %apply double & OUTPUT { double & ymax };
   %apply double & OUTPUT { double & zmin };
   %apply double & OUTPUT { double & zmax };
   void Continuous3DFunction::getFunctionParameters(int &xsize, int &ysize, int &zsize, std::vector< double > &values, double &xmin, double &xmax, double &ymin, double &ymax, double &zmin, double &zmax) const ;
   %clear int & xsize;
   %clear int & ysize;
   %clear int & zsize;
   %clear std::vector< double > & values;
   %clear double & xmin;
   %clear double & xmax;
   %clear double & ymin;
   %clear double & ymax;
   %clear double & zmin;
   %clear double & zmax;
   void Continuous3DFunction::setFunctionParameters(int xsize, int ysize, int zsize, const std::vector< double > &values, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) ;
   virtual Continuous3DFunction* Continuous3DFunction::Copy() const ;
};

class CustomAngleForce : public Force {
public:
   CustomAngleForce(const std::string &energy) ;

   int getNumAngles() const ;
   int getNumPerAngleParameters() const ;
   int getNumGlobalParameters() const ;
   int getNumEnergyParameterDerivatives() const ;
   const std::string& getEnergyFunction() const ;
   void setEnergyFunction(const std::string &energy) ;
   int addPerAngleParameter(const std::string &name) ;
   const std::string& getPerAngleParameterName(int index) const ;
   void setPerAngleParameterName(int index, const std::string &name) ;
   int addGlobalParameter(const std::string &name, double defaultValue) ;
   const std::string& getGlobalParameterName(int index) const ;
   void setGlobalParameterName(int index, const std::string &name) ;
   double getGlobalParameterDefaultValue(int index) const ;
   void setGlobalParameterDefaultValue(int index, double defaultValue) ;
   void addEnergyParameterDerivative(const std::string &name) ;
   const std::string& getEnergyParameterDerivativeName(int index) const ;
   int addAngle(int particle1, int particle2, int particle3, const std::vector< double > &parameters=std::vector< double >()) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply int & OUTPUT { int & particle3 };
   %apply std::vector< double > & OUTPUT { std::vector< double > & parameters };
   void getAngleParameters(int index, int &particle1, int &particle2, int &particle3, std::vector< double > &parameters) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear int & particle3;
   %clear std::vector< double > & parameters;
   void setAngleParameters(int index, int particle1, int particle2, int particle3, const std::vector< double > &parameters=std::vector< double >()) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class CustomBondForce : public Force {
public:
   CustomBondForce(const std::string &energy) ;

   int getNumBonds() const ;
   int getNumPerBondParameters() const ;
   int getNumGlobalParameters() const ;
   int getNumEnergyParameterDerivatives() const ;
   const std::string& getEnergyFunction() const ;
   void setEnergyFunction(const std::string &energy) ;
   int addPerBondParameter(const std::string &name) ;
   const std::string& getPerBondParameterName(int index) const ;
   void setPerBondParameterName(int index, const std::string &name) ;
   int addGlobalParameter(const std::string &name, double defaultValue) ;
   const std::string& getGlobalParameterName(int index) const ;
   void setGlobalParameterName(int index, const std::string &name) ;
   double getGlobalParameterDefaultValue(int index) const ;
   void setGlobalParameterDefaultValue(int index, double defaultValue) ;
   void addEnergyParameterDerivative(const std::string &name) ;
   const std::string& getEnergyParameterDerivativeName(int index) const ;
   int addBond(int particle1, int particle2, const std::vector< double > &parameters=std::vector< double >()) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply std::vector< double > & OUTPUT { std::vector< double > & parameters };
   void getBondParameters(int index, int &particle1, int &particle2, std::vector< double > &parameters) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear std::vector< double > & parameters;
   void setBondParameters(int index, int particle1, int particle2, const std::vector< double > &parameters=std::vector< double >()) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class CustomCentroidBondForce : public Force {
public:
   CustomCentroidBondForce(int numGroups, const std::string &energy) ;
   ~CustomCentroidBondForce() ;

   int getNumGroupsPerBond() const ;
   int getNumGroups() const ;
   int getNumBonds() const ;
   int getNumPerBondParameters() const ;
   int getNumGlobalParameters() const ;
   int getNumEnergyParameterDerivatives() const ;
   int getNumTabulatedFunctions() const ;
   int getNumFunctions() const ;
   const std::string& getEnergyFunction() const ;
   void setEnergyFunction(const std::string &energy) ;
   int addPerBondParameter(const std::string &name) ;
   const std::string& getPerBondParameterName(int index) const ;
   void setPerBondParameterName(int index, const std::string &name) ;
   int addGlobalParameter(const std::string &name, double defaultValue) ;
   const std::string& getGlobalParameterName(int index) const ;
   void setGlobalParameterName(int index, const std::string &name) ;
   double getGlobalParameterDefaultValue(int index) const ;
   void setGlobalParameterDefaultValue(int index, double defaultValue) ;
   void addEnergyParameterDerivative(const std::string &name) ;
   const std::string& getEnergyParameterDerivativeName(int index) const ;
   int addGroup(const std::vector< int > &particles, const std::vector< double > &weights=std::vector< double >()) ;
   %apply std::vector< int > & OUTPUT { std::vector< int > & particles };
   %apply std::vector< double > & OUTPUT { std::vector< double > & weights };
   void getGroupParameters(int index, std::vector< int > &particles, std::vector< double > &weights) const ;
   %clear std::vector< int > & particles;
   %clear std::vector< double > & weights;
   void setGroupParameters(int index, const std::vector< int > &particles, const std::vector< double > &weights=std::vector< double >()) ;
   int addBond(const std::vector< int > &groups, const std::vector< double > &parameters=std::vector< double >()) ;
   %apply std::vector< int > & OUTPUT { std::vector< int > & groups };
   %apply std::vector< double > & OUTPUT { std::vector< double > & parameters };
   void getBondParameters(int index, std::vector< int > &groups, std::vector< double > &parameters) const ;
   %clear std::vector< int > & groups;
   %clear std::vector< double > & parameters;
   void setBondParameters(int index, const std::vector< int > &groups, const std::vector< double > &parameters=std::vector< double >()) ;
   int addTabulatedFunction(const std::string &name, TabulatedFunction *function) ;
   const TabulatedFunction& getTabulatedFunction(int index) const ;
   TabulatedFunction& getTabulatedFunction(int index) ;
   const std::string& getTabulatedFunctionName(int index) const ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class CustomCompoundBondForce : public Force {
public:
   CustomCompoundBondForce(int numParticles, const std::string &energy) ;
   ~CustomCompoundBondForce() ;

   int getNumParticlesPerBond() const ;
   int getNumBonds() const ;
   int getNumPerBondParameters() const ;
   int getNumGlobalParameters() const ;
   int getNumEnergyParameterDerivatives() const ;
   int getNumTabulatedFunctions() const ;
   int getNumFunctions() const ;
   const std::string& getEnergyFunction() const ;
   void setEnergyFunction(const std::string &energy) ;
   int addPerBondParameter(const std::string &name) ;
   const std::string& getPerBondParameterName(int index) const ;
   void setPerBondParameterName(int index, const std::string &name) ;
   int addGlobalParameter(const std::string &name, double defaultValue) ;
   const std::string& getGlobalParameterName(int index) const ;
   void setGlobalParameterName(int index, const std::string &name) ;
   double getGlobalParameterDefaultValue(int index) const ;
   void setGlobalParameterDefaultValue(int index, double defaultValue) ;
   void addEnergyParameterDerivative(const std::string &name) ;
   const std::string& getEnergyParameterDerivativeName(int index) const ;
   int addBond(const std::vector< int > &particles, const std::vector< double > &parameters=std::vector< double >()) ;
   %apply std::vector< int > & OUTPUT { std::vector< int > & particles };
   %apply std::vector< double > & OUTPUT { std::vector< double > & parameters };
   void getBondParameters(int index, std::vector< int > &particles, std::vector< double > &parameters) const ;
   %clear std::vector< int > & particles;
   %clear std::vector< double > & parameters;
   void setBondParameters(int index, const std::vector< int > &particles, const std::vector< double > &parameters=std::vector< double >()) ;
   int addTabulatedFunction(const std::string &name, TabulatedFunction *function) ;
   const TabulatedFunction& getTabulatedFunction(int index) const ;
   TabulatedFunction& getTabulatedFunction(int index) ;
   const std::string& getTabulatedFunctionName(int index) const ;
   int addFunction(const std::string &name, const std::vector< double > &values, double min, double max) ;
   %apply std::string & OUTPUT { std::string & name };
   %apply std::vector< double > & OUTPUT { std::vector< double > & values };
   %apply double & OUTPUT { double & min };
   %apply double & OUTPUT { double & max };
   void getFunctionParameters(int index, std::string &name, std::vector< double > &values, double &min, double &max) const ;
   %clear std::string & name;
   %clear std::vector< double > & values;
   %clear double & min;
   %clear double & max;
   void setFunctionParameters(int index, const std::string &name, const std::vector< double > &values, double min, double max) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class CustomCVForce : public Force {
public:
   CustomCVForce(const std::string &energy) ;
   ~CustomCVForce() ;

   int getNumCollectiveVariables() const ;
   int getNumGlobalParameters() const ;
   int getNumEnergyParameterDerivatives() const ;
   int getNumTabulatedFunctions() const ;
   const std::string& getEnergyFunction() const ;
   void setEnergyFunction(const std::string &energy) ;
   int addCollectiveVariable(const std::string &name, Force *variable) ;
   const std::string& getCollectiveVariableName(int index) const ;
   Force& getCollectiveVariable(int index) ;
   const Force& getCollectiveVariable(int index) const ;
   int addGlobalParameter(const std::string &name, double defaultValue) ;
   const std::string& getGlobalParameterName(int index) const ;
   void setGlobalParameterName(int index, const std::string &name) ;
   double getGlobalParameterDefaultValue(int index) const ;
   void setGlobalParameterDefaultValue(int index, double defaultValue) ;
   void addEnergyParameterDerivative(const std::string &name) ;
   const std::string& getEnergyParameterDerivativeName(int index) const ;
   int addTabulatedFunction(const std::string &name, TabulatedFunction *function) ;
   const TabulatedFunction& getTabulatedFunction(int index) const ;
   TabulatedFunction& getTabulatedFunction(int index) ;
   const std::string& getTabulatedFunctionName(int index) const ;
   %apply Context & OUTPUT { Context & context };
   %apply std::vector< double > & OUTPUT { std::vector< double > & values };
   void getCollectiveVariableValues(Context &context, std::vector< double > &values) ;
   %clear Context & context;
   %clear std::vector< double > & values;
   %apply Context & OUTPUT { Context & context };
   Context& getInnerContext(Context &context) ;
   %clear Context & context;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class CustomExternalForce : public Force {
public:
   CustomExternalForce(const std::string &energy) ;

   int getNumParticles() const ;
   int getNumPerParticleParameters() const ;
   int getNumGlobalParameters() const ;
   const std::string& getEnergyFunction() const ;
   void setEnergyFunction(const std::string &energy) ;
   int addPerParticleParameter(const std::string &name) ;
   const std::string& getPerParticleParameterName(int index) const ;
   void setPerParticleParameterName(int index, const std::string &name) ;
   int addGlobalParameter(const std::string &name, double defaultValue) ;
   const std::string& getGlobalParameterName(int index) const ;
   void setGlobalParameterName(int index, const std::string &name) ;
   double getGlobalParameterDefaultValue(int index) const ;
   void setGlobalParameterDefaultValue(int index, double defaultValue) ;
   int addParticle(int particle, const std::vector< double > &parameters=std::vector< double >()) ;
   %apply int & OUTPUT { int & particle };
   %apply std::vector< double > & OUTPUT { std::vector< double > & parameters };
   void getParticleParameters(int index, int &particle, std::vector< double > &parameters) const ;
   %clear int & particle;
   %clear std::vector< double > & parameters;
   void setParticleParameters(int index, int particle, const std::vector< double > &parameters=std::vector< double >()) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class CustomGBForce : public Force {
public:
   enum NonbondedMethod {
      NoCutoff =  0,
      CutoffNonPeriodic =  1,
      CutoffPeriodic =  2
   };
   enum ComputationType {
      SingleParticle =  0,
      ParticlePair =  1,
      ParticlePairNoExclusions =  2
   };

   CustomGBForce() ;
   ~CustomGBForce() ;

   int getNumParticles() const ;
   int getNumExclusions() const ;
   int getNumPerParticleParameters() const ;
   int getNumGlobalParameters() const ;
   int getNumEnergyParameterDerivatives() const ;
   int getNumTabulatedFunctions() const ;
   int getNumFunctions() const ;
   int getNumComputedValues() const ;
   int getNumEnergyTerms() const ;
   NonbondedMethod getNonbondedMethod() const ;
   void setNonbondedMethod(NonbondedMethod method) ;
   double getCutoffDistance() const ;
   void setCutoffDistance(double distance) ;
   int addPerParticleParameter(const std::string &name) ;
   const std::string& getPerParticleParameterName(int index) const ;
   void setPerParticleParameterName(int index, const std::string &name) ;
   int addGlobalParameter(const std::string &name, double defaultValue) ;
   const std::string& getGlobalParameterName(int index) const ;
   void setGlobalParameterName(int index, const std::string &name) ;
   double getGlobalParameterDefaultValue(int index) const ;
   void setGlobalParameterDefaultValue(int index, double defaultValue) ;
   void addEnergyParameterDerivative(const std::string &name) ;
   const std::string& getEnergyParameterDerivativeName(int index) const ;
   int addParticle(const std::vector< double > &parameters=std::vector< double >()) ;
   %apply std::vector< double > & OUTPUT { std::vector< double > & parameters };
   void getParticleParameters(int index, std::vector< double > &parameters) const ;
   %clear std::vector< double > & parameters;
   void setParticleParameters(int index, const std::vector< double > &parameters) ;
   int addComputedValue(const std::string &name, const std::string &expression, ComputationType type) ;
   %apply std::string & OUTPUT { std::string & name };
   %apply std::string & OUTPUT { std::string & expression };
   %apply int & OUTPUT { ComputationType & type };
   void getComputedValueParameters(int index, std::string &name, std::string &expression, ComputationType &type) const ;
   %clear std::string & name;
   %clear std::string & expression;
   %clear ComputationType & type;
   void setComputedValueParameters(int index, const std::string &name, const std::string &expression, ComputationType type) ;
   int addEnergyTerm(const std::string &expression, ComputationType type) ;
   %apply std::string & OUTPUT { std::string & expression };
   %apply int & OUTPUT { ComputationType & type };
   void getEnergyTermParameters(int index, std::string &expression, ComputationType &type) const ;
   %clear std::string & expression;
   %clear ComputationType & type;
   void setEnergyTermParameters(int index, const std::string &expression, ComputationType type) ;
   int addExclusion(int particle1, int particle2) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   void getExclusionParticles(int index, int &particle1, int &particle2) const ;
   %clear int & particle1;
   %clear int & particle2;
   void setExclusionParticles(int index, int particle1, int particle2) ;
   int addTabulatedFunction(const std::string &name, TabulatedFunction *function) ;
   const TabulatedFunction& getTabulatedFunction(int index) const ;
   TabulatedFunction& getTabulatedFunction(int index) ;
   const std::string& getTabulatedFunctionName(int index) const ;
   int addFunction(const std::string &name, const std::vector< double > &values, double min, double max) ;
   %apply std::string & OUTPUT { std::string & name };
   %apply std::vector< double > & OUTPUT { std::vector< double > & values };
   %apply double & OUTPUT { double & min };
   %apply double & OUTPUT { double & max };
   void getFunctionParameters(int index, std::string &name, std::vector< double > &values, double &min, double &max) const ;
   %clear std::string & name;
   %clear std::vector< double > & values;
   %clear double & min;
   %clear double & max;
   void setFunctionParameters(int index, const std::string &name, const std::vector< double > &values, double min, double max) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class CustomHbondForce : public Force {
public:
   enum NonbondedMethod {
      NoCutoff =  0,
      CutoffNonPeriodic =  1,
      CutoffPeriodic =  2
   };

   CustomHbondForce(const std::string &energy) ;
   ~CustomHbondForce() ;

   int getNumDonors() const ;
   int getNumAcceptors() const ;
   int getNumExclusions() const ;
   int getNumPerDonorParameters() const ;
   int getNumPerAcceptorParameters() const ;
   int getNumGlobalParameters() const ;
   int getNumTabulatedFunctions() const ;
   int getNumFunctions() const ;
   const std::string& getEnergyFunction() const ;
   void setEnergyFunction(const std::string &energy) ;
   NonbondedMethod getNonbondedMethod() const ;
   void setNonbondedMethod(NonbondedMethod method) ;
   double getCutoffDistance() const ;
   void setCutoffDistance(double distance) ;
   int addPerDonorParameter(const std::string &name) ;
   const std::string& getPerDonorParameterName(int index) const ;
   void setPerDonorParameterName(int index, const std::string &name) ;
   int addPerAcceptorParameter(const std::string &name) ;
   const std::string& getPerAcceptorParameterName(int index) const ;
   void setPerAcceptorParameterName(int index, const std::string &name) ;
   int addGlobalParameter(const std::string &name, double defaultValue) ;
   const std::string& getGlobalParameterName(int index) const ;
   void setGlobalParameterName(int index, const std::string &name) ;
   double getGlobalParameterDefaultValue(int index) const ;
   void setGlobalParameterDefaultValue(int index, double defaultValue) ;
   int addDonor(int d1, int d2, int d3, const std::vector< double > &parameters=std::vector< double >()) ;
   %apply int & OUTPUT { int & d1 };
   %apply int & OUTPUT { int & d2 };
   %apply int & OUTPUT { int & d3 };
   %apply std::vector< double > & OUTPUT { std::vector< double > & parameters };
   void getDonorParameters(int index, int &d1, int &d2, int &d3, std::vector< double > &parameters) const ;
   %clear int & d1;
   %clear int & d2;
   %clear int & d3;
   %clear std::vector< double > & parameters;
   void setDonorParameters(int index, int d1, int d2, int d3, const std::vector< double > &parameters=std::vector< double >()) ;
   int addAcceptor(int a1, int a2, int a3, const std::vector< double > &parameters=std::vector< double >()) ;
   %apply int & OUTPUT { int & a1 };
   %apply int & OUTPUT { int & a2 };
   %apply int & OUTPUT { int & a3 };
   %apply std::vector< double > & OUTPUT { std::vector< double > & parameters };
   void getAcceptorParameters(int index, int &a1, int &a2, int &a3, std::vector< double > &parameters) const ;
   %clear int & a1;
   %clear int & a2;
   %clear int & a3;
   %clear std::vector< double > & parameters;
   void setAcceptorParameters(int index, int a1, int a2, int a3, const std::vector< double > &parameters=std::vector< double >()) ;
   int addExclusion(int donor, int acceptor) ;
   %apply int & OUTPUT { int & donor };
   %apply int & OUTPUT { int & acceptor };
   void getExclusionParticles(int index, int &donor, int &acceptor) const ;
   %clear int & donor;
   %clear int & acceptor;
   void setExclusionParticles(int index, int donor, int acceptor) ;
   int addTabulatedFunction(const std::string &name, TabulatedFunction *function) ;
   const TabulatedFunction& getTabulatedFunction(int index) const ;
   TabulatedFunction& getTabulatedFunction(int index) ;
   const std::string& getTabulatedFunctionName(int index) const ;
   int addFunction(const std::string &name, const std::vector< double > &values, double min, double max) ;
   %apply std::string & OUTPUT { std::string & name };
   %apply std::vector< double > & OUTPUT { std::vector< double > & values };
   %apply double & OUTPUT { double & min };
   %apply double & OUTPUT { double & max };
   void getFunctionParameters(int index, std::string &name, std::vector< double > &values, double &min, double &max) const ;
   %clear std::string & name;
   %clear std::vector< double > & values;
   %clear double & min;
   %clear double & max;
   void setFunctionParameters(int index, const std::string &name, const std::vector< double > &values, double min, double max) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class CustomIntegrator : public Integrator {
public:
   enum ComputationType {
      ComputeGlobal =  0,
      ComputePerDof =  1,
      ComputeSum =  2,
      ConstrainPositions =  3,
      ConstrainVelocities =  4,
      UpdateContextState =  5,
      IfBlockStart =  6,
      WhileBlockStart =  7,
      BlockEnd =  8
   };

   CustomIntegrator(double stepSize) ;
   ~CustomIntegrator() ;

   int getNumGlobalVariables() const ;
   int getNumPerDofVariables() const ;
   int getNumComputations() const ;
   int getNumTabulatedFunctions() const ;
   int addGlobalVariable(const std::string &name, double initialValue) ;
   const std::string& getGlobalVariableName(int index) const ;
   int addPerDofVariable(const std::string &name, double initialValue) ;
   const std::string& getPerDofVariableName(int index) const ;
   double getGlobalVariable(int index) const ;
   double getGlobalVariableByName(const std::string &name) const ;
   void setGlobalVariable(int index, double value) ;
   void setGlobalVariableByName(const std::string &name, double value) ;
   %apply std::vector< Vec3 > & OUTPUT { std::vector< Vec3 > & values };
   void getPerDofVariable(int index, std::vector< Vec3 > &values) const ;
   %clear std::vector< Vec3 > & values;
   %apply std::vector< Vec3 > & OUTPUT { std::vector< Vec3 > & values };
   void getPerDofVariableByName(const std::string &name, std::vector< Vec3 > &values) const ;
   %clear std::vector< Vec3 > & values;
   void setPerDofVariable(int index, const std::vector< Vec3 > &values) ;
   void setPerDofVariableByName(const std::string &name, const std::vector< Vec3 > &values) ;
   int addComputeGlobal(const std::string &variable, const std::string &expression) ;
   int addComputePerDof(const std::string &variable, const std::string &expression) ;
   int addComputeSum(const std::string &variable, const std::string &expression) ;
   int addConstrainPositions() ;
   int addConstrainVelocities() ;
   int addUpdateContextState() ;
   int beginIfBlock(const std::string &condition) ;
   int beginWhileBlock(const std::string &condition) ;
   int endBlock() ;
   %apply int & OUTPUT { ComputationType & type };
   %apply std::string & OUTPUT { std::string & variable };
   %apply std::string & OUTPUT { std::string & expression };
   void getComputationStep(int index, ComputationType &type, std::string &variable, std::string &expression) const ;
   %clear ComputationType & type;
   %clear std::string & variable;
   %clear std::string & expression;
   int addTabulatedFunction(const std::string &name, TabulatedFunction *function) ;
   const TabulatedFunction& getTabulatedFunction(int index) const ;
   TabulatedFunction& getTabulatedFunction(int index) ;
   const std::string& getTabulatedFunctionName(int index) const ;
   const std::string& getKineticEnergyExpression() const ;
   void setKineticEnergyExpression(const std::string &expression) ;
   int getRandomNumberSeed() const ;
   void setRandomNumberSeed(int seed) ;
   virtual void step(int steps) ;
};

class CustomManyParticleForce : public Force {
public:
   enum NonbondedMethod {
      NoCutoff =  0,
      CutoffNonPeriodic =  1,
      CutoffPeriodic =  2
   };
   enum PermutationMode {
      SinglePermutation =  0,
      UniqueCentralParticle =  1
   };

   CustomManyParticleForce(int particlesPerSet, const std::string &energy) ;
   ~CustomManyParticleForce() ;

   int getNumParticlesPerSet() const ;
   int getNumParticles() const ;
   int getNumExclusions() const ;
   int getNumPerParticleParameters() const ;
   int getNumGlobalParameters() const ;
   int getNumTabulatedFunctions() const ;
   const std::string& getEnergyFunction() const ;
   void setEnergyFunction(const std::string &energy) ;
   NonbondedMethod getNonbondedMethod() const ;
   void setNonbondedMethod(NonbondedMethod method) ;
   PermutationMode getPermutationMode() const ;
   void setPermutationMode(PermutationMode mode) ;
   double getCutoffDistance() const ;
   void setCutoffDistance(double distance) ;
   int addPerParticleParameter(const std::string &name) ;
   const std::string& getPerParticleParameterName(int index) const ;
   void setPerParticleParameterName(int index, const std::string &name) ;
   int addGlobalParameter(const std::string &name, double defaultValue) ;
   const std::string& getGlobalParameterName(int index) const ;
   void setGlobalParameterName(int index, const std::string &name) ;
   double getGlobalParameterDefaultValue(int index) const ;
   void setGlobalParameterDefaultValue(int index, double defaultValue) ;
   int addParticle(const std::vector< double > &parameters=std::vector< double >(), int type=0) ;
   %apply std::vector< double > & OUTPUT { std::vector< double > & parameters };
   %apply int & OUTPUT { int & type };
   void getParticleParameters(int index, std::vector< double > &parameters, int &type) const ;
   %clear std::vector< double > & parameters;
   %clear int & type;
   void setParticleParameters(int index, const std::vector< double > &parameters, int type) ;
   int addExclusion(int particle1, int particle2) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   void getExclusionParticles(int index, int &particle1, int &particle2) const ;
   %clear int & particle1;
   %clear int & particle2;
   void setExclusionParticles(int index, int particle1, int particle2) ;
   void createExclusionsFromBonds(const std::vector< std::pair< int, int > > &bonds, int bondCutoff) ;
   %apply std::set< int > & OUTPUT { std::set< int > & types };
   void getTypeFilter(int index, std::set< int > &types) const ;
   %clear std::set< int > & types;
   void setTypeFilter(int index, const std::set< int > &types) ;
   int addTabulatedFunction(const std::string &name, TabulatedFunction *function) ;
   const TabulatedFunction& getTabulatedFunction(int index) const ;
   TabulatedFunction& getTabulatedFunction(int index) ;
   const std::string& getTabulatedFunctionName(int index) const ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class CustomNonbondedForce : public Force {
public:
   enum NonbondedMethod {
      NoCutoff =  0,
      CutoffNonPeriodic =  1,
      CutoffPeriodic =  2
   };

   CustomNonbondedForce(const std::string &energy) ;
   CustomNonbondedForce(const CustomNonbondedForce &rhs) ;
   ~CustomNonbondedForce() ;

   int getNumParticles() const ;
   int getNumExclusions() const ;
   int getNumPerParticleParameters() const ;
   int getNumGlobalParameters() const ;
   int getNumTabulatedFunctions() const ;
   int getNumFunctions() const ;
   int getNumInteractionGroups() const ;
   int getNumEnergyParameterDerivatives() const ;
   const std::string& getEnergyFunction() const ;
   void setEnergyFunction(const std::string &energy) ;
   NonbondedMethod getNonbondedMethod() const ;
   void setNonbondedMethod(NonbondedMethod method) ;
   double getCutoffDistance() const ;
   void setCutoffDistance(double distance) ;
   bool getUseSwitchingFunction() const ;
   void setUseSwitchingFunction(bool use) ;
   double getSwitchingDistance() const ;
   void setSwitchingDistance(double distance) ;
   bool getUseLongRangeCorrection() const ;
   void setUseLongRangeCorrection(bool use) ;
   int addPerParticleParameter(const std::string &name) ;
   const std::string& getPerParticleParameterName(int index) const ;
   void setPerParticleParameterName(int index, const std::string &name) ;
   int addGlobalParameter(const std::string &name, double defaultValue) ;
   const std::string& getGlobalParameterName(int index) const ;
   void setGlobalParameterName(int index, const std::string &name) ;
   double getGlobalParameterDefaultValue(int index) const ;
   void setGlobalParameterDefaultValue(int index, double defaultValue) ;
   void addEnergyParameterDerivative(const std::string &name) ;
   const std::string& getEnergyParameterDerivativeName(int index) const ;
   int addParticle(const std::vector< double > &parameters=std::vector< double >()) ;
   %apply std::vector< double > & OUTPUT { std::vector< double > & parameters };
   void getParticleParameters(int index, std::vector< double > &parameters) const ;
   %clear std::vector< double > & parameters;
   void setParticleParameters(int index, const std::vector< double > &parameters) ;
   int addExclusion(int particle1, int particle2) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   void getExclusionParticles(int index, int &particle1, int &particle2) const ;
   %clear int & particle1;
   %clear int & particle2;
   void setExclusionParticles(int index, int particle1, int particle2) ;
   void createExclusionsFromBonds(const std::vector< std::pair< int, int > > &bonds, int bondCutoff) ;
   int addTabulatedFunction(const std::string &name, TabulatedFunction *function) ;
   const TabulatedFunction& getTabulatedFunction(int index) const ;
   TabulatedFunction& getTabulatedFunction(int index) ;
   const std::string& getTabulatedFunctionName(int index) const ;
   int addFunction(const std::string &name, const std::vector< double > &values, double min, double max) ;
   %apply std::string & OUTPUT { std::string & name };
   %apply std::vector< double > & OUTPUT { std::vector< double > & values };
   %apply double & OUTPUT { double & min };
   %apply double & OUTPUT { double & max };
   void getFunctionParameters(int index, std::string &name, std::vector< double > &values, double &min, double &max) const ;
   %clear std::string & name;
   %clear std::vector< double > & values;
   %clear double & min;
   %clear double & max;
   void setFunctionParameters(int index, const std::string &name, const std::vector< double > &values, double min, double max) ;
   int addInteractionGroup(const std::set< int > &set1, const std::set< int > &set2) ;
   %apply std::set< int > & OUTPUT { std::set< int > & set1 };
   %apply std::set< int > & OUTPUT { std::set< int > & set2 };
   void getInteractionGroupParameters(int index, std::set< int > &set1, std::set< int > &set2) const ;
   %clear std::set< int > & set1;
   %clear std::set< int > & set2;
   void setInteractionGroupParameters(int index, const std::set< int > &set1, const std::set< int > &set2) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class CustomTorsionForce : public Force {
public:
   CustomTorsionForce(const std::string &energy) ;

   int getNumTorsions() const ;
   int getNumPerTorsionParameters() const ;
   int getNumGlobalParameters() const ;
   int getNumEnergyParameterDerivatives() const ;
   const std::string& getEnergyFunction() const ;
   void setEnergyFunction(const std::string &energy) ;
   int addPerTorsionParameter(const std::string &name) ;
   const std::string& getPerTorsionParameterName(int index) const ;
   void setPerTorsionParameterName(int index, const std::string &name) ;
   int addGlobalParameter(const std::string &name, double defaultValue) ;
   const std::string& getGlobalParameterName(int index) const ;
   void setGlobalParameterName(int index, const std::string &name) ;
   double getGlobalParameterDefaultValue(int index) const ;
   void setGlobalParameterDefaultValue(int index, double defaultValue) ;
   void addEnergyParameterDerivative(const std::string &name) ;
   const std::string& getEnergyParameterDerivativeName(int index) const ;
   int addTorsion(int particle1, int particle2, int particle3, int particle4, const std::vector< double > &parameters=std::vector< double >()) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply int & OUTPUT { int & particle3 };
   %apply int & OUTPUT { int & particle4 };
   %apply std::vector< double > & OUTPUT { std::vector< double > & parameters };
   void getTorsionParameters(int index, int &particle1, int &particle2, int &particle3, int &particle4, std::vector< double > &parameters) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear int & particle3;
   %clear int & particle4;
   %clear std::vector< double > & parameters;
   void setTorsionParameters(int index, int particle1, int particle2, int particle3, int particle4, const std::vector< double > &parameters=std::vector< double >()) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class Discrete1DFunction : public TabulatedFunction {
public:

   Discrete1DFunction::Discrete1DFunction(const std::vector< double > &values) ;
   %apply std::vector< double > & OUTPUT { std::vector< double > & values };
   void Discrete1DFunction::getFunctionParameters(std::vector< double > &values) const ;
   %clear std::vector< double > & values;
   void Discrete1DFunction::setFunctionParameters(const std::vector< double > &values) ;
   virtual Discrete1DFunction* Discrete1DFunction::Copy() const ;
};

class Discrete2DFunction : public TabulatedFunction {
public:

   Discrete2DFunction::Discrete2DFunction(int xsize, int ysize, const std::vector< double > &values) ;
   %apply int & OUTPUT { int & xsize };
   %apply int & OUTPUT { int & ysize };
   %apply std::vector< double > & OUTPUT { std::vector< double > & values };
   void Discrete2DFunction::getFunctionParameters(int &xsize, int &ysize, std::vector< double > &values) const ;
   %clear int & xsize;
   %clear int & ysize;
   %clear std::vector< double > & values;
   void Discrete2DFunction::setFunctionParameters(int xsize, int ysize, const std::vector< double > &values) ;
   virtual Discrete2DFunction* Discrete2DFunction::Copy() const ;
};

class Discrete3DFunction : public TabulatedFunction {
public:

   Discrete3DFunction::Discrete3DFunction(int xsize, int ysize, int zsize, const std::vector< double > &values) ;
   %apply int & OUTPUT { int & xsize };
   %apply int & OUTPUT { int & ysize };
   %apply int & OUTPUT { int & zsize };
   %apply std::vector< double > & OUTPUT { std::vector< double > & values };
   void Discrete3DFunction::getFunctionParameters(int &xsize, int &ysize, int &zsize, std::vector< double > &values) const ;
   %clear int & xsize;
   %clear int & ysize;
   %clear int & zsize;
   %clear std::vector< double > & values;
   void Discrete3DFunction::setFunctionParameters(int xsize, int ysize, int zsize, const std::vector< double > &values) ;
   virtual Discrete3DFunction* Discrete3DFunction::Copy() const ;
};

class DrudeForce : public Force {
public:
   DrudeForce() ;

   int getNumParticles() const ;
   int getNumScreenedPairs() const ;
   int addParticle(int particle, int particle1, int particle2, int particle3, int particle4, double charge, double polarizability, double aniso12, double aniso34) ;
   %apply int & OUTPUT { int & particle };
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply int & OUTPUT { int & particle3 };
   %apply int & OUTPUT { int & particle4 };
   %apply double & OUTPUT { double & charge };
   %apply double & OUTPUT { double & polarizability };
   %apply double & OUTPUT { double & aniso12 };
   %apply double & OUTPUT { double & aniso34 };
   void getParticleParameters(int index, int &particle, int &particle1, int &particle2, int &particle3, int &particle4, double &charge, double &polarizability, double &aniso12, double &aniso34) const ;
   %clear int & particle;
   %clear int & particle1;
   %clear int & particle2;
   %clear int & particle3;
   %clear int & particle4;
   %clear double & charge;
   %clear double & polarizability;
   %clear double & aniso12;
   %clear double & aniso34;
   void setParticleParameters(int index, int particle, int particle1, int particle2, int particle3, int particle4, double charge, double polarizability, double aniso12, double aniso34) ;
   int addScreenedPair(int particle1, int particle2, double thole) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply double & OUTPUT { double & thole };
   void getScreenedPairParameters(int index, int &particle1, int &particle2, double &thole) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear double & thole;
   void setScreenedPairParameters(int index, int particle1, int particle2, double thole) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class DrudeIntegrator : public Integrator {
public:
   DrudeIntegrator(double stepSize) ;

   virtual void step(int steps) override ;
   double getDrudeTemperature() const ;
   void setDrudeTemperature(double temp) ;
   double getMaxDrudeDistance() const ;
   void setMaxDrudeDistance(double distance) ;
   void setRandomNumberSeed(int seed) ;
   int getRandomNumberSeed() const ;
};

class DrudeLangevinIntegrator : public DrudeIntegrator {
public:
   DrudeLangevinIntegrator(double temperature, double frictionCoeff, double drudeTemperature, double drudeFrictionCoeff, double stepSize) ;

   double getTemperature() const ;
   void setTemperature(double temp) ;
   double getFriction() const ;
   void setFriction(double coeff) ;
   double getDrudeFriction() const ;
   void setDrudeFriction(double coeff) ;
   virtual void step(int steps) override ;
};

class NoseHooverIntegrator : public Integrator {
public:
   NoseHooverIntegrator(double stepSize) ;
   NoseHooverIntegrator(double temperature, double collisionFrequency, double stepSize, int chainLength=3, int numMTS=3, int numYoshidaSuzuki=7) ;
   ~NoseHooverIntegrator() ;

   virtual void step(int steps) ;
   int addThermostat(double temperature, double collisionFrequency, int chainLength, int numMTS, int numYoshidaSuzuki) ;
   int addSubsystemThermostat(const std::vector< int > &thermostatedParticles, const std::vector< std::pair< int, int > > &thermostatedPairs, double temperature, double collisionFrequency, double relativeTemperature, double relativeCollisionFrequency, int chainLength=3, int numMTS=3, int numYoshidaSuzuki=7) ;
   double getTemperature(int chainID=0) const ;
   void setTemperature(double temperature, int chainID=0) ;
   double getRelativeTemperature(int chainID=0) const ;
   void setRelativeTemperature(double temperature, int chainID=0) ;
   double getCollisionFrequency(int chainID=0) const ;
   void setCollisionFrequency(double frequency, int chainID=0) ;
   double getRelativeCollisionFrequency(int chainID=0) const ;
   void setRelativeCollisionFrequency(double frequency, int chainID=0) ;
   double computeHeatBathEnergy() ;
   int getNumThermostats() const ;
   const NoseHooverChain& getThermostat(int chainID=0) const ;
   bool hasSubsystemThermostats() const ;
   double getMaximumPairDistance() const ;
   void setMaximumPairDistance(double distance) ;
};

class DrudeNoseHooverIntegrator : public NoseHooverIntegrator {
public:
   DrudeNoseHooverIntegrator(double temperature, double collisionFrequency, double drudeTemperature, double drudeCollisionFrequency, double stepSize, int chainLength=3, int numMTS=3, int numYoshidaSuzuki=7) ;
   virtual ~DrudeNoseHooverIntegrator() ;

   %apply ContextImpl & OUTPUT { ContextImpl & context };
   virtual void initialize(ContextImpl &context) override ;
   %clear ContextImpl & context;
   double getMaxDrudeDistance() const ;
   void setMaxDrudeDistance(double distance) ;
   double computeDrudeKineticEnergy() ;
   double computeTotalKineticEnergy() ;
   virtual std::vector<Vec3> getVelocitiesForTemperature(const System &system, double temperature, int randomSeed) const override ;
};

class DrudeSCFIntegrator : public DrudeIntegrator {
public:
   DrudeSCFIntegrator(double stepSize) ;

   double getMinimizationErrorTolerance() const ;
   void setMinimizationErrorTolerance(double tol) ;
   virtual void step(int steps) override ;
};

class GayBerneForce : public Force {
public:
   enum NonbondedMethod {
      NoCutoff =  0,
      CutoffNonPeriodic =  1,
      CutoffPeriodic =  2
   };

   GayBerneForce() ;

   int getNumParticles() const ;
   int getNumExceptions() const ;
   NonbondedMethod getNonbondedMethod() const ;
   void setNonbondedMethod(NonbondedMethod method) ;
   double getCutoffDistance() const ;
   void setCutoffDistance(double distance) ;
   bool getUseSwitchingFunction() const ;
   void setUseSwitchingFunction(bool use) ;
   double getSwitchingDistance() const ;
   void setSwitchingDistance(double distance) ;
   int addParticle(double sigma, double epsilon, int xparticle, int yparticle, double sx, double sy, double sz, double ex, double ey, double ez) ;
   %apply double & OUTPUT { double & sigma };
   %apply double & OUTPUT { double & epsilon };
   %apply int & OUTPUT { int & xparticle };
   %apply int & OUTPUT { int & yparticle };
   %apply double & OUTPUT { double & sx };
   %apply double & OUTPUT { double & sy };
   %apply double & OUTPUT { double & sz };
   %apply double & OUTPUT { double & ex };
   %apply double & OUTPUT { double & ey };
   %apply double & OUTPUT { double & ez };
   void getParticleParameters(int index, double &sigma, double &epsilon, int &xparticle, int &yparticle, double &sx, double &sy, double &sz, double &ex, double &ey, double &ez) const ;
   %clear double & sigma;
   %clear double & epsilon;
   %clear int & xparticle;
   %clear int & yparticle;
   %clear double & sx;
   %clear double & sy;
   %clear double & sz;
   %clear double & ex;
   %clear double & ey;
   %clear double & ez;
   void setParticleParameters(int index, double sigma, double epsilon, int xparticle, int yparticle, double sx, double sy, double sz, double ex, double ey, double ez) ;
   int addException(int particle1, int particle2, double sigma, double epsilon, bool replace=false) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply double & OUTPUT { double & sigma };
   %apply double & OUTPUT { double & epsilon };
   void getExceptionParameters(int index, int &particle1, int &particle2, double &sigma, double &epsilon) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear double & sigma;
   %clear double & epsilon;
   void setExceptionParameters(int index, int particle1, int particle2, double sigma, double epsilon) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class GBSAOBCForce : public Force {
public:
   enum NonbondedMethod {
      NoCutoff =  0,
      CutoffNonPeriodic =  1,
      CutoffPeriodic =  2
   };

   GBSAOBCForce() ;

   int getNumParticles() const ;
   int addParticle(double charge, double radius, double scalingFactor) ;
   %apply double & OUTPUT { double & charge };
   %apply double & OUTPUT { double & radius };
   %apply double & OUTPUT { double & scalingFactor };
   void getParticleParameters(int index, double &charge, double &radius, double &scalingFactor) const ;
   %clear double & charge;
   %clear double & radius;
   %clear double & scalingFactor;
   void setParticleParameters(int index, double charge, double radius, double scalingFactor) ;
   double getSolventDielectric() const ;
   void setSolventDielectric(double dielectric) ;
   double getSoluteDielectric() const ;
   void setSoluteDielectric(double dielectric) ;
   double getSurfaceAreaEnergy() const ;
   void setSurfaceAreaEnergy(double energy) ;
   NonbondedMethod getNonbondedMethod() const ;
   void setNonbondedMethod(NonbondedMethod method) ;
   double getCutoffDistance() const ;
   void setCutoffDistance(double distance) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class HarmonicAngleForce : public Force {
public:
   HarmonicAngleForce() ;

   int getNumAngles() const ;
   int addAngle(int particle1, int particle2, int particle3, double angle, double k) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply int & OUTPUT { int & particle3 };
   %apply double & OUTPUT { double & angle };
   %apply double & OUTPUT { double & k };
   void getAngleParameters(int index, int &particle1, int &particle2, int &particle3, double &angle, double &k) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear int & particle3;
   %clear double & angle;
   %clear double & k;
   void setAngleParameters(int index, int particle1, int particle2, int particle3, double angle, double k) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class HarmonicBondForce : public Force {
public:
   HarmonicBondForce() ;

   int getNumBonds() const ;
   int addBond(int particle1, int particle2, double length, double k) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply double & OUTPUT { double & length };
   %apply double & OUTPUT { double & k };
   void getBondParameters(int index, int &particle1, int &particle2, double &length, double &k) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear double & length;
   %clear double & k;
   void setBondParameters(int index, int particle1, int particle2, double length, double k) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class HippoNonbondedForce : public Force {
public:
   enum NonbondedMethod {
      NoCutoff =  0,
      PME =  1
   };
   enum ParticleAxisTypes {
      ZThenX =  0,
      Bisector =  1,
      ZBisect =  2,
      ThreeFold =  3,
      ZOnly =  4,
      NoAxisType =  5
   };

   HippoNonbondedForce() ;

   int getNumParticles() const ;
   int getNumExceptions() const ;
   NonbondedMethod getNonbondedMethod() const ;
   void setNonbondedMethod(NonbondedMethod method) ;
   double getCutoffDistance() const ;
   void setCutoffDistance(double distance) ;
   double getSwitchingDistance() const ;
   void setSwitchingDistance(double distance) ;
   const std::vector<double>& getExtrapolationCoefficients() const ;
   void setExtrapolationCoefficients(const std::vector< double > &coefficients) ;
   %apply double & OUTPUT { double & alpha };
   %apply int & OUTPUT { int & nx };
   %apply int & OUTPUT { int & ny };
   %apply int & OUTPUT { int & nz };
   void getPMEParameters(double &alpha, int &nx, int &ny, int &nz) const ;
   %clear double & alpha;
   %clear int & nx;
   %clear int & ny;
   %clear int & nz;
   %apply double & OUTPUT { double & alpha };
   %apply int & OUTPUT { int & nx };
   %apply int & OUTPUT { int & ny };
   %apply int & OUTPUT { int & nz };
   void getDPMEParameters(double &alpha, int &nx, int &ny, int &nz) const ;
   %clear double & alpha;
   %clear int & nx;
   %clear int & ny;
   %clear int & nz;
   void setPMEParameters(double alpha, int nx, int ny, int nz) ;
   void setDPMEParameters(double alpha, int nx, int ny, int nz) ;
   %apply double & OUTPUT { double & alpha };
   %apply int & OUTPUT { int & nx };
   %apply int & OUTPUT { int & ny };
   %apply int & OUTPUT { int & nz };
   void getPMEParametersInContext(const Context &context, double &alpha, int &nx, int &ny, int &nz) const ;
   %clear double & alpha;
   %clear int & nx;
   %clear int & ny;
   %clear int & nz;
   %apply double & OUTPUT { double & alpha };
   %apply int & OUTPUT { int & nx };
   %apply int & OUTPUT { int & ny };
   %apply int & OUTPUT { int & nz };
   void getDPMEParametersInContext(const Context &context, double &alpha, int &nx, int &ny, int &nz) const ;
   %clear double & alpha;
   %clear int & nx;
   %clear int & ny;
   %clear int & nz;
   int addParticle(double charge, const std::vector< double > &dipole, const std::vector< double > &quadrupole, double coreCharge, double alpha, double epsilon, double damping, double c6, double pauliK, double pauliQ, double pauliAlpha, double polarizability, int axisType, int multipoleAtomZ, int multipoleAtomX, int multipoleAtomY) ;
   %apply double & OUTPUT { double & charge };
   %apply std::vector< double > & OUTPUT { std::vector< double > & dipole };
   %apply std::vector< double > & OUTPUT { std::vector< double > & quadrupole };
   %apply double & OUTPUT { double & coreCharge };
   %apply double & OUTPUT { double & alpha };
   %apply double & OUTPUT { double & epsilon };
   %apply double & OUTPUT { double & damping };
   %apply double & OUTPUT { double & c6 };
   %apply double & OUTPUT { double & pauliK };
   %apply double & OUTPUT { double & pauliQ };
   %apply double & OUTPUT { double & pauliAlpha };
   %apply double & OUTPUT { double & polarizability };
   %apply int & OUTPUT { int & axisType };
   %apply int & OUTPUT { int & multipoleAtomZ };
   %apply int & OUTPUT { int & multipoleAtomX };
   %apply int & OUTPUT { int & multipoleAtomY };
   void getParticleParameters(int index, double &charge, std::vector< double > &dipole, std::vector< double > &quadrupole, double &coreCharge, double &alpha, double &epsilon, double &damping, double &c6, double &pauliK, double &pauliQ, double &pauliAlpha, double &polarizability, int &axisType, int &multipoleAtomZ, int &multipoleAtomX, int &multipoleAtomY) const ;
   %clear double & charge;
   %clear std::vector< double > & dipole;
   %clear std::vector< double > & quadrupole;
   %clear double & coreCharge;
   %clear double & alpha;
   %clear double & epsilon;
   %clear double & damping;
   %clear double & c6;
   %clear double & pauliK;
   %clear double & pauliQ;
   %clear double & pauliAlpha;
   %clear double & polarizability;
   %clear int & axisType;
   %clear int & multipoleAtomZ;
   %clear int & multipoleAtomX;
   %clear int & multipoleAtomY;
   void setParticleParameters(int index, double charge, const std::vector< double > &dipole, const std::vector< double > &quadrupole, double coreCharge, double alpha, double epsilon, double damping, double c6, double pauliK, double pauliQ, double pauliAlpha, double polarizability, int axisType, int multipoleAtomZ, int multipoleAtomX, int multipoleAtomY) ;
   int addException(int particle1, int particle2, double multipoleMultipoleScale, double dipoleMultipoleScale, double dipoleDipoleScale, double dispersionScale, double repulsionScale, double chargeTransferScale, bool replace=false) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply double & OUTPUT { double & multipoleMultipoleScale };
   %apply double & OUTPUT { double & dipoleMultipoleScale };
   %apply double & OUTPUT { double & dipoleDipoleScale };
   %apply double & OUTPUT { double & dispersionScale };
   %apply double & OUTPUT { double & repulsionScale };
   %apply double & OUTPUT { double & chargeTransferScale };
   void getExceptionParameters(int index, int &particle1, int &particle2, double &multipoleMultipoleScale, double &dipoleMultipoleScale, double &dipoleDipoleScale, double &dispersionScale, double &repulsionScale, double &chargeTransferScale) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear double & multipoleMultipoleScale;
   %clear double & dipoleMultipoleScale;
   %clear double & dipoleDipoleScale;
   %clear double & dispersionScale;
   %clear double & repulsionScale;
   %clear double & chargeTransferScale;
   void setExceptionParameters(int index, int particle1, int particle2, double multipoleMultipoleScale, double dipoleMultipoleScale, double dipoleDipoleScale, double dispersionScale, double repulsionScale, double chargeTransferScale) ;
   double getEwaldErrorTolerance() const ;
   void setEwaldErrorTolerance(double tol) ;
   %apply std::vector< Vec3 > & OUTPUT { std::vector< Vec3 > & dipoles };
   void getLabFramePermanentDipoles(Context &context, std::vector< Vec3 > &dipoles) ;
   %clear std::vector< Vec3 > & dipoles;
   %apply std::vector< Vec3 > & OUTPUT { std::vector< Vec3 > & dipoles };
   void getInducedDipoles(Context &context, std::vector< Vec3 > &dipoles) ;
   %clear std::vector< Vec3 > & dipoles;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class LangevinIntegrator : public Integrator {
public:
   LangevinIntegrator(double temperature, double frictionCoeff, double stepSize) ;

   double getTemperature() const ;
   void setTemperature(double temp) ;
   double getFriction() const ;
   void setFriction(double coeff) ;
   int getRandomNumberSeed() const ;
   void setRandomNumberSeed(int seed) ;
   virtual void step(int steps) ;
};

class LangevinMiddleIntegrator : public Integrator {
public:
   LangevinMiddleIntegrator(double temperature, double frictionCoeff, double stepSize) ;

   double getTemperature() const ;
   void setTemperature(double temp) ;
   double getFriction() const ;
   void setFriction(double coeff) ;
   int getRandomNumberSeed() const ;
   void setRandomNumberSeed(int seed) ;
   virtual void step(int steps) ;
};

class VirtualSite {
public:
   virtual ~VirtualSite() ;

   int getNumParticles() const ;
   int getParticle(int particle) const ;
};

class LocalCoordinatesSite : public VirtualSite {
public:
   LocalCoordinatesSite(const std::vector< int > &particles, const std::vector< double > &originWeights, const std::vector< double > &xWeights, const std::vector< double > &yWeights, const Vec3 &localPosition) ;
   LocalCoordinatesSite(int particle1, int particle2, int particle3, const Vec3 &originWeights, const Vec3 &xWeights, const Vec3 &yWeights, const Vec3 &localPosition) ;

   %apply std::vector< double > & OUTPUT { std::vector< double > & weights };
   void getOriginWeights(std::vector< double > &weights) const ;
   %clear std::vector< double > & weights;
   %apply std::vector< double > & OUTPUT { std::vector< double > & weights };
   void getXWeights(std::vector< double > &weights) const ;
   %clear std::vector< double > & weights;
   %apply std::vector< double > & OUTPUT { std::vector< double > & weights };
   void getYWeights(std::vector< double > &weights) const ;
   %clear std::vector< double > & weights;
   const Vec3& getLocalPosition() const ;
};

class LocalEnergyMinimizer {
public:

   static void minimize(Context &context, double tolerance=10, int maxIterations=0) ;
};

class MonteCarloAnisotropicBarostat : public Force {
public:
   MonteCarloAnisotropicBarostat(const Vec3 &defaultPressure, double defaultTemperature, bool scaleX=true, bool scaleY=true, bool scaleZ=true, int frequency=25) ;

   static const std::string& PressureX() ;
   static const std::string& PressureY() ;
   static const std::string& PressureZ() ;
   static const std::string& Temperature() ;
   const Vec3& getDefaultPressure() const ;
   void setDefaultPressure(const Vec3 &pressure) ;
   bool getScaleX() const ;
   bool getScaleY() const ;
   bool getScaleZ() const ;
   int getFrequency() const ;
   void setFrequency(int freq) ;
   double getDefaultTemperature() const ;
   void setDefaultTemperature(double temp) ;
   int getRandomNumberSeed() const ;
   void setRandomNumberSeed(int seed) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class MonteCarloBarostat : public Force {
public:
   MonteCarloBarostat(double defaultPressure, double defaultTemperature, int frequency=25) ;

   static const std::string& Pressure() ;
   static const std::string& Temperature() ;
   double getDefaultPressure() const ;
   void setDefaultPressure(double pressure) ;
   int getFrequency() const ;
   void setFrequency(int freq) ;
   double getDefaultTemperature() const ;
   void setDefaultTemperature(double temp) ;
   int getRandomNumberSeed() const ;
   void setRandomNumberSeed(int seed) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class MonteCarloMembraneBarostat : public Force {
public:
   enum XYMode {
      XYIsotropic =  0,
      XYAnisotropic =  1
   };
   enum ZMode {
      ZFree =  0,
      ZFixed =  1,
      ConstantVolume =  2
   };

   MonteCarloMembraneBarostat(double defaultPressure, double defaultSurfaceTension, double defaultTemperature, XYMode xymode, ZMode zmode, int frequency=25) ;

   static const std::string& Pressure() ;
   static const std::string& SurfaceTension() ;
   static const std::string& Temperature() ;
   double getDefaultPressure() const ;
   void setDefaultPressure(double pressure) ;
   double getDefaultSurfaceTension() const ;
   void setDefaultSurfaceTension(double surfaceTension) ;
   int getFrequency() const ;
   void setFrequency(int freq) ;
   double getDefaultTemperature() const ;
   void setDefaultTemperature(double temp) ;
   XYMode getXYMode() const ;
   void setXYMode(XYMode mode) ;
   ZMode getZMode() const ;
   void setZMode(ZMode mode) ;
   int getRandomNumberSeed() const ;
   void setRandomNumberSeed(int seed) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class NonbondedForce : public Force {
public:
   enum NonbondedMethod {
      NoCutoff =  0,
      CutoffNonPeriodic =  1,
      CutoffPeriodic =  2,
      Ewald =  3,
      PME =  4,
      LJPME =  5
   };

   NonbondedForce() ;

   int getNumParticles() const ;
   int getNumExceptions() const ;
   int getNumGlobalParameters() const ;
   int getNumParticleParameterOffsets() const ;
   int getNumExceptionParameterOffsets() const ;
   NonbondedMethod getNonbondedMethod() const ;
   void setNonbondedMethod(NonbondedMethod method) ;
   double getCutoffDistance() const ;
   void setCutoffDistance(double distance) ;
   bool getUseSwitchingFunction() const ;
   void setUseSwitchingFunction(bool use) ;
   double getSwitchingDistance() const ;
   void setSwitchingDistance(double distance) ;
   double getReactionFieldDielectric() const ;
   void setReactionFieldDielectric(double dielectric) ;
   double getEwaldErrorTolerance() const ;
   void setEwaldErrorTolerance(double tol) ;
   %apply double & OUTPUT { double & alpha };
   %apply int & OUTPUT { int & nx };
   %apply int & OUTPUT { int & ny };
   %apply int & OUTPUT { int & nz };
   void getPMEParameters(double &alpha, int &nx, int &ny, int &nz) const ;
   %clear double & alpha;
   %clear int & nx;
   %clear int & ny;
   %clear int & nz;
   %apply double & OUTPUT { double & alpha };
   %apply int & OUTPUT { int & nx };
   %apply int & OUTPUT { int & ny };
   %apply int & OUTPUT { int & nz };
   void getLJPMEParameters(double &alpha, int &nx, int &ny, int &nz) const ;
   %clear double & alpha;
   %clear int & nx;
   %clear int & ny;
   %clear int & nz;
   void setPMEParameters(double alpha, int nx, int ny, int nz) ;
   void setLJPMEParameters(double alpha, int nx, int ny, int nz) ;
   %apply double & OUTPUT { double & alpha };
   %apply int & OUTPUT { int & nx };
   %apply int & OUTPUT { int & ny };
   %apply int & OUTPUT { int & nz };
   void getPMEParametersInContext(const Context &context, double &alpha, int &nx, int &ny, int &nz) const ;
   %clear double & alpha;
   %clear int & nx;
   %clear int & ny;
   %clear int & nz;
   %apply double & OUTPUT { double & alpha };
   %apply int & OUTPUT { int & nx };
   %apply int & OUTPUT { int & ny };
   %apply int & OUTPUT { int & nz };
   void getLJPMEParametersInContext(const Context &context, double &alpha, int &nx, int &ny, int &nz) const ;
   %clear double & alpha;
   %clear int & nx;
   %clear int & ny;
   %clear int & nz;
   int addParticle(double charge, double sigma, double epsilon) ;
   %apply double & OUTPUT { double & charge };
   %apply double & OUTPUT { double & sigma };
   %apply double & OUTPUT { double & epsilon };
   void getParticleParameters(int index, double &charge, double &sigma, double &epsilon) const ;
   %clear double & charge;
   %clear double & sigma;
   %clear double & epsilon;
   void setParticleParameters(int index, double charge, double sigma, double epsilon) ;
   int addException(int particle1, int particle2, double chargeProd, double sigma, double epsilon, bool replace=false) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply double & OUTPUT { double & chargeProd };
   %apply double & OUTPUT { double & sigma };
   %apply double & OUTPUT { double & epsilon };
   void getExceptionParameters(int index, int &particle1, int &particle2, double &chargeProd, double &sigma, double &epsilon) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear double & chargeProd;
   %clear double & sigma;
   %clear double & epsilon;
   void setExceptionParameters(int index, int particle1, int particle2, double chargeProd, double sigma, double epsilon) ;
   void createExceptionsFromBonds(const std::vector< std::pair< int, int > > &bonds, double coulomb14Scale, double lj14Scale) ;
   int addGlobalParameter(const std::string &name, double defaultValue) ;
   const std::string& getGlobalParameterName(int index) const ;
   void setGlobalParameterName(int index, const std::string &name) ;
   double getGlobalParameterDefaultValue(int index) const ;
   void setGlobalParameterDefaultValue(int index, double defaultValue) ;
   int addParticleParameterOffset(const std::string &parameter, int particleIndex, double chargeScale, double sigmaScale, double epsilonScale) ;
   %apply std::string & OUTPUT { std::string & parameter };
   %apply int & OUTPUT { int & particleIndex };
   %apply double & OUTPUT { double & chargeScale };
   %apply double & OUTPUT { double & sigmaScale };
   %apply double & OUTPUT { double & epsilonScale };
   void getParticleParameterOffset(int index, std::string &parameter, int &particleIndex, double &chargeScale, double &sigmaScale, double &epsilonScale) const ;
   %clear std::string & parameter;
   %clear int & particleIndex;
   %clear double & chargeScale;
   %clear double & sigmaScale;
   %clear double & epsilonScale;
   void setParticleParameterOffset(int index, const std::string &parameter, int particleIndex, double chargeScale, double sigmaScale, double epsilonScale) ;
   int addExceptionParameterOffset(const std::string &parameter, int exceptionIndex, double chargeProdScale, double sigmaScale, double epsilonScale) ;
   %apply std::string & OUTPUT { std::string & parameter };
   %apply int & OUTPUT { int & exceptionIndex };
   %apply double & OUTPUT { double & chargeProdScale };
   %apply double & OUTPUT { double & sigmaScale };
   %apply double & OUTPUT { double & epsilonScale };
   void getExceptionParameterOffset(int index, std::string &parameter, int &exceptionIndex, double &chargeProdScale, double &sigmaScale, double &epsilonScale) const ;
   %clear std::string & parameter;
   %clear int & exceptionIndex;
   %clear double & chargeProdScale;
   %clear double & sigmaScale;
   %clear double & epsilonScale;
   void setExceptionParameterOffset(int index, const std::string &parameter, int exceptionIndex, double chargeProdScale, double sigmaScale, double epsilonScale) ;
   bool getUseDispersionCorrection() const ;
   void setUseDispersionCorrection(bool useCorrection) ;
   int getReciprocalSpaceForceGroup() const ;
   void setReciprocalSpaceForceGroup(int group) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
   bool getExceptionsUsePeriodicBoundaryConditions() const ;
   void setExceptionsUsePeriodicBoundaryConditions(bool periodic) ;
};

class NoseHooverChain {
public:
   NoseHooverChain(double temperature, double relativeTemperature, double collisionFrequency, double relativeCollisionFrequency, int numDOFs, int chainLength, int numMTS, int numYoshidaSuzuki, int chainID, const std::vector< int > &thermostatedAtoms, const std::vector< std::pair< int, int > > &thermostatedPairs) ;

   double getTemperature() const ;
   void setTemperature(double temperature) ;
   double getRelativeTemperature() const ;
   void setRelativeTemperature(double temperature) ;
   double getCollisionFrequency() const ;
   void setCollisionFrequency(double frequency) ;
   double getRelativeCollisionFrequency() const ;
   void setRelativeCollisionFrequency(double frequency) ;
   int getNumDegreesOfFreedom() const ;
   void setNumDegreesOfFreedom(int numDOF) ;
   int getChainLength() const ;
   int getNumMultiTimeSteps() const ;
   int getNumYoshidaSuzukiTimeSteps() const ;
   int getChainID() const ;
   const std::vector<int>& getThermostatedAtoms() const ;
   void setThermostatedAtoms(const std::vector< int > &atomIDs) ;
   const std::vector< std::pair< int, int > >& getThermostatedPairs() const ;
   void setThermostatedPairs(const std::vector< std::pair< int, int > > &pairIDs) ;
   std::vector<double> getYoshidaSuzukiWeights() const ;
   bool usesPeriodicBoundaryConditions() const ;
};

class OutOfPlaneSite : public VirtualSite {
public:
   OutOfPlaneSite(int particle1, int particle2, int particle3, double weight12, double weight13, double weightCross) ;

   double getWeight12() const ;
   double getWeight13() const ;
   double getWeightCross() const ;
};

class PeriodicTorsionForce : public Force {
public:
   PeriodicTorsionForce() ;

   int getNumTorsions() const ;
   int addTorsion(int particle1, int particle2, int particle3, int particle4, int periodicity, double phase, double k) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply int & OUTPUT { int & particle3 };
   %apply int & OUTPUT { int & particle4 };
   %apply int & OUTPUT { int & periodicity };
   %apply double & OUTPUT { double & phase };
   %apply double & OUTPUT { double & k };
   void getTorsionParameters(int index, int &particle1, int &particle2, int &particle3, int &particle4, int &periodicity, double &phase, double &k) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear int & particle3;
   %clear int & particle4;
   %clear int & periodicity;
   %clear double & phase;
   %clear double & k;
   void setTorsionParameters(int index, int particle1, int particle2, int particle3, int particle4, int periodicity, double phase, double k) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class Platform {
public:
   virtual ~Platform() ;

   static void registerPlatform(Platform *platform) ;
   static int getNumPlatforms() ;
   static Platform& getPlatform(int index) ;
   static std::vector<std::string> getPluginLoadFailures() ;
   static Platform& getPlatformByName(const std::string &name) ;
   static Platform& findPlatform(const std::vector< std::string > &kernelNames) ;
   static void loadPluginLibrary(const std::string &file) ;
   static std::vector<std::string> loadPluginsFromDirectory(const std::string &directory) ;
   static const std::string& getDefaultPluginsDirectory() ;
   static const std::string& getOpenMMVersion() ;
   virtual const std::string& getName() const =0 ;
   virtual double getSpeed() const =0 ;
   virtual bool supportsDoublePrecision() const =0 ;
   const std::vector<std::string>& getPropertyNames() const ;
   virtual const std::string& getPropertyValue(const Context &context, const std::string &property) const ;
   virtual void setPropertyValue(Context &context, const std::string &property, const std::string &value) const ;
   const std::string& getPropertyDefaultValue(const std::string &property) const ;
   void setPropertyDefaultValue(const std::string &property, const std::string &value) ;
   %apply ContextImpl & OUTPUT { ContextImpl & context };
   %apply ContextImpl & OUTPUT { ContextImpl & originalContext };
   virtual void linkedContextCreated(ContextImpl &context, ContextImpl &originalContext) const ;
   %clear ContextImpl & context;
   %clear ContextImpl & originalContext;
   bool supportsKernels(const std::vector< std::string > &kernelNames) const ;
};

class RBTorsionForce : public Force {
public:
   RBTorsionForce() ;

   int getNumTorsions() const ;
   int addTorsion(int particle1, int particle2, int particle3, int particle4, double c0, double c1, double c2, double c3, double c4, double c5) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply int & OUTPUT { int & particle3 };
   %apply int & OUTPUT { int & particle4 };
   %apply double & OUTPUT { double & c0 };
   %apply double & OUTPUT { double & c1 };
   %apply double & OUTPUT { double & c2 };
   %apply double & OUTPUT { double & c3 };
   %apply double & OUTPUT { double & c4 };
   %apply double & OUTPUT { double & c5 };
   void getTorsionParameters(int index, int &particle1, int &particle2, int &particle3, int &particle4, double &c0, double &c1, double &c2, double &c3, double &c4, double &c5) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear int & particle3;
   %clear int & particle4;
   %clear double & c0;
   %clear double & c1;
   %clear double & c2;
   %clear double & c3;
   %clear double & c4;
   %clear double & c5;
   void setTorsionParameters(int index, int particle1, int particle2, int particle3, int particle4, double c0, double c1, double c2, double c3, double c4, double c5) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   void setUsesPeriodicBoundaryConditions(bool periodic) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class RMSDForce : public Force {
public:
   RMSDForce(const std::vector< Vec3 > &referencePositions, const std::vector< int > &particles=std::vector< int >()) ;

   const std::vector<Vec3>& getReferencePositions() const ;
   void setReferencePositions(const std::vector< Vec3 > &positions) ;
   const std::vector<int>& getParticles() const ;
   void setParticles(const std::vector< int > &particles) ;
   %apply Context & OUTPUT { Context & context };
   void updateParametersInContext(Context &context) ;
   %clear Context & context;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class RPMDIntegrator : public Integrator {
public:
   RPMDIntegrator(int numCopies, double temperature, double frictionCoeff, double stepSize) ;
   RPMDIntegrator(int numCopies, double temperature, double frictionCoeff, double stepSize, const std::map< int, int > &contractions) ;

   int getNumCopies() const ;
   double getTemperature() const ;
   void setTemperature(double temp) ;
   double getFriction() const ;
   void setFriction(double coeff) ;
   bool getApplyThermostat() const ;
   void setApplyThermostat(bool apply) ;
   int getRandomNumberSeed() const ;
   void setRandomNumberSeed(int seed) ;
   const std::map<int, int>& getContractions() const ;
   void setPositions(int copy, const std::vector< Vec3 > &positions) ;
   void setVelocities(int copy, const std::vector< Vec3 > &velocities) ;
   State getState(int copy, int types, bool enforcePeriodicBox=false, int groups=0xFFFFFFFF) ;
   double getTotalEnergy() ;
   virtual void step(int steps) ;
};

class RPMDMonteCarloBarostat : public Force {
public:
   RPMDMonteCarloBarostat(double defaultPressure, int frequency=25) ;

   static const std::string& Pressure() ;
   double getDefaultPressure() const ;
   void setDefaultPressure(double pressure) ;
   int getFrequency() const ;
   void setFrequency(int freq) ;
   int getRandomNumberSeed() const ;
   void setRandomNumberSeed(int seed) ;
   virtual bool usesPeriodicBoundaryConditions() const ;
};

class SerializationNode {
public:

   const std::string& getName() const ;
   void setName(const std::string &name) ;
   const std::vector<SerializationNode>& getChildren() const ;
   std::vector<SerializationNode>& getChildren() ;
   const SerializationNode& getChildNode(const std::string &name) const ;
   SerializationNode& getChildNode(const std::string &name) ;
   const std::map<std::string, std::string>& getProperties() const ;
   bool hasProperty(const std::string &name) const ;
   const std::string& getStringProperty(const std::string &name) const ;
   const std::string& getStringProperty(const std::string &name, const std::string &defaultValue) const ;
   SerializationNode& setStringProperty(const std::string &name, const std::string &value) ;
   int getIntProperty(const std::string &name) const ;
   int getIntProperty(const std::string &name, int defaultValue) const ;
   SerializationNode& setIntProperty(const std::string &name, int value) ;
   bool getBoolProperty(const std::string &name) const ;
   bool getBoolProperty(const std::string &name, bool defaultValue) const ;
   SerializationNode& setBoolProperty(const std::string &name, bool value) ;
   double getDoubleProperty(const std::string &name) const ;
   double getDoubleProperty(const std::string &name, double defaultValue) const ;
   SerializationNode& setDoubleProperty(const std::string &name, double value) ;
   SerializationNode& createChildNode(const std::string &name) ;
   template<class T > SerializationNode& createChildNode(const std::string &name, const T *object) ;
   template<class T > T* decodeObject() const ;
};

class SerializationProxy {
public:
   SerializationProxy(const std::string &typeName) ;
   virtual ~SerializationProxy() ;

   static void registerProxy(const std::type_info &type, const SerializationProxy *proxy) ;
   static const SerializationProxy& getProxy(const std::string &typeName) ;
   static const SerializationProxy& getProxy(const std::type_info &type) ;
   const std::string& getTypeName() const ;
   %apply SerializationNode & OUTPUT { SerializationNode & node };
   virtual void serialize(const void *object, SerializationNode &node) const =0 ;
   %clear SerializationNode & node;
   virtual void* deserialize(const SerializationNode &node) const =0 ;
};

class State {
public:
   enum DataType {
      Positions = 1,
      Velocities = 2,
      Forces = 4,
      Energy = 8,
      Parameters = 16,
      ParameterDerivatives = 32,
      IntegratorParameters = 64
   };

   State() ;

   double getTime() const ;
   double getKineticEnergy() const ;
   double getPotentialEnergy() const ;
   %apply Vec3 & OUTPUT { Vec3 & a };
   %apply Vec3 & OUTPUT { Vec3 & b };
   %apply Vec3 & OUTPUT { Vec3 & c };
   void getPeriodicBoxVectors(Vec3 &a, Vec3 &b, Vec3 &c) const ;
   %clear Vec3 & a;
   %clear Vec3 & b;
   %clear Vec3 & c;
   double getPeriodicBoxVolume() const ;
   const std::map<std::string, double>& getParameters() const ;
   const std::map<std::string, double>& getEnergyParameterDerivatives() const ;
   int getDataTypes() const ;
};

class System {
public:
   System() ;
   ~System() ;

   int getNumParticles() const ;
   int addParticle(double mass) ;
   double getParticleMass(int index) const ;
   void setParticleMass(int index, double mass) ;
   void setVirtualSite(int index, VirtualSite *virtualSite) ;
   bool isVirtualSite(int index) const ;
   const VirtualSite& getVirtualSite(int index) const ;
   int getNumConstraints() const ;
   int addConstraint(int particle1, int particle2, double distance) ;
   %apply int & OUTPUT { int & particle1 };
   %apply int & OUTPUT { int & particle2 };
   %apply double & OUTPUT { double & distance };
   void getConstraintParameters(int index, int &particle1, int &particle2, double &distance) const ;
   %clear int & particle1;
   %clear int & particle2;
   %clear double & distance;
   void setConstraintParameters(int index, int particle1, int particle2, double distance) ;
   void removeConstraint(int index) ;
   int addForce(Force *force) ;
   int getNumForces() const ;
   const Force& getForce(int index) const ;
   Force& getForce(int index) ;
   void removeForce(int index) ;
   %apply Vec3 & OUTPUT { Vec3 & a };
   %apply Vec3 & OUTPUT { Vec3 & b };
   %apply Vec3 & OUTPUT { Vec3 & c };
   void getDefaultPeriodicBoxVectors(Vec3 &a, Vec3 &b, Vec3 &c) const ;
   %clear Vec3 & a;
   %clear Vec3 & b;
   %clear Vec3 & c;
   void setDefaultPeriodicBoxVectors(const Vec3 &a, const Vec3 &b, const Vec3 &c) ;
   bool usesPeriodicBoundaryConditions() const ;
};

class ThreeParticleAverageSite : public VirtualSite {
public:
   ThreeParticleAverageSite(int particle1, int particle2, int particle3, double weight1, double weight2, double weight3) ;

   double getWeight(int particle) const ;
};

class TwoParticleAverageSite : public VirtualSite {
public:
   TwoParticleAverageSite(int particle1, int particle2, double weight1, double weight2) ;

   double getWeight(int particle) const ;
};

class VariableLangevinIntegrator : public Integrator {
public:
   VariableLangevinIntegrator(double temperature, double frictionCoeff, double errorTol) ;

   double getTemperature() const ;
   void setTemperature(double temp) ;
   double getFriction() const ;
   void setFriction(double coeff) ;
   double getErrorTolerance() const ;
   void setErrorTolerance(double tol) ;
   double getMaximumStepSize() const ;
   void setMaximumStepSize(double size) ;
   int getRandomNumberSeed() const ;
   void setRandomNumberSeed(int seed) ;
   virtual void step(int steps) ;
   void stepTo(double time) ;
};

class VariableVerletIntegrator : public Integrator {
public:
   VariableVerletIntegrator(double errorTol) ;

   double getErrorTolerance() const ;
   void setErrorTolerance(double tol) ;
   double getMaximumStepSize() const ;
   void setMaximumStepSize(double size) ;
   virtual void step(int steps) ;
   void stepTo(double time) ;
};

class VerletIntegrator : public Integrator {
public:
   VerletIntegrator(double stepSize) ;

   virtual void step(int steps) ;
};

class XmlSerializer {
public:

   template<class T > static T* clone(const T &object) ;
};



} // namespace OpenMM

