



if not exist %LIBRARY_LIB%/OpenMM.lib exit 1
IF %ERRORLEVEL% NEQ 0 exit /B 1
if not exist %LIBRARY_LIB%/plugins/OpenMMCPU.lib exit 1
IF %ERRORLEVEL% NEQ 0 exit /B 1
if not exist %LIBRARY_LIB%/plugins/OpenMMPME.lib exit 1
IF %ERRORLEVEL% NEQ 0 exit /B 1
if not exist %LIBRARY_LIB%/plugins/OpenMMOpenCL.lib exit 1
IF %ERRORLEVEL% NEQ 0 exit /B 1
if not exist %LIBRARY_LIB%/plugins/OpenMMCUDA.lib exit 1
IF %ERRORLEVEL% NEQ 0 exit /B 1
if not exist %LIBRARY_LIB%/plugins/OpenMMCudaCompiler.lib exit 1
IF %ERRORLEVEL% NEQ 0 exit /B 1
python -c "import simtk.openmm as mm; print('---Loaded---', *mm.pluginLoadedLibNames, '---Failed---', *mm.Platform.getPluginLoadFailures(), sep='\n')"
IF %ERRORLEVEL% NEQ 0 exit /B 1
python -c "import os, simtk.openmm.version as v; print(v.openmm_library_path); assert os.path.isdir(v.openmm_library_path), 'Directory does not exist'"
IF %ERRORLEVEL% NEQ 0 exit /B 1
python -m simtk.testInstallation
IF %ERRORLEVEL% NEQ 0 exit /B 1
python -c "from simtk.openmm import Platform as P; n = P.getNumPlatforms(); assert n == 2, f'n_platforms ({n}) != 2'"
IF %ERRORLEVEL% NEQ 0 exit /B 1
cd %LIBRARY_PREFIX%/share/openmm/examples
IF %ERRORLEVEL% NEQ 0 exit /B 1
python benchmark.py --test=rf --seconds=10 --platform=Reference
IF %ERRORLEVEL% NEQ 0 exit /B 1
python benchmark.py --test=rf --seconds=10 --platform=CPU
IF %ERRORLEVEL% NEQ 0 exit /B 1
python -c "from simtk.openmm import Platform; v = Platform.getOpenMMVersion(); assert '7.5.0' in (v, v+'.0'), v + '!=7.5.0'"
IF %ERRORLEVEL% NEQ 0 exit /B 1
python -c "from simtk.openmm.version import git_revision; r = git_revision; assert r == 'b49b82efb5a253a7c891ca084b3370e181de2ea3', r + '!=b49b82efb5a253a7c891ca084b3370e181de2ea3'"
IF %ERRORLEVEL% NEQ 0 exit /B 1
exit /B 0
