/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.sysinfo;

import com.azul.crs.client.sysinfo.SystemInfoProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;

final class MacOSXSystemInfoProvider
extends SystemInfoProvider.SystemInfoProviderImpl {
    MacOSXSystemInfoProvider() {
    }

    @Override
    protected void initProps() throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder("sysctl", "-a");
        Process process = processBuilder.start();
        Object object = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Serializable serializable = null;
        try {
            String string;
            while ((string = ((BufferedReader)object).readLine()) != null) {
                int n = string.indexOf(58);
                if (n < 0) continue;
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(n + 1).trim();
                this.machdepProps.set("sysctl." + string2, string3);
            }
        }
        catch (Throwable throwable) {
            serializable = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (serializable != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)serializable).addSuppressed(throwable);
                    }
                } else {
                    ((BufferedReader)object).close();
                }
            }
        }
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.MODEL_NAME, this.machdepProps.strValue("sysctl.machdep.cpu.brand_string"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.VENDOR, this.machdepProps.strValue("sysctl.machdep.cpu.vendor"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.FAMILY, this.machdepProps.intValue("sysctl.machdep.cpu.family"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.MODEL, this.machdepProps.intValue("sysctl.machdep.cpu.model"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.STEPPING, this.machdepProps.intValue("sysctl.machdep.cpu.stepping"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.MICROCODE, this.machdepProps.longValue("sysctl.machdep.cpu.microcode_version"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PACKAGE_COUNT, this.machdepProps.intValue("sysctl.hw.packages"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PHYSICAL_CORE_COUNT, this.machdepProps.intValue("sysctl.hw.physicalcpu"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.PROCESSOR_COUNT, this.machdepProps.intValue("sysctl.hw.ncpu"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.CACHE_SIZE_L1I, this.machdepProps.intValue("sysctl.hw.l1icachesize"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.CACHE_SIZE_L1D, this.machdepProps.intValue("sysctl.hw.l1dcachesize"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.CACHE_SIZE_L2, this.machdepProps.intValue("sysctl.hw.l2cachesize"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.CACHE_SIZE_L3, this.machdepProps.intValue("sysctl.hw.l3cachesize"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.FREQUENCY, this.machdepProps.longValue("sysctl.hw.cpufrequency"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.FREQUENCY_MIN, this.machdepProps.longValue("sysctl.hw.cpufrequency_min"));
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.FREQUENCY_MAX, this.machdepProps.longValue("sysctl.hw.cpufrequency_max"));
        object = this.machdepProps.strValue("sysctl.machdep.cpu.features").toLowerCase();
        this.machdepProps.set("sysctl.machdep.cpu.features", object);
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.FLAGS, object);
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append("tsc=").append(((String)object).contains(" tsc ") ? "on" : "off");
        ((StringBuilder)serializable).append(" constant_tsc=").append(((String)object).contains("constant_tsc") ? "on" : "off");
        ((StringBuilder)serializable).append(" nonstop_tsc=").append(((String)object).contains("nonstop_tsc") ? "on" : "off");
        this.cpuProps.set(SystemInfoProvider.CPUInfoKey.TSC, ((StringBuilder)serializable).toString());
        this.memProps.set(SystemInfoProvider.MemInfoKey.SYSTEM_RAM_MAX_GB, this.machdepProps.longValue("sysctl.hw.memsize") >> 30);
        this.machdepProps.filter("sysctl.hw.", "sysctl.kern.sysv.", "sysctl.kern.core.", "sysctl.kern.timer", "sysctl.kern.vm_page", "sysctl.kern.monotonicclock");
        process.waitFor();
    }
}

