/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.jar.ZipTools;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public final class JarLoadMonitor
implements ClientService {
    private static final boolean DEBUG = Boolean.getBoolean("com.azul.crs.jarload.debug");
    private static final boolean jarLoadByClassLoad = Boolean.getBoolean("com.azul.crs.jarload.jarLoadByClassLoad");
    private static final boolean sendCentralDirectoryHash = Boolean.getBoolean("com.azul.crs.jarload.sendCentralDirectoryHashOnJarLoad");
    private static final boolean sendJarEntriesHashes = JarLoadMonitor.getBooleanProperty("com.azul.crs.jarload.sendJarEntriesHashesOnJarLoad", true);
    private static final boolean sendJarEntries = JarLoadMonitor.getBooleanProperty("com.azul.crs.jarload.sendJarEntriesOnJarLoad", false);
    private static final boolean sendJarFile = Boolean.getBoolean("com.azul.crs.jarload.sendJarFileOnJarLoad");
    private static final String allowedToSendJarFiles = System.getProperty("com.azul.crs.jarload.allowedToSendJarFilesListOnJarLoad");
    private static final String sendJarEntriesList = System.getProperty("com.azul.crs.jarload.sendJarEntriesListOnJarLoad", "**/META-INF/MANIFEST.MF,**/pom.properties");
    private static final boolean recursiveJarDiscovery = JarLoadMonitor.getBooleanProperty("com.azul.crs.jarload.recursiveJarDiscoveryOnJarLoad", true);
    private static final JarLoadMonitor instance = new JarLoadMonitor();
    private Client client;
    private volatile boolean started;
    private volatile boolean stopped;
    private long _count;
    private final PrintWriter traceOut;
    private MessageDigest md;
    private Set<String> knownClassLoadSources;
    private ZipTools zt;
    private JarEntryAccess jarEntryAccess;
    private JarFileAccess jarFileAccess;
    private static final int VM_JAR_LOADED_EVENT_INLINE_PAYLOAD_THRESHOLD = 524288;

    private JarLoadMonitor() {
        try {
            this.md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.logger().error("Failed to initialize SHA-256 MessageDigest. Stop jar load monitor: %s", noSuchAlgorithmException);
            this.stop(null);
        }
        this.zt = ZipTools.createDefault();
        this.jarEntryAccess = new JarEntryAccess(sendJarEntriesList);
        this.jarFileAccess = new JarFileAccess(allowedToSendJarFiles);
        if (jarLoadByClassLoad) {
            this.knownClassLoadSources = new HashSet<String>();
        }
        PrintWriter printWriter = null;
        if (this.logger().isEnabled(Logger.Level.TRACE)) {
            try {
                Path path = Files.createTempFile("CRSJarLoadMonitor", ".log", new FileAttribute[0]);
                this.logger().trace("writing JarLoadMonitor trace to file %s", path);
                printWriter = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));
            }
            catch (IOException iOException) {
                this.logger().error("Cannot trace events into file: %s", iOException);
            }
        }
        this.traceOut = printWriter;
    }

    public static JarLoadMonitor getInstance(Client client) {
        JarLoadMonitor.instance.client = client;
        return instance;
    }

    private VMEvent jarLoadEvent(String string, InitiatedBy initiatedBy, int n, String string2, long l, String string3, String string4, String string5, Long l2, Map<String, String> map, Set<MavenComponent> set) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string);
        hashMap.put("jarName", string2);
        hashMap.put("centralDirectoryHash", string3);
        hashMap.put("manifestHash", string4);
        hashMap.put("centralDirectoryExtractionMethod", string5);
        hashMap.put("centralDirectoryLength", l2 != null ? Long.toString(l2) : null);
        hashMap.put("entries", map);
        hashMap.put("initiatedBy", (Object)initiatedBy);
        hashMap.put("recursionDepth", n);
        hashMap.put("mavenComponents", set);
        return new VMEvent().randomEventId().eventType(VMEvent.Type.VM_JAR_LOADED).eventTime(l).eventPayload(hashMap);
    }

    @Override
    public synchronized void start() {
        this.started = true;
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
        this.logger().debug("total jars loaded count " + this._count, new Object[0]);
        PerformanceMetrics.logClassLoads(this._count);
        if (this.traceOut != null) {
            this.traceOut.close();
        }
        this.started = false;
        this.stopped = true;
    }

    public static URL getJarURL(URL uRL) {
        String string = uRL.toString();
        if (string.contains("!/") && !(string = string.substring(0, string.lastIndexOf("!/"))).contains("!/") && string.startsWith("jar:")) {
            string = string.substring(4);
        }
        if (!(string.endsWith(".jar!/") || string.endsWith(".war!/") || string.endsWith(".jar") || string.endsWith(".war"))) {
            Logger.getLogger(JarLoadMonitor.class).debug("given url=" + uRL + " does not have jar to be reported for load event. source=" + string, new Object[0]);
            return null;
        }
        try {
            return new URL(string);
        }
        catch (Exception exception) {
            Logger.getLogger(JarLoadMonitor.class).warning("Failed to construct jar url from url=%s, modified source string=%s", uRL, string, exception);
            return uRL;
        }
    }

    private ZipTools.JarShortDigest getJarCentralDirectorySignature(URL uRL, JarFile jarFile) {
        try {
            URL uRL2 = JarLoadMonitor.getJarURL(uRL);
            if (null == uRL2) {
                return null;
            }
            ZipTools.JarShortDigest jarShortDigest = this.zt.getDigest((MessageDigest)this.md.clone(), uRL2, jarFile);
            if (jarShortDigest == null) {
                return null;
            }
            if (DEBUG) {
                System.out.println(">>> notifyJarLoad url=" + uRL + "\njar=" + jarFile + "\ncentralDirectoryHashString=" + Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash()) + "\nmanifestHashString=" + Utils.encodeToStringOrNull(jarShortDigest.getManifestHash()));
            }
            if (this.traceOut != null) {
                this.traceOut.println(uRL.toString());
            }
            return jarShortDigest;
        }
        catch (Exception exception) {
            this.logger().error("notifyJarLoad url=%s, jar=%s has been interrupted by exception (%s): %s", uRL, jarFile, jarFile != null ? jarFile.getClass().getName() : null, exception);
            return null;
        }
    }

    private void sendJar(URL uRL, JarFile jarFile) {
        if (!this.jarFileAccess.isAllowed(jarFile.getName())) {
            this.logger().debug("jar=%s file is not allowed to upload. skip", jarFile.getName());
            return;
        }
        int n = this.client.createArtifactId();
        this.logger().info("created VM artifact: " + n, new Object[0]);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", jarFile.getName());
        hashMap.put("url", uRL.toString());
        hashMap.put("tags", Inventory.instanceTags());
        try {
            uRL = JarLoadMonitor.getJarURL(uRL);
        }
        catch (Exception exception) {
            this.logger().error("failed to construct jar url by source %s: %s", uRL, exception);
            return;
        }
        if (null == uRL) {
            return;
        }
        URL uRL2 = uRL;
        this.client.postVMArtifact(VMArtifact.Type.JAR, n, hashMap, outputStream -> {
            try (InputStream inputStream = uRL2.openConnection().getInputStream();){
                Utils.transfer(inputStream, outputStream);
            }
            catch (IOException iOException) {
                this.logger().error("failed to send jar file %s url %s: %s", jarFile, uRL2, iOException);
            }
        });
    }

    private void visitJarEntries(JarFile jarFile, List<Consumer<JarEntry>> list) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory()) continue;
            list.forEach(consumer -> consumer.accept(jarEntry));
        }
    }

    private void notifyNestedJars(String string, JarFile jarFile, int n) {
        for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
            if (!ZipTools.isJarFile(jarEntry.getName())) continue;
            try {
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                Throwable throwable = null;
                try {
                    Path path = Files.createTempFile("jar_cache", ".jar", new FileAttribute[0]);
                    try {
                        Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                        path.toFile().deleteOnExit();
                        URL uRL = new URL("jar:file:" + path + "!/");
                        String string2 = string + "!/" + jarEntry.getName();
                        JarFile jarFile2 = new JarFile(path.toFile());
                        this.notifyJarLoad(uRL, jarFile2, InitiatedBy.RECURSIVE_LOADING, string2, n);
                    }
                    catch (Throwable throwable2) {
                        try {
                            Files.delete(path);
                        }
                        catch (IOException iOException) {
                            throwable2.addSuppressed(iOException);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                this.logger().error("failed to dump nested jar entry %s/%s: %s", jarFile.getName(), jarEntry.getName(), exception);
            }
        }
    }

    public void notifyJarLoad(URL uRL, JarFile jarFile, InitiatedBy initiatedBy, String string, int n) {
        if (this.stopped) {
            return;
        }
        if (!this.started) {
            this.logger().error("service is not yet started", new Object[0]);
        }
        if (uRL == null) {
            return;
        }
        if (jarFile == null) {
            return;
        }
        ++this._count;
        try {
            this.postVMJarLoadedEvent(uRL, jarFile, string, initiatedBy, n);
            if (sendJarFile) {
                this.sendJar(uRL, jarFile);
            }
            if (sendJarEntries) {
                jarFile.stream().filter(jarEntry -> this.jarEntryAccess.isAllowed(jarEntry.getName())).forEach(jarEntry -> this.uploadJarEntry(uRL, jarFile, jarEntry.getName()));
            }
            if (recursiveJarDiscovery) {
                this.notifyNestedJars(string, jarFile, n + 1);
            }
        }
        catch (Exception exception) {
            System.out.println("!!! unexpected exception: " + exception);
            exception.printStackTrace(System.out);
        }
    }

    public void postVMJarLoadedEvent(URL uRL, JarFile jarFile, String string, InitiatedBy initiatedBy, int n) {
        boolean bl;
        ZipTools.JarShortDigest jarShortDigest = sendCentralDirectoryHash ? this.getJarCentralDirectorySignature(uRL, jarFile) : null;
        ArrayList<Consumer<JarEntry>> arrayList = new ArrayList<Consumer<JarEntry>>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashSet<MavenComponent> hashSet = new HashSet<MavenComponent>();
        if (sendJarEntriesHashes) {
            arrayList.add(jarEntry -> hashMap.put(jarEntry.getName(), String.format("%08x:%d", jarEntry.getCrc(), jarEntry.getSize())));
        }
        arrayList.add(jarEntry -> {
            if (jarEntry.getName().endsWith("/pom.properties")) {
                try (InputStream inputStream = jarFile.getInputStream((ZipEntry)jarEntry);){
                    MavenComponent mavenComponent = new MavenComponent();
                    mavenComponent.load(inputStream);
                    hashSet.add(mavenComponent);
                }
                catch (IOException iOException) {
                    this.logger().warning("Failed to read %s: %s", jarEntry.getName(), iOException.toString());
                }
            }
        });
        this.visitJarEntries(jarFile, arrayList);
        if (jarShortDigest == null && hashMap.isEmpty()) {
            return;
        }
        String string2 = jarShortDigest == null ? null : Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash());
        String string3 = jarShortDigest == null ? null : Utils.encodeToStringOrNull(jarShortDigest.getManifestHash());
        String string4 = jarShortDigest == null ? null : jarShortDigest.getProvider();
        Long l = jarShortDigest == null ? null : Long.valueOf(jarShortDigest.getCentralDirectoryLength());
        long l2 = Utils.currentTimeMillis();
        VMEvent vMEvent = this.jarLoadEvent(string, initiatedBy, n, jarFile.getName(), l2, string2, string3, string4, l, hashMap, hashSet);
        boolean bl2 = bl = l != null && l > 524288L;
        if (!bl) {
            this.client.postVMEvent(vMEvent);
            return;
        }
        int n2 = this.client.createArtifactId();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("eventId", vMEvent.getEventId());
        hashMap2.put("tags", Inventory.instanceTags());
        this.client.postVMArtifact(VMArtifact.Type.LARGE_VM_EVENT, n2, hashMap2, outputStream -> {
            try {
                PrintStream printStream = new PrintStream(outputStream);
                Utils.serializer.serialize(printStream, (Object)vMEvent);
                Map map = (Map)vMEvent.getEventPayload();
                map.remove("entries");
                map.put("STORED_VM_JAR_LOADED_EVENT", Client.artifactIdToString(n2));
                this.client.postVMEvent(vMEvent);
            }
            catch (IOException iOException) {
                this.logger().error("failed to upload STORED_VM_JAR_LOADED_EVENT %s", vMEvent.getEventId(), iOException);
            }
        });
    }

    public void notifyJarLoad(URL uRL, JarFile jarFile) {
        InitiatedBy initiatedBy = ZipTools.isJDKNative(jarFile) ? InitiatedBy.JDK_NATIVE_LOADING : InitiatedBy.OTHER;
        this.notifyJarLoad(uRL, jarFile, initiatedBy, uRL.toString(), 0);
    }

    private void uploadJarEntry(URL uRL, JarFile jarFile, String string) {
        Object object;
        if (uRL == null) {
            return;
        }
        if (jarFile == null) {
            try {
                object = JarLoadMonitor.getJarURL(uRL);
                URLConnection uRLConnection = ((URL)object).openConnection();
                if (!(uRLConnection instanceof JarURLConnection)) {
                    this.logger().warning("failed to get jar file by url %s", uRL);
                    return;
                }
                jarFile = ((JarURLConnection)uRLConnection).getJarFile();
            }
            catch (Exception exception) {
                this.logger().warning("failed to construct jar url by source %s", uRL, exception);
                return;
            }
        }
        if (!this.jarEntryAccess.isAllowed(string)) {
            this.logger().error("it is not allowed to send jar=%s entry=%s url=%s list=%s", jarFile.getName(), string, uRL, sendJarEntriesList);
            return;
        }
        object = jarFile.getJarEntry(string);
        if (object == null) {
            this.logger().info("jar entry=%s is not present in jar=%s url=%s", string, jarFile.getName(), uRL);
            return;
        }
        int n = this.client.createArtifactId();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("jar", jarFile.getName());
        hashMap.put("url", uRL.toString());
        hashMap.put("entry", string);
        hashMap.put("tags", Inventory.instanceTags());
        this.logger().info("send jar=%s entry=%s url=%s artifactId=%d", jarFile.getName(), string, uRL, n);
        JarFile jarFile2 = jarFile;
        this.client.postVMArtifact(VMArtifact.Type.JAR_ENTRY, n, hashMap, arg_0 -> this.lambda$uploadJarEntry$7(jarFile2, (JarEntry)object, string, uRL, arg_0));
    }

    public void notifyClassSourceSeen(String string) {
        block11: {
            try {
                if (string == null) {
                    return;
                }
                if (!jarLoadByClassLoad) {
                    return;
                }
                if ("__JVM_DefineClass__".equals(string)) {
                    return;
                }
                if (this.knownClassLoadSources.contains(string)) {
                    return;
                }
                this.knownClassLoadSources.add(string);
                try {
                    if (string.matches("^file:.*\\.jar$")) {
                        string = "jar:" + string + "!/";
                    }
                    if (!string.endsWith(".jar!/")) {
                        return;
                    }
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    if (uRLConnection instanceof JarURLConnection) {
                        JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
                        JarFile jarFile = jarURLConnection.getJarFile();
                        this.notifyJarLoad(uRL, jarFile, InitiatedBy.CLASS_LOADING, uRL.toString(), 0);
                        break block11;
                    }
                    this.logger().debug("Cannot open JarURLConnection from given class source (%s) (URLConnection.class=%s)", string, uRLConnection.getClass().getName());
                }
                catch (Exception exception) {
                    this.logger().debug("Class source (%s) is malformed or is not applicable to extract jar file", string, exception);
                }
            }
            catch (Exception exception) {
                System.out.println("!!! unexpected exception: " + exception);
                exception.printStackTrace();
            }
        }
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        return Boolean.parseBoolean(System.getProperty(string, String.valueOf(bl)));
    }

    private /* synthetic */ void lambda$uploadJarEntry$7(JarFile jarFile, JarEntry jarEntry, String string, URL uRL, OutputStream outputStream) throws IOException {
        try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
            Utils.transfer(inputStream, outputStream);
        }
        catch (IOException iOException) {
            this.logger().error("failed to send jar=%s entry=%s url=%s: %s", jarFile.getName(), string, uRL, iOException);
        }
    }

    private static final class MavenComponent
    extends Properties {
        private MavenComponent() {
        }
    }

    public static enum InitiatedBy {
        CLASS_LOADING,
        JDK_NATIVE_LOADING,
        RECURSIVE_LOADING,
        OTHER;

    }

    private static final class JarFileAccess {
        private final Collection<Pattern> patterns = new ArrayList<Pattern>();

        JarFileAccess(String string) {
            if (string != null && string.length() > 0) {
                for (String string2 : string.split(",")) {
                    string2 = string2.replaceAll("\\*\\*", "%%%%1%%%%");
                    string2 = string2.replaceAll("\\*", "%%%%2%%%%");
                    string2 = string2.replaceAll("%%%%1%%%%", ".*");
                    string2 = string2.replaceAll("%%%%2%%%%", "[^/]*");
                    this.patterns.add(Pattern.compile(string2));
                }
            }
        }

        public boolean isAllowed(String string) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(string).matches()) continue;
                return true;
            }
            return false;
        }
    }

    private static final class JarEntryAccess {
        private static final String prefix = "**/";
        private final Collection<String> entireFileNameMatch = new ArrayList<String>();
        private final Collection<String> suffixMatch = new ArrayList<String>();

        JarEntryAccess(String string) {
            for (String string2 : string.split(",")) {
                if (string2.startsWith(prefix)) {
                    this.suffixMatch.add(string2.substring(prefix.length()));
                    continue;
                }
                this.entireFileNameMatch.add(string2);
            }
        }

        public boolean isAllowed(String string) {
            if (string == null) {
                return false;
            }
            if (this.entireFileNameMatch.contains(string)) {
                return true;
            }
            for (String string2 : this.suffixMatch) {
                int n;
                int n2 = string.length();
                if (n2 < (n = string2.length()) || !string.endsWith(string2) || n2 != n && string.charAt(n2 - n - 1) != '/') continue;
                return true;
            }
            return false;
        }
    }
}

