/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClientService;

public class HeartbeatService
implements ClientService {
    private static final long HEARTBEAT_SLEEP = 5000L;
    private static final int HEARTBEAT_LOG_COUNT = 300;
    private static final long HEARTBEAT_STOP = 60000L;
    private static HeartbeatService instance = new HeartbeatService();
    private Client client;
    private Thread thread;
    private volatile boolean running;

    private HeartbeatService() {
    }

    public static HeartbeatService getInstance(Client client) {
        HeartbeatService.instance.client = client;
        return instance;
    }

    private void run() {
        long l = 0L;
        while (this.running) {
            try {
                Thread.sleep(5000L);
                long l2 = Utils.currentTimeMillis();
                this.client.postVMEvent(new VMEvent().randomEventId().eventType(VMEvent.Type.VM_HEARTBEAT).eventTime(l2));
                if (++l % 300L != 0L) continue;
                this.logger().info("CRS client heartbeats: lastHeardTime=%s, count=%,d\n", l2, l);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                this.logger().error("Internal error or unexpected problem. CRS defunct. %s", throwable);
            }
        }
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException(this.serviceName() + " is running already");
        }
        this.thread = new Thread(this::run);
        this.thread.setDaemon(true);
        this.thread.setName("CRSHeartbeat");
        this.running = true;
        this.thread.start();
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
        if (!this.running) {
            return;
        }
        try {
            this.running = false;
            this.thread.interrupt();
            this.thread.join(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

