/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.spec.ECParameterSpec;
import java.util.Optional;

public class CurveDB {
    private static Optional<Method> lookupByName = null;
    private static Optional<Method> lookupByParam = null;
    private static Object lookupByNameLock = new Object();
    private static Object lookupByParamLock = new Object();

    private static void makeAccessible(final AccessibleObject o) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                o.setAccessible(true);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ECParameterSpec lookup(String name) {
        Object object = lookupByNameLock;
        synchronized (object) {
            if (lookupByName == null) {
                lookupByName = (Optional)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Optional<Method> run() {
                        Optional<Method> lookupByName = null;
                        try {
                            Class<?> clazz = null;
                            try {
                                clazz = Class.forName("sun.security.ec.CurveDB");
                            }
                            catch (ClassNotFoundException cnfe) {
                                clazz = Class.forName("sun.security.util.CurveDB");
                            }
                            lookupByName = Optional.ofNullable(clazz.getDeclaredMethod("lookup", String.class));
                            CurveDB.makeAccessible(lookupByName.get());
                            return lookupByName;
                        }
                        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                            lookupByName = Optional.empty();
                            return lookupByName;
                        }
                    }
                });
            }
        }
        if (lookupByName.isPresent()) {
            try {
                return (ECParameterSpec)lookupByName.get().invoke(null, name);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ECParameterSpec lookup(ECParameterSpec params) {
        Object object = lookupByParamLock;
        synchronized (object) {
            if (lookupByParam == null) {
                lookupByParam = (Optional)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Optional<Method> run() {
                        Optional<Method> lookupByParam = null;
                        try {
                            Class<?> clazz = null;
                            try {
                                clazz = Class.forName("sun.security.ec.CurveDB");
                            }
                            catch (ClassNotFoundException cnfe) {
                                clazz = Class.forName("sun.security.util.CurveDB");
                            }
                            lookupByParam = Optional.ofNullable(clazz.getDeclaredMethod("lookup", ECParameterSpec.class));
                            CurveDB.makeAccessible(lookupByParam.get());
                        }
                        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                            lookupByParam = Optional.empty();
                        }
                        return lookupByParam;
                    }
                });
            }
        }
        if (lookupByParam.isPresent()) {
            try {
                return (ECParameterSpec)lookupByParam.get().invoke(null, params);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }
}

