/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.interpreter.BytecodeWithKlass;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeCheckCast
extends BytecodeWithKlass {
    BytecodeCheckCast(Method method, int bci) {
        super(method, bci);
    }

    public InstanceKlass getCheckCastKlass() {
        return (InstanceKlass)this.getKlass();
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check checkcast");
        }
    }

    public boolean isValid() {
        return this.javaCode() == 192;
    }

    public static BytecodeCheckCast at(Method method, int bci) {
        BytecodeCheckCast b = new BytecodeCheckCast(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeCheckCast atCheck(Method method, int bci) {
        BytecodeCheckCast b = new BytecodeCheckCast(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeCheckCast at(BytecodeStream bcs) {
        return new BytecodeCheckCast(bcs.method(), bcs.bci());
    }
}

