/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.util.logging;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Logger {
    private static final String REGISTRY = "META-INF/crslog.channels.cfg";
    private static final Map<String, Logger> TAG_TO_LOGGER = new HashMap<String, Logger>();
    private static final Map<String, String> CLASS_TO_TAG = new HashMap<String, String>();
    private static boolean registryLoaded = false;
    private static final List<PrintWriter> writers = new CopyOnWriteArrayList<PrintWriter>();
    private static Level globalLevel = Level.ERROR;
    private static boolean globalShowStacktrace = false;
    private static boolean globalShowTimestamp = false;
    private static DateFormat timestampFormat;
    private final String tag;
    private final Level lowestUpstreamLevel;
    private Level level = null;
    private Boolean showStacktrace = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void readRegistry() {
        if (registryLoaded) {
            return;
        }
        try {
            HashSet<URL> urls = new HashSet<URL>();
            ClassLoader classLoader = Logger.class.getClassLoader();
            if (classLoader != null) {
                urls.addAll(Collections.list(classLoader.getResources(REGISTRY)));
            }
            urls.addAll(Collections.list(ClassLoader.getSystemResources(REGISTRY)));
            for (URL url : urls) {
                Properties props = new Properties();
                InputStream is = url.openStream();
                Throwable throwable = null;
                try {
                    props.load(is);
                    Enumeration<?> names = props.propertyNames();
                    while (names.hasMoreElements()) {
                        String tag;
                        String klassName = names.nextElement().toString();
                        String cfg = props.getProperty(klassName);
                        Level lowestUpstreamLevel = Level.DEBUG;
                        int delim = cfg.lastIndexOf(58);
                        if (delim > 0) {
                            tag = cfg.substring(0, delim);
                            lowestUpstreamLevel = Level.valueOf(cfg.substring(delim + 1));
                        } else {
                            tag = cfg;
                        }
                        TAG_TO_LOGGER.put(tag, new Logger(tag, lowestUpstreamLevel));
                        CLASS_TO_TAG.put(klassName, tag);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(Logger.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        finally {
            registryLoaded = true;
        }
    }

    static void reset() {
        CLASS_TO_TAG.clear();
        TAG_TO_LOGGER.clear();
        globalLevel = Level.ERROR;
        globalShowStacktrace = false;
        globalShowTimestamp = false;
        registryLoaded = false;
    }

    private Logger(String tag, Level lowestUpstreamLevel) {
        this.tag = tag;
        this.lowestUpstreamLevel = lowestUpstreamLevel;
    }

    private static Logger loggerForTag(String tag) {
        return TAG_TO_LOGGER.get(tag);
    }

    public static void addOutputStream(OutputStream handler) {
        writers.add(new PrintWriter(handler));
    }

    public static Logger getLogger(Class klass) {
        String name = klass.getCanonicalName();
        String tag = CLASS_TO_TAG.get(name);
        if (tag == null) {
            Logger.readRegistry();
            tag = CLASS_TO_TAG.get(name);
        }
        return tag == null ? null : Logger.loggerForTag(tag);
    }

    public static void parseOption(String name, String value) {
        Level level;
        Logger.readRegistry();
        boolean showStacktrace = false;
        boolean showTimestamp = false;
        while (true) {
            int len;
            if (value.endsWith("+stack")) {
                showStacktrace = true;
                len = 6;
            } else {
                if (!value.endsWith("+time")) break;
                showTimestamp = true;
                len = 5;
            }
            value = value.substring(0, value.length() - len);
        }
        try {
            level = Level.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            System.err.println("[CRS.log][error] unsupported log level '" + value + "'");
            return;
        }
        if (name.equals("log")) {
            globalLevel = level;
            globalShowStacktrace = showStacktrace;
        } else if (name.startsWith("log+")) {
            String tag = name.substring(4);
            if (!"vm".equals(tag)) {
                Logger logger = Logger.loggerForTag(tag);
                if (logger != null) {
                    logger.setLevel(level).setShowStacktrace(showStacktrace);
                } else {
                    System.err.println("[CRS.log][error] unknown CRS log channel " + name.substring(4));
                }
            }
        } else {
            System.err.println("[CRS.log][error] unknown CRS log option " + name);
            return;
        }
        if (showTimestamp && !globalShowTimestamp) {
            globalShowTimestamp = true;
            timestampFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSSZ");
        }
    }

    private boolean isLogLevelEnabled(Level level) {
        return this.getLevel().ordinal() <= level.ordinal();
    }

    private boolean isUpsreamLevelEnabled(Level level) {
        return this.lowestUpstreamLevel.ordinal() <= level.ordinal();
    }

    public boolean isEnabled(Level level) {
        if (this.getLevel().equals((Object)Level.OFF)) {
            return false;
        }
        return !writers.isEmpty() || this.isLogLevelEnabled(level);
    }

    private Logger setLevel(Level level) {
        this.level = level;
        return this;
    }

    private Logger setShowStacktrace(boolean showStacktrace) {
        this.showStacktrace = showStacktrace;
        return this;
    }

    boolean showStacktrace() {
        return this.showStacktrace == null ? globalShowStacktrace : this.showStacktrace;
    }

    boolean showTimestamp() {
        return globalShowTimestamp;
    }

    public Level getLevel() {
        return this.level == null ? globalLevel : this.level;
    }

    public void trace(String format, Object ... args) {
        this.log(Level.TRACE, format, args);
    }

    public void debug(String format, Object ... args) {
        this.log(Level.DEBUG, format, args);
    }

    public void info(String format, Object ... args) {
        this.log(Level.INFO, format, args);
    }

    public void warning(String format, Object ... args) {
        this.log(Level.WARNING, format, args);
    }

    public void error(String format, Object ... args) {
        this.log(Level.ERROR, format, args);
    }

    public void log(Level level, String format, Object ... args) {
        boolean logLevelEnabled = this.isLogLevelEnabled(level);
        boolean upstreamLevelEnabled = this.isUpsreamLevelEnabled(level);
        if (!upstreamLevelEnabled && !logLevelEnabled) {
            return;
        }
        StringBuilder prefix = new StringBuilder();
        if (this.showTimestamp()) {
            prefix.append('[').append(timestampFormat.format(new Date())).append(']');
        }
        prefix.append("[CRS.").append(this.tag).append("][").append(level.n).append("] ");
        if (this.getLevel() == Level.TRACE) {
            Throwable t = new Throwable();
            StackTraceElement e = t.getStackTrace()[2];
            prefix.append(e.getClassName()).append('.').append(e.getMethodName()).append(": ");
        }
        StringBuilder out = new StringBuilder(prefix);
        for (Object c : (StackTraceElement)String.format(format, args).toCharArray()) {
            out.append((char)c);
            if (c != 10) continue;
            out.append((CharSequence)prefix);
        }
        String str = out.toString();
        if (upstreamLevelEnabled) {
            for (PrintWriter writer : writers) {
                writer.println(str);
                writer.flush();
                for (Object arg : args) {
                    if (!(arg instanceof Throwable)) continue;
                    ((Throwable)arg).printStackTrace(writer);
                    writer.flush();
                }
            }
        }
        if (logLevelEnabled) {
            System.out.println(str);
            if (this.showStacktrace()) {
                for (Object arg : args) {
                    if (!(arg instanceof Throwable)) continue;
                    ((Throwable)arg).printStackTrace(System.out);
                }
            }
        }
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        OFF;

        private final String n = this.name().toLowerCase();
    }
}

