/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.json;

import com.azul.crs.json.JSONSerializer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DummyJSONSerializer
implements JSONSerializer {
    private boolean doFormat = Boolean.getBoolean("com.azul.crs.client.enablePrettyPrint");
    private int level = 0;
    private int tabs = 2;
    private static final String escape3Text = "\"\\/\b\f\n\r\t";
    private static final Pattern escape3Pattern = Pattern.compile("[\"\\\\/\b\f\n\r\t\u0000-\u001f]");
    private static final String[] escape3Replacement = new String[]{"\\\\\"", "\\\\\\\\", "\\\\/", "\\\\b", "\\\\f", "\\\\n", "\\\\r", "\\\\t"};

    public DummyJSONSerializer() {
    }

    public DummyJSONSerializer(boolean prettyPrint) {
        this.doFormat |= prettyPrint;
    }

    void formatEnter(StringBuilder sb) {
        if (!this.doFormat) {
            return;
        }
        ++this.level;
    }

    void formatMid(StringBuilder sb) {
        if (!this.doFormat) {
            return;
        }
        sb.append("\n");
        for (int i = 0; i < this.tabs * this.level; ++i) {
            sb.append(' ');
        }
    }

    void formatLeave(StringBuilder sb) {
        if (!this.doFormat) {
            return;
        }
        --this.level;
    }

    private static boolean fieldFilter(Field field) {
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        return !"hash".equals(field.getName()) || !"java.lang.String".equals(field.getDeclaringClass().getName());
    }

    StringBuilder serializeEnum(StringBuilder sb, Enum e) {
        return sb.append('\"').append(e.name()).append('\"');
    }

    private static boolean isNumberOrBoolean(Object o) {
        return o instanceof Number || o instanceof Boolean;
    }

    StringBuilder serializeNumberOrBoolean(StringBuilder sb, Object o) {
        return sb.append(o.toString());
    }

    StringBuilder serializeString(StringBuilder sbuilder, String o) {
        StringBuffer sb = new StringBuffer((int)((float)o.length() * 1.1f) + 2);
        Matcher m = escape3Pattern.matcher(o);
        sb.append('\"');
        while (m.find()) {
            char c = m.group().charAt(0);
            int index = escape3Text.indexOf(c);
            m.appendReplacement(sb, index >= 0 ? escape3Replacement[index] : String.format("\\\\u%04x", c));
        }
        m.appendTail(sb);
        sb.append('\"');
        return sbuilder.append(sb.toString());
    }

    StringBuilder serializeMap(StringBuilder sb, Map m) {
        sb.append('{');
        this.formatEnter(sb);
        int count = 0;
        for (Object key : m.keySet()) {
            Object value = m.get(key);
            if (value == null) continue;
            if (count > 0) {
                sb.append(',');
            }
            this.formatMid(sb);
            ++count;
            this.serialize(sb, key).append(':');
            this.serialize(sb, value);
        }
        this.formatLeave(sb);
        if (count > 0) {
            this.formatMid(sb);
        }
        return sb.append('}');
    }

    StringBuilder serializeCollection(StringBuilder sb, Collection c) {
        sb.append('[');
        this.formatEnter(sb);
        int count = 0;
        for (Object o : c) {
            if (count > 0) {
                sb.append(',');
            }
            this.formatMid(sb);
            ++count;
            this.serialize(sb, o);
        }
        this.formatLeave(sb);
        if (count > 0) {
            this.formatMid(sb);
        }
        return sb.append(']');
    }

    private StringBuilder printFieldName(StringBuilder sb, Field field) {
        return this.serializeString(sb, field.getName());
    }

    StringBuilder serializeObject(StringBuilder sb, Object o) {
        if (null == o) {
            return sb.append("null");
        }
        sb.append('{');
        this.formatEnter(sb);
        Class<?> oc = o.getClass();
        int count = 0;
        for (Field field : oc.getDeclaredFields()) {
            if (!DummyJSONSerializer.fieldFilter(field)) continue;
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(o);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException("Tykwa: ", e);
            }
            if (value == null) continue;
            if (count > 0) {
                sb.append(',');
            }
            this.formatMid(sb);
            this.printFieldName(sb, field).append(':');
            this.serialize(sb, value);
            ++count;
        }
        this.formatLeave(sb);
        if (count > 0) {
            this.formatMid(sb);
        }
        return sb.append('}');
    }

    @Override
    public StringBuilder serialize(StringBuilder sb, Object o) {
        if (null == o) {
            return null;
        }
        if (o instanceof String) {
            return this.serializeString(sb, (String)o);
        }
        if (o instanceof Enum) {
            return this.serializeEnum(sb, (Enum)o);
        }
        if (DummyJSONSerializer.isNumberOrBoolean(o)) {
            return this.serializeNumberOrBoolean(sb, o);
        }
        if (o instanceof Map) {
            return this.serializeMap(sb, (Map)o);
        }
        if (o instanceof Collection) {
            return this.serializeCollection(sb, (Collection)o);
        }
        return this.serializeObject(sb, o);
    }

    @Override
    public String serialize(Object o) {
        return this.serialize(new StringBuilder(), o).toString();
    }
}

