/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.jfr.access;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import jdk.jfr.internal.FlightRecorderAssociate;
import jdk.jfr.internal.SecuritySupport;

public final class FlightRecorderAccess {
    private static final AccessException initException;
    private static final Method chunkUseMethod;
    private static final Method chunkReleaseMethod;
    private static final Method recorderSetAssociateMethod;

    private FlightRecorderAccess() {
    }

    public void useRepositoryChunk(Object chunk) throws AccessException {
        try {
            chunkUseMethod.invoke(chunk, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new AccessException(ex);
        }
    }

    public void releaseRepositoryChunk(Object chunk) throws AccessException {
        try {
            chunkReleaseMethod.invoke(chunk, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new AccessException(ex);
        }
    }

    public static FlightRecorderAccess getAccess(FlightRecorder fr, final FlightRecorderCallbacks callbacks) throws AccessException {
        if (initException != null) {
            throw initException;
        }
        try {
            recorderSetAssociateMethod.invoke((Object)fr, new FlightRecorderAssociate(){

                public void nextChunk(Object chunk, SecuritySupport.SafePath path, Instant startTime, Instant endTime, long size, Recording ignoreMe) {
                    callbacks.nextChunk(chunk, path.toPath(), startTime, endTime, size, ignoreMe);
                }

                public void finishJoin() {
                    callbacks.finishJoin();
                }
            });
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new AccessException(ex);
        }
        return new FlightRecorderAccess();
    }

    static {
        final AtomicReference ex = new AtomicReference();
        final AtomicReference chunkUseMethodRef = new AtomicReference();
        final AtomicReference chunkReleaseMethodRef = new AtomicReference();
        final AtomicReference recorderSetAssociateMethodRef = new AtomicReference();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Method m = FlightRecorder.class.getDeclaredMethod("setAssociate", FlightRecorderAssociate.class);
                    m.setAccessible(true);
                    recorderSetAssociateMethodRef.set(m);
                    Class<?> chunkClass = Class.forName("jdk.jfr.internal.RepositoryChunk");
                    m = chunkClass.getDeclaredMethod("use", new Class[0]);
                    m.setAccessible(true);
                    chunkUseMethodRef.set(m);
                    m = chunkClass.getDeclaredMethod("release", new Class[0]);
                    m.setAccessible(true);
                    chunkReleaseMethodRef.set(m);
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    ex.set(new AccessException(e));
                }
                return null;
            }
        });
        initException = (AccessException)ex.get();
        chunkUseMethod = (Method)chunkUseMethodRef.get();
        chunkReleaseMethod = (Method)chunkReleaseMethodRef.get();
        recorderSetAssociateMethod = (Method)recorderSetAssociateMethodRef.get();
    }

    public static final class AccessException
    extends Exception {
        private static final long serialVersionUID = -3710493080622598156L;

        private AccessException(Throwable cause) {
            super(cause);
        }
    }

    public static interface FlightRecorderCallbacks {
        public void nextChunk(Object var1, Path var2, Instant var3, Instant var4, long var5, Recording var7);

        public void finishJoin();
    }
}

