/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.Result;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.models.VMArtifactChunk;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.jfr.access.FlightRecorderAccess;
import com.azul.crs.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import jdk.jfr.Configuration;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;

public final class JFRMonitor
implements ClientService,
FlightRecorderListener,
FlightRecorderAccess.FlightRecorderCallbacks {
    private static final String SERVICE_NAME = "client.service.JFR";
    private static final Logger logger = Logger.getLogger(JFRMonitor.class);
    private static JFRMonitor instance;
    private static final AtomicReference<Thread> initTask;
    private final AtomicReference<FlightRecorder> recorder = new AtomicReference();
    private final AtomicInteger chunkSequenceNumber = new AtomicInteger();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final Map<Long, Integer> idMap = new HashMap<Long, Integer>();
    private final Object shutdownJfrMonitor = new Object();
    private final Client client;
    private final String params;
    private final AtomicReference<FlightRecorderAccess> accessRef = new AtomicReference();

    private JFRMonitor(Client client, String params) {
        this.client = client;
        this.params = params;
    }

    public static synchronized JFRMonitor getInstance(Client client, String params) {
        if (instance == null) {
            instance = new JFRMonitor(client, params);
            initTask.set(new Thread("JFRMonitor Init Thread"){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    FlightRecorder.addListener(instance);
                }
            });
            try {
                initTask.get().start();
                initTask.get().join();
                JFRMonitor.instance.initialized.set(true);
            }
            catch (InterruptedException ex) {
                logger.debug("Exception when waiting JFRMonitor initTask", ex);
            }
            finally {
                initTask.set(null);
            }
            return instance;
        }
        if (!Objects.equals(client, JFRMonitor.instance.client) || !Objects.equals(params, JFRMonitor.instance.params)) {
            throw new IllegalArgumentException("client.service.JFR: an instance with different parameters has already been created");
        }
        return instance;
    }

    @Override
    public String serviceName() {
        return SERVICE_NAME;
    }

    @Override
    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("client.service.JFR has already been started");
        }
        if (this.initialized.get()) {
            JFRMonitor.maybeStartLifetimeRecording(this.params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(long deadline) {
        if (!this.stopped.compareAndSet(false, true)) {
            throw new IllegalStateException("client.service.JFR has already been stopped");
        }
        Object object = this.shutdownJfrMonitor;
        synchronized (object) {
            while (this.recorder.get() != null) {
                logger.debug("Waiting for jfr to shutdown", new Object[0]);
                try {
                    this.shutdownJfrMonitor.wait(deadline);
                }
                catch (InterruptedException ignored) {
                    Thread.interrupted();
                }
            }
        }
        logger.debug("Unblocked CRS client shutdown", new Object[0]);
    }

    @Override
    public void recorderInitialized(FlightRecorder recorder) {
        if (!this.recorder.compareAndSet(null, recorder)) {
            throw new IllegalStateException("recorderInitialized is expected to be called only once");
        }
        try {
            this.setAccess(FlightRecorderAccess.getAccess(recorder, this));
        }
        catch (Throwable ex) {
            this.recorder.set(null);
            FlightRecorder.removeListener(instance);
            logger.error("Cannot install associate to JFR: %s", ex.toString());
            return;
        }
        for (Recording recording : recorder.getRecordings()) {
            this.recordingStateChanged(recording);
        }
    }

    @Override
    public void recordingStateChanged(Recording recording) {
        logger.debug("recording %s state changed to %s", new Object[]{this.getRecordingName(recording), recording.getState()});
        try {
            this.createOrUpdate(recording);
        }
        catch (Throwable th) {
            logger.error("Exception %s", th.getMessage(), th);
        }
    }

    @Override
    public void nextChunk(Object chunk, Path path, Instant startTime, Instant endTime, long size, Recording ignoreMe) {
        this.lockRepositoryChunk(chunk);
        ArrayList<Long> recordingIds = new ArrayList<Long>();
        for (Recording r : this.recorder.get().getRecordings()) {
            long id = r.getId();
            if (r == ignoreMe || !this.idMap.containsKey(id)) continue;
            recordingIds.add(id);
        }
        if (recordingIds.isEmpty()) {
            logger.warning("No active record for the chunk", new Object[0]);
            return;
        }
        this.enqueuePostVMArtifactChunk(chunk, path, startTime, endTime == null ? Instant.now() : endTime, size, recordingIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishJoin() {
        logger.debug("shutting down JFR " + System.currentTimeMillis(), new Object[0]);
        try {
            Thread task = initTask.get();
            if (task != null) {
                task.interrupt();
                logger.warning("JFR stopped before JFRMonitor was fully initialized.", new Object[0]);
            } else {
                for (Recording r : this.recorder.get().getRecordings()) {
                    r.close();
                }
                this.client.finishChunkPost();
            }
        }
        finally {
            Object object = this.shutdownJfrMonitor;
            synchronized (object) {
                this.recorder.set(null);
                this.shutdownJfrMonitor.notify();
            }
        }
        logger.debug("JFR tracking finished " + System.currentTimeMillis(), new Object[0]);
    }

    private void enqueuePostVMArtifactChunk(final Object chunk, final Path path, Instant startTime, Instant endTime, long size, Collection<Long> recordingIds) {
        logger.debug("Enqueuing chunk data record [%s, size %d], Recordings: %s", path.toString(), size, Arrays.toString(recordingIds.toArray()));
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("startTime", startTime.toEpochMilli());
        attributes.put("endTime", endTime.toEpochMilli());
        attributes.put("size", size);
        attributes.put("path", path.toString());
        attributes.put("sequenceNumber", Integer.toString(this.chunkSequenceNumber.incrementAndGet()));
        HashSet<String> artifactIds = new HashSet<String>(recordingIds.size());
        for (Long id : recordingIds) {
            artifactIds.add(Client.artifactIdToString(this.idMap.get(id)));
        }
        this.client.postVMArtifactChunk(artifactIds, attributes, path.toFile(), new Client.UploadListener<VMArtifactChunk>(){

            @Override
            public void uploadComplete(VMArtifactChunk request) {
                JFRMonitor.this.releaseRepositoryChunk(chunk);
            }

            @Override
            public void uploadFailed(VMArtifactChunk request, Result<String[]> result) {
                logger.warning("Failed to send recording chunk %s: %s%s", path.toString(), result, Client.isVMShutdownInitiated() ? " (expected during shutdown if timeout is exceeded)" : "");
                JFRMonitor.this.releaseRepositoryChunk(chunk);
            }
        });
    }

    private void setAccess(FlightRecorderAccess access) {
        this.accessRef.set(access);
    }

    private void lockRepositoryChunk(Object chunk) {
        try {
            logger.debug("locking chunk %s", chunk);
            this.accessRef.get().useRepositoryChunk(chunk);
        }
        catch (FlightRecorderAccess.AccessException shouldnothappen) {
            shouldnothappen.printStackTrace();
        }
    }

    private void releaseRepositoryChunk(Object chunk) {
        try {
            logger.debug("releasing chunk %s", chunk);
            this.accessRef.get().releaseRepositoryChunk(chunk);
        }
        catch (FlightRecorderAccess.AccessException shouldnothappen) {
            shouldnothappen.printStackTrace();
        }
    }

    private static void maybeStartLifetimeRecording(String params) {
        Recording recording;
        if (null == params || "disable".equals(params)) {
            logger.info("lifetime recording is disabled", new Object[0]);
            return;
        }
        if (!FlightRecorder.isAvailable()) {
            logger.warning("lifetime recording is not available", new Object[0]);
            return;
        }
        if (params.isEmpty()) {
            recording = new Recording();
            logger.info("started lifetime recording with empty configuration", new Object[0]);
        } else {
            try {
                recording = new Recording(Configuration.create(new File(params).toPath()));
                logger.info("started lifetime recording with configuration from %s", params);
            }
            catch (IOException | ParseException ex) {
                logger.error("cannot read or parse specified JFR configuration file %s. recording stopped", params);
                return;
            }
        }
        recording.setName("lifetime recording");
        recording.scheduleStart(Duration.ZERO);
    }

    private String getRecordingName(Recording recording) {
        String name = recording.getName();
        if (!Long.toString(recording.getId()).equals(name)) {
            return name;
        }
        Path path = recording.getDestination();
        return path == null ? name : path.getFileName().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrUpdate(Recording recording) {
        Integer old_id;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        RecordingState state = recording.getState();
        attributes.put("state", state.name());
        if (state == RecordingState.STOPPED || state == RecordingState.CLOSED) {
            attributes.put("stopTime", recording.getStopTime().toEpochMilli());
        }
        long id = recording.getId();
        int new_id = -1;
        Map<Long, Integer> map = this.idMap;
        synchronized (map) {
            old_id = this.idMap.get(id);
            if (old_id == null) {
                new_id = this.client.createArtifactId();
                this.idMap.put(id, new_id);
            }
        }
        if (new_id > 0) {
            attributes.put("name", this.getRecordingName(recording));
            attributes.put("tags", Inventory.instanceTags());
            attributes.put("startTime", recording.getStartTime().toEpochMilli());
            Path path = recording.getDestination();
            if (path != null) {
                attributes.put("destination", path.toString());
            }
            this.client.postVMArtifact(VMArtifact.Type.JFR, new_id, attributes);
            logger.debug("Enqueued VMArtifact creation [id: %d, crs_id: %d]", id, new_id);
        } else {
            this.client.postVMArtifactPatch(VMArtifact.Type.JFR, old_id, attributes);
            logger.debug("Enqueued VMArtifact patching [id: %d, crs_id: %d]", id, old_id);
        }
    }

    static {
        initTask = new AtomicReference();
    }
}

