/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.FileTailer;
import com.azul.crs.client.service.FileTailerListener;
import com.azul.crs.client.service.GCRotatingLogTailer;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GCLogMonitor
implements ClientService {
    private static long CHECK_DELAY = 1000L;
    private static int BUFFER_SIZE = 102400;
    private final Client client;
    private final long startTime;
    private final AtomicLong reported;
    private FileTailer tailer;
    private volatile boolean running;

    @Override
    public String serviceName() {
        return "client.service.GCLog";
    }

    private GCLogMonitor(Client client, long startTime) {
        this.client = client;
        this.startTime = startTime;
        this.reported = new AtomicLong();
    }

    public static GCLogMonitor getInstance(Client client, long startTime) {
        return new GCLogMonitor(client, startTime);
    }

    private static Map<String, ?> gclogOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        List<String> jvmArgs = Inventory.jvmArgs();
        for (String arg : jvmArgs) {
            for (Option o : Option.values()) {
                if (o.matchAndSet(arg, options)) break;
            }
        }
        return options;
    }

    private FileTailerListener gclogListener(final int artifactId) {
        return new FileTailerListener(){

            @Override
            public void handle(byte[] data, int size) {
                GCLogMonitor.this.client.postVMArtifactData(VMArtifact.Type.GC_LOG, artifactId, data, size);
                long reported = GCLogMonitor.this.reported.addAndGet(size);
                GCLogMonitor.this.logger().info("appended GC log artifact %s: size=%,d bytes, reported=%,d bytes", artifactId, size, reported);
            }

            @Override
            public void handle(Exception ex) {
                GCLogMonitor.this.logger().error("failed to tail GC log file: %s", ex.toString());
            }

            @Override
            public void fileRotated(String details) {
                GCLogMonitor.this.logger().info("GC log file rotated: " + details, new Object[0]);
            }

            @Override
            public void fileNotFound() {
                GCLogMonitor.this.logger().info("GC log file not found", new Object[0]);
            }

            @Override
            public void interrupted() {
                GCLogMonitor.this.logger().info("GC log tailing interrupted", new Object[0]);
            }
        };
    }

    private String getGClogFileName11(String xlogArgs) {
        String res = null;
        String w = xlogArgs;
        if (w != null && w.matches("^[^:]*(gc|all)[^:]*:.*$")) {
            w = w.replaceFirst("^[^:]*:", "");
            if ((w = w.replaceFirst("file=", "")).startsWith("\"")) {
                w = w.substring(1, w.indexOf("\"", 1));
            } else {
                int until = w.indexOf(":");
                if (System.getProperty("os.name").contains("Windows") && ":\\".equals(w.substring(until, until + 2))) {
                    until = w.indexOf(":", until + 1);
                }
                w = w.substring(0, until);
            }
            res = w;
        }
        return res;
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException(this.serviceName() + " is running already");
        }
        Map<String, ?> options = GCLogMonitor.gclogOptions();
        String gclogFileName = null;
        gclogFileName = (String)options.get(Option.LOG_GC.flag());
        if (gclogFileName == null) {
            gclogFileName = this.getGClogFileName11((String)options.get(Option.XLOG.flag()));
        }
        if (gclogFileName == null) {
            return;
        }
        if (gclogFileName.indexOf("%t") >= 0 || gclogFileName.indexOf("%p") >= 0) {
            this.logger().info("unsupported '%' macros in GC log file name", new Object[0]);
            return;
        }
        int artifactId = this.client.createArtifactId();
        this.logger().info("created VM artifact: " + artifactId, new Object[0]);
        File gclogFile = new File(gclogFileName);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("name", gclogFile.getName());
        metadata.put("tags", Inventory.instanceTags());
        metadata.put("options", options);
        this.client.postVMArtifact(VMArtifact.Type.GC_LOG, artifactId, metadata);
        FileTailerListener listener = this.gclogListener(artifactId);
        if (Boolean.TRUE.equals(options.get(Option.USE_GC_LOG_FILE_ROTATION.flag()))) {
            String logCountStr = (String)options.get(Option.NUMBER_OF_GC_LOG_FILES.flag());
            int logCount = Integer.parseInt(logCountStr);
            this.logger().info("GC log rotation requested: logCount=" + logCount, new Object[0]);
            this.tailer = ((GCRotatingLogTailer.Builder)((GCRotatingLogTailer.Builder)((GCRotatingLogTailer.Builder)((GCRotatingLogTailer.Builder)new GCRotatingLogTailer.Builder(gclogFile).serviceName(this.serviceName())).listener(listener)).delayTimeout(CHECK_DELAY)).bufSize(BUFFER_SIZE)).logCount(logCount).startTime(this.startTime).build();
        } else {
            this.tailer = ((FileTailer.Builder)((FileTailer.Builder)((FileTailer.Builder)((FileTailer.Builder)new FileTailer.Builder(gclogFile).serviceName(this.serviceName())).listener(listener)).delayTimeout(CHECK_DELAY)).bufSize(BUFFER_SIZE)).build();
        }
        this.running = true;
        this.tailer.start();
    }

    @Override
    public synchronized void stop(long deadline) {
        if (!this.running) {
            return;
        }
        this.tailer.stop(deadline);
        this.running = false;
        this.logger().info("GC log monitor stopped: reported=%,d bytes", this.reported.get());
    }

    static enum Option {
        LOG_GC("-X(loggc):(\\S+)"),
        XLOG("-X(log):(\\S+)"),
        PRINT_GC("-XX:\\+(PrintGC)"),
        PRINT_GC_DETAILS("-XX:\\+(PrintGCDetails)"),
        PRINT_GC_TIME_STAMPS("-XX:\\+(PrintGCTimeStamps)"),
        PRINT_GC_DATE_STAMPS("-XX:\\+(PrintGCDateStamps)"),
        PRINT_HEAP_AT_GC("-XX:\\+(PrintHeapAtGC)"),
        USE_GC_LOG_FILE_ROTATION("-XX:\\+(UseGCLogFileRotation)"),
        NUMBER_OF_GC_LOG_FILES("-XX:(NumberOfGCLogFiles)=(\\S+)"),
        GC_LOG_FILE_SIZE("-XX:(GCLogFileSize)=(\\S+)");

        private final Pattern pattern;
        private final String flag;

        private Option(String regex) {
            this.flag = regex.substring(regex.indexOf(40) + 1, regex.indexOf(41));
            this.pattern = Pattern.compile(regex);
        }

        public Pattern pattern() {
            return this.pattern;
        }

        public String flag() {
            return this.flag;
        }

        public boolean matchAndSet(String s, Map<String, Object> options) {
            Matcher matcher = this.pattern.matcher(s);
            if (matcher.matches()) {
                String name = matcher.group(1);
                Object value = matcher.groupCount() > 1 ? matcher.group(2) : Boolean.valueOf(true);
                options.put(name, value);
                return true;
            }
            return false;
        }
    }
}

