/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.service.ClientService;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class CRSLogMonitor
implements ClientService {
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private static final String OVERFLOW_WARNING = "... [truncated] ...";
    private final AtomicReference<ByteBuffer> bufferRef;
    private final AtomicBoolean overflow = new AtomicBoolean(false);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicInteger artifactID = new AtomicInteger(0);
    private final AtomicReference<Client> clientRef = new AtomicReference();

    public CRSLogMonitor() {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        buffer.limit(4096 - OVERFLOW_WARNING.length());
        this.bufferRef = new AtomicReference<ByteBuffer>(buffer);
    }

    public void setClient(Client client) {
        if (!this.clientRef.compareAndSet(null, client)) {
            throw new IllegalStateException(this.serviceName() + " client is defined already");
        }
    }

    @Override
    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException(this.serviceName() + " is running already");
        }
        Client client = this.clientRef.get();
        if (client == null) {
            throw new IllegalStateException(this.serviceName() + " starting without client defined");
        }
        int id = client.createArtifactId();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("name", "crs.log");
        metadata.put("tags", Inventory.instanceTags());
        client.postVMArtifact(VMArtifact.Type.CRS_LOG, id, metadata);
        if (!this.artifactID.compareAndSet(0, id)) {
            throw new IllegalStateException(this.serviceName() + " artifactID is set already");
        }
    }

    @Override
    public void stop(long deadline) {
        this.stopped.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCRSLogEntry(byte[] buf, int offset, int len) {
        if (this.stopped.get()) {
            return;
        }
        int id = this.artifactID.get();
        ByteBuffer buffer = this.bufferRef.get();
        if (id == 0) {
            if (!this.overflow.get()) {
                AtomicBoolean atomicBoolean = this.overflow;
                synchronized (atomicBoolean) {
                    if (!this.overflow.get() && buffer.remaining() > len) {
                        buffer.put(buf, offset, len);
                    } else {
                        buffer.limit(buffer.capacity());
                        buffer.put(OVERFLOW_WARNING.getBytes());
                        this.overflow.set(true);
                    }
                }
            }
        } else {
            Client client = this.clientRef.get();
            if (buffer != null && this.bufferRef.compareAndSet(buffer, null)) {
                client.postVMArtifactData(VMArtifact.Type.CRS_LOG, id, buffer.array(), buffer.position());
            }
            client.postVMArtifactData(VMArtifact.Type.CRS_LOG, id, buf, offset, len);
        }
    }
}

