/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.models;

import com.azul.crs.client.models.Payload;
import com.azul.crs.client.models.VMArtifactChunk;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VMArtifact
extends Payload {
    private String artifactId;
    private Type artifactType;
    private Map<String, Object> metadata;
    private String vmId;
    private List<VMArtifactChunk> chunks;
    private Long createTime;
    private transient String snapshot;
    private transient Long size;

    public String getArtifactId() {
        return this.artifactId;
    }

    public Type getArtifactType() {
        return this.artifactType;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String getVmId() {
        return this.vmId;
    }

    public List<VMArtifactChunk> getChunks() {
        return this.chunks;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getSize() {
        return this.size;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setArtifactType(Type artifactType) {
        this.artifactType = artifactType;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void setVmId(String vmId) {
        this.vmId = vmId;
    }

    public void setChunks(List<VMArtifactChunk> chunks) {
        this.chunks = chunks;
    }

    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public VMArtifact artifactId(String artifactId) {
        this.setArtifactId(artifactId);
        return this;
    }

    public VMArtifact artifactType(Type artifactType) {
        this.setArtifactType(artifactType);
        return this;
    }

    public VMArtifact artifactType(String artifactType) {
        if (artifactType != null) {
            this.setArtifactType(Type.valueOf(artifactType));
        }
        return this;
    }

    public VMArtifact metadata(Map<String, Object> metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public VMArtifact vmId(String vmId) {
        this.setVmId(vmId);
        return this;
    }

    public VMArtifact snapshot(String snapshot) {
        this.setSnapshot(snapshot);
        return this;
    }

    public VMArtifact createTime(Long createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public VMArtifact chunks(List<VMArtifactChunk> chunks) {
        this.setChunks(chunks);
        return this;
    }

    public VMArtifact size(Long size) {
        this.setSize(size);
        return this;
    }

    public VMArtifactChunk getLastChunk() {
        return this.chunks != null && !this.chunks.isEmpty() ? this.chunks.get(this.chunks.size() - 1) : null;
    }

    public VMArtifactChunk getChunk(String chunkId) {
        return this.chunks.stream().filter(c -> c.getChunkId().equals(chunkId)).findFirst().orElse(null);
    }

    public VMArtifact metadata(String key, Object value) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, value);
        return this;
    }

    public VMArtifact chunk(VMArtifactChunk chunk) {
        if (this.chunks == null) {
            this.chunks = new LinkedList<VMArtifactChunk>();
        }
        this.chunks.add(chunk);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VMArtifact that = (VMArtifact)o;
        return Objects.equals(this.artifactId, that.artifactId) && this.artifactType == that.artifactType && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.vmId, that.vmId) && Objects.equals(this.chunks, that.chunks) && Objects.equals(this.createTime, that.createTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.artifactId, this.artifactType, this.metadata, this.vmId, this.chunks, this.createTime});
    }

    public VMArtifact copy() {
        return new VMArtifact().artifactId(this.artifactId).artifactType(this.artifactType).metadata(this.metadata).vmId(this.vmId).chunks(this.chunks).createTime(this.createTime);
    }

    public static enum Type {
        GC_LOG,
        VM_LOG,
        CRS_LOG,
        JFR,
        DUMMY;

    }
}

