/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.util.logging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.CharBuffer;

public final class VMSupport {
    private static final int CRS_CMD_BUF_SIZE = 1024;
    private static final int CRS_CMD_LEN_SIZE = 4;
    private static final String LEN_FORMAT = "%04d";
    private static final Logger logger = Logger.getLogger(VMSupport.class);
    private final BufferedReader in;
    private final BufferedWriter out;
    private final char[] buffer = new char[1024];
    private final CharBuffer cb = CharBuffer.wrap(this.buffer);

    private VMSupport(InputStream is, OutputStream os) {
        this.in = new BufferedReader(new InputStreamReader(is));
        this.out = new BufferedWriter(new OutputStreamWriter(os));
    }

    static VMSupport init(int port, int secret) throws IOException {
        int retries = 10;
        IOException exception = null;
        for (int i = 1; i <= 10; ++i) {
            try {
                Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
                InputStream is = socket.getInputStream();
                OutputStream os = socket.getOutputStream();
                VMSupport support = new VMSupport(is, os);
                support.send(Integer.toString(secret));
                return support;
            }
            catch (IOException ex) {
                logger.trace("Attempt %d to connect to VM failed (will retry %d more times).", i, 10 - i);
                exception = ex;
                try {
                    Thread.sleep(50 * i);
                    continue;
                }
                catch (InterruptedException ex2) {
                    Thread.interrupted();
                    exception = new IOException(ex2);
                    logger.trace("VMSupport initialization interrupted", new Object[0]);
                    break;
                }
            }
        }
        throw exception;
    }

    void disableCRS() {
        this.sendCommand("disableCRS", new String[0]);
    }

    void registerAgent(Class klass) {
        this.sendCommand("registerAgent", klass.getCanonicalName());
    }

    void enableEventNotifications(CrsNotificationType event, boolean enabled) {
        this.sendCommand("enableEventNotifications", Integer.toString(event.id), enabled ? "1" : "0");
    }

    void drainQueues(boolean force, boolean stopAfterDrain) {
        this.sendCommand("drainQueues", force ? "1" : "0", stopAfterDrain ? "1" : "0");
    }

    void registerCallback(CrsNotificationType event, Method callbackFunction) {
        this.sendCommand("registerCallback", Integer.toString(event.id), callbackFunction.getDeclaringClass().getCanonicalName() + "." + callbackFunction.getName());
    }

    String[] getVMCRSCapabilities() {
        String result = this.sendCommand("getCapabilities", new String[0]);
        return result.isEmpty() ? null : result.split("[, ]+");
    }

    private synchronized String sendCommand(String command, String ... args) {
        try {
            this.cb.clear();
            this.cb.append(command).append("(");
            if (args.length > 0) {
                this.cb.append(args[0]);
                for (int i = 1; i < args.length; ++i) {
                    this.cb.append(',').append(args[i]);
                }
            }
            this.cb.append(")");
            this.cb.flip();
            return this.send(this.cb);
        }
        catch (IOException ex) {
            logger.debug("Exception in sendCommand", ex);
            return "";
        }
    }

    private synchronized String send(CharSequence msg) throws IOException {
        String msg_len = String.format(LEN_FORMAT, msg.length());
        this.out.append(msg_len);
        this.out.append(msg);
        this.out.flush();
        int responseLength = Integer.parseInt(this.read(4).trim());
        return responseLength > 0 ? this.read(responseLength) : "";
    }

    private String read(int size) throws IOException {
        this.cb.clear();
        int toread = size;
        int offset = 0;
        while (toread > 0) {
            int read = this.in.read(this.cb.array(), offset, toread);
            if (read == -1) {
                throw new IOException();
            }
            toread -= read;
            offset += read;
        }
        return this.cb.subSequence(0, size).toString();
    }

    static enum CrsNotificationType {
        EVENT_TO_JAVA_CALL(-98),
        CRS_MESSAGE_CLASS_LOAD(0),
        CRS_MESSAGE_FIRST_CALL(1),
        CRS_MESSAGE_VM_LOG_ENTRY(2);

        private final int id;

        private CrsNotificationType(int id) {
            this.id = id;
        }
    }
}

