/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.ConnectionManager;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Result;
import com.azul.crs.client.Utils;
import com.azul.crs.client.Version;
import com.azul.crs.client.models.Payload;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.models.VMArtifactChunk;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.models.VMInstance;
import com.azul.crs.client.service.EventService;
import com.azul.crs.client.service.UploadService;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Client {
    private final ConnectionManager connectionManager;
    private final UploadService uploadService;
    private final EventService eventService;
    private final AtomicInteger nextArtifactId = new AtomicInteger();
    private final AtomicLong nextArtifactChunkId = new AtomicLong();
    private static volatile long vmShutdownDeadline;
    private long vmShutdownDelay;
    private String vmId;

    private void validateProps(Map<ClientProp, Object> props) {
        for (ClientProp p : ClientProp.values()) {
            if (!p.isMandatory() || props.get((Object)p) != null) continue;
            throw new IllegalArgumentException("Invalid CRS properties file: missing value for " + p.value());
        }
    }

    public Client(Map<ClientProp, Object> props, final ClientListener listener) {
        this.validateProps(props);
        this.vmShutdownDelay = (Long)props.get((Object)ClientProp.VM_SHUTDOWN_DELAY);
        this.eventService = EventService.getInstance(this);
        this.connectionManager = new ConnectionManager(props, this, new ConnectionManager.ConnectionListener(){

            @Override
            public void authenticated() {
                Client.this.vmId = Client.this.connectionManager.getVmId();
                listener.authenticated();
            }

            @Override
            public void syncFailed(Result<String[]> reason) {
                listener.syncFailed(reason);
            }
        });
        this.uploadService = new UploadService(this);
    }

    public void postVMStart(Map<String, Object> inventory, long startTime) throws IOException {
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_CREATE).eventPayload(new VMInstance().agentVersion(this.getClientVersion()).owner(this.connectionManager.getMailbox()).inventory(inventory).startTime(startTime)));
    }

    public void patchInventory(Map<String, Object> inventory) {
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_PATCH).eventPayload(new VMInstance().inventory(inventory)));
    }

    public void postVMEvent(VMEvent event) {
        this.eventService.add(event.randomEventId());
    }

    public void postVMShutdown(Collection<VMEvent> trailingEvents) {
        this.eventService.addAll(trailingEvents);
        this.eventService.add(new VMEvent().eventType(VMEvent.Type.VM_SHUTDOWN).eventTime(Utils.currentTimeMillis()));
    }

    public int createArtifactId() {
        return this.nextArtifactId.incrementAndGet();
    }

    public long createArtifactChunkId() {
        return this.nextArtifactChunkId.incrementAndGet();
    }

    public void postVMArtifact(VMArtifact.Type type, int artifactId, Map<String, Object> attributes) {
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_CREATE).eventPayload(new VMArtifact().artifactType(type).artifactId(Client.artifactIdToString(artifactId)).metadata(attributes)));
    }

    public void postVMArtifactPatch(VMArtifact.Type type, int artifactId, Map<String, Object> attributes) {
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_PATCH).eventPayload(new VMArtifact().artifactType(type).artifactId(Client.artifactIdToString(artifactId)).metadata(attributes)));
    }

    public void postVMArtifactData(VMArtifact.Type type, int artifactId, byte[] data, int size) {
        this.postVMArtifactData(type, artifactId, data, 0, size);
    }

    public void postVMArtifactData(VMArtifact.Type type, int artifactId, byte[] data, int offset, int size) {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("artifactId", Client.artifactIdToString(artifactId));
        payload.put("data", new String(data, 0, offset, size));
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_DATA).eventPayload(payload));
        PerformanceMetrics.logArtifactBytes(size);
    }

    public void postVMArtifactChunk(Set<String> artifactIds, Map<String, Object> attributes, File chunkData, UploadListener<VMArtifactChunk> listener) {
        this.uploadService.post(new VMArtifactChunk().artifactIds(artifactIds).metadata(attributes), chunkData, listener);
    }

    public void finishChunkPost() {
        long shutdownDeadline = vmShutdownDeadline;
        this.uploadService.sync(shutdownDeadline > 0L ? shutdownDeadline : Utils.nextTimeCount(this.vmShutdownDelay));
    }

    public static String artifactIdToString(int artifactId) {
        return Integer.toString(artifactId, 36);
    }

    public void startup() throws IOException {
        this.connectionManager.start();
        this.eventService.start();
        this.uploadService.start();
    }

    public void connectionEstablished() {
        this.eventService.connectionEstablished();
        this.uploadService.connectionEstablished();
    }

    public static boolean isVMShutdownInitiated() {
        return vmShutdownDeadline > 0L;
    }

    public static void setVMShutdownInitiated(long deadline) {
        vmShutdownDeadline = deadline;
    }

    public static long getVMShutdownDeadline() {
        return vmShutdownDeadline;
    }

    public void shutdown(long deadline) {
        this.eventService.stop(deadline);
        this.uploadService.stop(deadline);
    }

    public void cancel() {
        this.eventService.cancel();
        this.uploadService.cancel();
    }

    public String getVmId() {
        return this.vmId;
    }

    public String getClientVersion() throws IOException {
        return new Version().clientVersion();
    }

    public String getMailbox() {
        return this.connectionManager.getMailbox();
    }

    public String getRestAPI() {
        return this.connectionManager.getRestAPI();
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public static enum ClientProp {
        API_URL("api.url", true),
        API_MAILBOX("api.mailbox", true),
        KS("ks", false),
        HEAP_BUFFER_SIZE("heapBufferSize", false),
        FILE_SYSTEM_BUFFER_SIZE("fileSystemBufferSize", false),
        FILE_SYSTEM_BUFFER_LOCATION("fileSystemBufferLocation", false),
        NUM_CONCURRENT_CONNECTIONS("numConcurrentConnections", false),
        BACKUP_JFR_CHUNKS("backupJfrChunks", false),
        VM_SHUTDOWN_DELAY("delayShutdownInternal", true);

        private final Object value;
        private final boolean mandatory;

        private ClientProp(String value, boolean mandatory) {
            this.value = value;
            this.mandatory = mandatory;
        }

        Object value() {
            return this.value;
        }

        boolean isMandatory() {
            return this.mandatory;
        }
    }

    public static interface UploadListener<T extends Payload> {
        public void uploadComplete(T var1);

        public void uploadFailed(T var1, Result<String[]> var2);
    }

    public static interface ClientListener {
        public void authenticated();

        public void syncFailed(Result<String[]> var1);
    }
}

