/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.CRSException;
import com.azul.crs.client.Client;
import com.azul.crs.client.ConnectionManager;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.Options;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Result;
import com.azul.crs.client.Utils;
import com.azul.crs.client.VMSupport;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.CRSLogMonitor;
import com.azul.crs.client.service.ClassLoadMonitor;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.FirstCallMonitor;
import com.azul.crs.client.service.GCLogMonitor;
import com.azul.crs.client.service.HeartbeatService;
import com.azul.crs.client.service.JFRMonitor;
import com.azul.crs.client.service.VMLogMonitor;
import com.azul.crs.client.util.DnsDetect;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sun.launcher.LauncherHelper;

class Agent001 {
    private static final int CRS_DISABLED = -1;
    private static final int CRS_NOT_YET_DECIDED = 0;
    private static final int CRS_LAUNCHER_DETECTED = 1;
    private static final int CRS_ENABLED_FORCED = 2;
    private static final int CRS_ENABLED_MAIN_KNOWN = 3;
    private static HeartbeatService heartbeatService;
    private static GCLogMonitor gclogMonitor;
    private static VMLogMonitor vmlogMonitor;
    private static JFRMonitor jfrMonitor;
    private static ClassLoadMonitor classLoadMonitor;
    private static FirstCallMonitor firstCallMonitor;
    private static Client client;
    private static volatile int useCRS;
    private static Thread startThread;
    private static volatile boolean launcherDetected;
    private static final int FLUSH_THREAD_DEFAULT_PERIOD_MS = 1000;
    private static final int FLUSH_THREAD_FORCE_DEFAULT_PERIOD_MS = 1800000;
    private static final long DEFAULT_SHUTDOWN_DELAY = 120000L;
    private static final Object flushThreadLock;
    private static boolean flushThreadStop;
    private static volatile Thread flushThread;
    private static int forceFlushTimeout;
    private static long delayShutdown;
    private static final Logger logger;
    private static final CRSLogMonitor crslogMonitor;
    private static boolean connectionEstablished;
    static VMSupport vmSupport;

    Agent001() {
    }

    private static void addShutdownHook(final long startTime) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long shutdownDeadline = Utils.nextTimeCount(delayShutdown);
                Client.setVMShutdownInitiated(shutdownDeadline);
                long shutdownStartTime = Utils.currentTimeCount();
                try {
                    if (delayShutdown > 0L) {
                        logger.trace("checking if startup is complete and waiting for it to finish (%d ms)", delayShutdown);
                        startThread.join();
                        if (useCRS == -1) {
                            return;
                        }
                        logger.debug("drain native queue", new Object[0]);
                        flushThreadStop = true;
                        Object object = flushThreadLock;
                        synchronized (object) {
                            flushThreadLock.notifyAll();
                        }
                        try {
                            flushThread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Agent001.stopServices(shutdownDeadline, new ClientService[]{heartbeatService, jfrMonitor, vmlogMonitor, gclogMonitor, classLoadMonitor, firstCallMonitor});
                        Map perfMonData = PerformanceMetrics.logPreShutdown(Utils.elapsedTimeMillis(shutdownStartTime));
                        Agent001.postVMShutdown(client, perfMonData);
                        client.shutdown(shutdownDeadline);
                    }
                    if (client != null) {
                        PerformanceMetrics.logShutdown(Utils.elapsedTimeMillis(shutdownStartTime));
                        PerformanceMetrics.report();
                        logger.info("Agent terminated: vmId=%s, runningTime=%d", client.getVmId(), Utils.elapsedTimeMillis(startTime));
                    } else {
                        logger.info("Agent shut down during startup. Data is discarded", new Object[0]);
                    }
                }
                catch (InterruptedException e) {
                    logger.error("Agent failed to process shutdown during startup. Data is discarded", new Object[0]);
                }
            }
        }));
    }

    private static void postVMStart(long startTime, String mainMethod) throws Exception {
        Map<String, Object> inventory = new Inventory().populate().mainMethod(mainMethod).toMap();
        logger.trace("Post VM start to CRS service", new Object[0]);
        client.postVMStart(inventory, startTime);
    }

    private static void sendMainMethodName(String mainMethod) {
        Map<String, Object> inventory = new Inventory().mainMethod(mainMethod).toMap();
        client.patchInventory(inventory);
    }

    private static void sendNetworkInformation() {
        Map<String, Object> inventory = new Inventory().networkInformation().toMap();
        client.patchInventory(inventory);
    }

    private static void postVMShutdown(Client client, Map perfMonData) {
        logger.trace("Post VM shutdown to CRS service", new Object[0]);
        ArrayList<VMEvent> trailingEvents = new ArrayList<VMEvent>();
        trailingEvents.add(new VMEvent().eventType(VMEvent.Type.VM_PERFORMANCE_METRICS).randomEventId().eventTime(System.currentTimeMillis()).eventPayload(perfMonData));
        client.postVMShutdown(trailingEvents);
    }

    public static void premain(String args, Instrumentation unused) {
        Options.read(args);
        try {
            vmSupport = VMSupport.init(Options.getConnectionPort(), Options.getConnectionSecret());
            vmSupport.registerAgent(Agent001.class);
            Method notifyToJavaCall = Agent001.class.getMethod("notifyToJavaCall", String.class);
            vmSupport.registerCallback(VMSupport.CrsNotificationType.EVENT_TO_JAVA_CALL, notifyToJavaCall);
            Method notifyClassLoad = Agent001.class.getMethod("notifyClassLoad", String.class, byte[].class, Integer.TYPE, Integer.TYPE, String.class);
            vmSupport.registerCallback(VMSupport.CrsNotificationType.CRS_MESSAGE_CLASS_LOAD, notifyClassLoad);
            Method notifyFirstCall = Agent001.class.getMethod("notifyFirstCall", Integer.TYPE, String.class);
            vmSupport.registerCallback(VMSupport.CrsNotificationType.CRS_MESSAGE_FIRST_CALL, notifyFirstCall);
            Method notifyVMLogEntry = Agent001.class.getMethod("notifyVMLogEntry", String.class, String.class);
            vmSupport.registerCallback(VMSupport.CrsNotificationType.CRS_MESSAGE_VM_LOG_ENTRY, notifyVMLogEntry);
        }
        catch (IOException | NoSuchMethodException | SecurityException ex) {
            logger.error("Failed to initialize", ex);
            return;
        }
        PerformanceMetrics.init();
        if ("force".equals(Options.useCRS.get())) {
            Agent001.stateEvent(2, null);
        }
        if (Options.forceSyncTimeout.isSet()) {
            forceFlushTimeout = Options.forceSyncTimeout.getInt() * 1000;
        }
        if (Options.delayShutdown.isSet()) {
            delayShutdown = Options.delayShutdown.getLong();
        }
        if (Options.noDelayShutdown.isSet()) {
            delayShutdown = 0L;
        }
        System.setProperty("com.azul.crs.instance.options.delayShutdown", Long.toString(delayShutdown));
    }

    private static synchronized void stateEvent(int state, final String mainMethod) {
        switch (state) {
            case 2: {
                assert (useCRS != -1);
                if (useCRS != 0 && useCRS != 1) break;
                useCRS = 2;
                Agent001.activateAgent("");
                break;
            }
            case 1: {
                if (useCRS == 0) {
                    useCRS = 1;
                }
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Class<?> applicationClass;
                        do {
                            applicationClass = LauncherHelper.getApplicationClass();
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        } while (applicationClass == null);
                        Agent001.stateEvent(3, applicationClass.getName().replace('.', '/') + ".main");
                    }
                });
                t.setDaemon(true);
                t.start();
                break;
            }
            case 3: {
                assert (mainMethod != null);
                if (useCRS == 0 || useCRS == 1) {
                    if (mainMethod.startsWith("com/sun/tools")) {
                        Agent001.stateEvent(-1, null);
                        break;
                    }
                    useCRS = 3;
                    Agent001.activateAgent(mainMethod);
                    break;
                }
                if (useCRS != 2) break;
                assert (startThread != null);
                useCRS = 3;
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            startThread.join();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        if (useCRS != -1) {
                            Agent001.sendMainMethodName(mainMethod);
                        }
                    }
                });
                t.setDaemon(false);
                t.start();
                break;
            }
            case -1: {
                useCRS = -1;
                vmSupport.disableCRS();
                break;
            }
            default: {
                throw new InternalError("Unhandled state");
            }
        }
    }

    private static void activateAgent(final String mainMethod) {
        final long startTime = System.currentTimeMillis();
        final long startTimeStamp = Utils.currentTimeCount();
        if (logger.isEnabled(Logger.Level.DEBUG)) {
            logger.debug("CRS agent started. VM uptime %dms", ManagementFactory.getRuntimeMXBean().getUptime());
        }
        startThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Agent001.addShutdownHook(startTimeStamp);
                VMCRSCapabilities capabilities = VMCRSCapabilities.init();
                try {
                    client = new Client(Agent001.getClientProps(), new Client.ClientListener(){

                        @Override
                        public void authenticated() {
                            if (client.getVmId() != null) {
                                logger.info("Agent authenticated: vmId=%s", client.getVmId());
                                if (logger.isEnabled(Logger.Level.DEBUG)) {
                                    logger.debug(" VM uptime %dms", ManagementFactory.getRuntimeMXBean().getUptime());
                                }
                                if (!connectionEstablished) {
                                    client.connectionEstablished();
                                }
                                connectionEstablished = true;
                            } else {
                                Agent001.disableCRS("Backend malfunction, invalid vmId received", null);
                            }
                        }

                        @Override
                        public void syncFailed(Result<String[]> reason) {
                            logger.error("Data synchronization to the CRS cloud has failed: %s", reason.errorString());
                        }
                    });
                    jfrMonitor = JFRMonitor.getInstance(client, Options.lifetimejfr.get());
                    jfrMonitor.start();
                    Agent001.postVMStart(startTime, mainMethod);
                    heartbeatService = HeartbeatService.getInstance(client);
                    crslogMonitor.setClient(client);
                    if (capabilities.has(VMCRSCapability.POST_VM_LOG_EVENTS)) {
                        vmlogMonitor = VMLogMonitor.getInstance(client);
                    } else {
                        gclogMonitor = GCLogMonitor.getInstance(client, startTime);
                    }
                    if (capabilities.has(VMCRSCapability.POST_CLASS_LOAD_EVENTS)) {
                        classLoadMonitor = ClassLoadMonitor.getInstance(client);
                    }
                    if (capabilities.has(VMCRSCapability.POST_FIRST_CALL_EVENTS)) {
                        firstCallMonitor = FirstCallMonitor.getInstance(client);
                    }
                    client.startup();
                    Agent001.startServices(new ClientService[]{crslogMonitor, heartbeatService, vmlogMonitor, gclogMonitor, classLoadMonitor, firstCallMonitor});
                    flushThread = new Thread(Agent001::flushThreadMain);
                    flushThread.setDaemon(true);
                    flushThread.setName("CRSEventFlush");
                    flushThread.start();
                    Agent001.sendNetworkInformation();
                }
                catch (Exception e) {
                    Agent001.disableCRS("CRS failed to start: %s", e);
                }
            }
        });
        startThread.setDaemon(delayShutdown == 0L);
        startThread.setName("CRSStartThread");
        startThread.start();
    }

    private static void startServices(ClientService ... services) {
        for (ClientService service : services) {
            if (service == null) continue;
            try {
                service.start();
            }
            catch (Exception ex) {
                logger.error("Agent failed to start " + service.serviceName() + ". Data is discarded", new Object[0]);
            }
        }
    }

    private static void stopServices(long shutdownDeadline, ClientService ... services) {
        for (ClientService service : services) {
            if (service == null) continue;
            try {
                service.stop(shutdownDeadline);
            }
            catch (Exception ex) {
                logger.error("Agent failed to stop " + service.serviceName() + ". Data is discarded", new Object[0]);
            }
        }
    }

    private static void disableCRS(String cause, Exception ex) {
        if (client != null) {
            client.cancel();
        }
        useCRS = -1;
        logger.error(cause, ex);
        if (ex.getCause() != null) {
            logger.trace("caused by: %s", ex.getCause());
        }
    }

    private static Map<Client.ClientProp, Object> getClientProps() throws CRSException {
        boolean hasMailboxConfig;
        Map<Client.ClientProp, Object> clientProps = Options.getClientProps();
        boolean hasEndpointConfig = clientProps.get((Object)Client.ClientProp.API_URL) != null;
        boolean bl = hasMailboxConfig = clientProps.get((Object)Client.ClientProp.API_MAILBOX) != null;
        if (!hasEndpointConfig || !hasMailboxConfig) {
            try {
                DnsDetect detector = new DnsDetect(Options.stackRecordId.get());
                Logger.getLogger(ConnectionManager.class).info("querying DNS record%s", detector.getRecordNamePostfix().length() > 0 ? " (postfix " + detector.getRecordNamePostfix() + ")" : "");
                if (!hasEndpointConfig) {
                    clientProps.put(Client.ClientProp.API_URL, "https://" + detector.queryEndpoint());
                }
                if (!hasMailboxConfig) {
                    clientProps.put(Client.ClientProp.API_MAILBOX, detector.queryMailbox());
                }
            }
            catch (IOException ex) {
                throw new CRSException(-1, "DNS query error and not enough configuration supplied", ex);
            }
        }
        clientProps.put(Client.ClientProp.VM_SHUTDOWN_DELAY, delayShutdown);
        return clientProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void flushThreadMain() {
        long previousForceFlushTime = Utils.currentTimeCount();
        while (true) {
            boolean forceFlush;
            Object object = flushThreadLock;
            synchronized (object) {
                try {
                    flushThreadLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            if (flushThreadStop) break;
            boolean bl = forceFlush = Utils.elapsedTimeMillis(previousForceFlushTime) >= (long)forceFlushTimeout;
            if (forceFlush) {
                previousForceFlushTime = Utils.currentTimeCount();
            }
            vmSupport.drainQueues(forceFlush, false);
        }
        vmSupport.drainQueues(true, true);
    }

    public static void notifyToJavaCall(String name) {
        if (useCRS != 0 && useCRS != 2) {
            vmSupport.enableEventNotifications(VMSupport.CrsNotificationType.EVENT_TO_JAVA_CALL, false);
            return;
        }
        if (name.startsWith("sun/launcher/LauncherHelper.checkAndLoadMain")) {
            launcherDetected = true;
            Agent001.stateEvent(1, null);
        } else if (!launcherDetected) {
            if (name.startsWith("java/lang/Thread") || name.startsWith("sun/launcher") || name.startsWith("java/") || name.startsWith("javax/") || name.startsWith("sun/") || name.startsWith("com/sun/") || name.startsWith("com/fasterxml") || name.startsWith("org/jcp") || name.startsWith("com/azul/crs") || name.startsWith("jdk/jfr")) {
                return;
            }
            Agent001.stateEvent(3, name);
        }
    }

    public static void notifyFirstCall(int classId, String name) {
        firstCallMonitor.notifyMethodFirstCalled(classId, name);
    }

    public static void notifyClassLoad(String className, byte[] hash, int classId, int loaderId, String source) {
        classLoadMonitor.notifyClassLoad(className, hash, classId, loaderId, source);
    }

    public static void notifyVMLogEntry(String logName, String entry) {
        vmlogMonitor.notifyVMLogEntry(logName, entry);
    }

    static {
        useCRS = 0;
        flushThreadLock = new Object();
        forceFlushTimeout = 1800000;
        delayShutdown = 120000L;
        logger = Logger.getLogger(Agent001.class);
        crslogMonitor = new CRSLogMonitor();
        Logger.addOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                crslogMonitor.notifyCRSLogEntry(b, off, len);
            }
        });
        vmSupport = null;
    }

    private static final class VMCRSCapabilities {
        private final Set<VMCRSCapability> capabilities;

        private VMCRSCapabilities(Set<VMCRSCapability> vmcrsCapabilities) {
            this.capabilities = Collections.unmodifiableSet(vmcrsCapabilities);
            logger.trace("Active VMCRSCapabilities: " + this.capabilities, new Object[0]);
        }

        boolean has(VMCRSCapability cap) {
            return this.capabilities.contains((Object)cap);
        }

        static VMCRSCapabilities init() {
            String[] reported = vmSupport.getVMCRSCapabilities();
            if (reported != null) {
                HashSet<VMCRSCapability> active = new HashSet<VMCRSCapability>();
                for (String vmcrsCapability : reported) {
                    try {
                        active.add(VMCRSCapability.valueOf(vmcrsCapability));
                    }
                    catch (IllegalArgumentException e) {
                        logger.trace("VM reported unknown capability: " + vmcrsCapability, new Object[0]);
                    }
                }
                return new VMCRSCapabilities(active);
            }
            return new VMCRSCapabilities(new HashSet<VMCRSCapability>(Arrays.asList(VMCRSCapability.POST_CLASS_LOAD_EVENTS, VMCRSCapability.POST_FIRST_CALL_EVENTS, VMCRSCapability.POST_NOTIFY_TO_JAVA_CALLS)));
        }
    }

    private static enum VMCRSCapability {
        POST_CLASS_LOAD_EVENTS,
        POST_FIRST_CALL_EVENTS,
        POST_NOTIFY_TO_JAVA_CALLS,
        POST_VM_LOG_EVENTS;

    }
}

