/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLPeerUnverifiedException;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ClientHello;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HKDF;
import sun.security.ssl.HandshakeAbsence;
import sun.security.ssl.HandshakeConsumer;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.Record;
import sun.security.ssl.SSLEngineOutputRecord;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLSecretDerivation;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.Utilities;

final class PreSharedKeyExtension {
    static final HandshakeProducer chNetworkProducer = new CHPreSharedKeyProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHPreSharedKeyConsumer();
    static final HandshakeAbsence chOnLoadAbsence = new CHPreSharedKeyOnLoadAbsence();
    static final HandshakeConsumer chOnTradeConsumer = new CHPreSharedKeyUpdate();
    static final HandshakeAbsence chOnTradAbsence = new CHPreSharedKeyOnTradeAbsence();
    static final SSLStringizer chStringizer = new CHPreSharedKeyStringizer();
    static final HandshakeProducer shNetworkProducer = new SHPreSharedKeyProducer();
    static final SSLExtension.ExtensionConsumer shOnLoadConsumer = new SHPreSharedKeyConsumer();
    static final HandshakeAbsence shOnLoadAbsence = new SHPreSharedKeyAbsence();
    static final SSLStringizer shStringizer = new SHPreSharedKeyStringizer();

    PreSharedKeyExtension() {
    }

    private static boolean canRejoin(ClientHello.ClientHelloMessage clientHelloMessage, ServerHandshakeContext serverHandshakeContext, SSLSessionImpl sSLSessionImpl) {
        String string;
        Object object;
        boolean bl;
        boolean bl2 = bl = sSLSessionImpl.isRejoinable() && sSLSessionImpl.getPreSharedKey() != null;
        if (bl && sSLSessionImpl.getProtocolVersion() != serverHandshakeContext.negotiatedProtocol) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                SSLLogger.finest("Can't resume, incorrect protocol version", new Object[0]);
            }
            bl = false;
        }
        if (serverHandshakeContext.localSupportedSignAlgs == null) {
            serverHandshakeContext.localSupportedSignAlgs = SignatureScheme.getSupportedAlgorithms(serverHandshakeContext.sslConfig, serverHandshakeContext.algorithmConstraints, serverHandshakeContext.activeProtocols);
        }
        if (bl && serverHandshakeContext.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED) {
            try {
                sSLSessionImpl.getPeerPrincipal();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                    SSLLogger.finest("Can't resume, client authentication is required", new Object[0]);
                }
                bl = false;
            }
            object = sSLSessionImpl.getLocalSupportedSignatureSchemes();
            if (bl && !serverHandshakeContext.localSupportedSignAlgs.containsAll((Collection<?>)object)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Can't resume. Session uses different signature algorithms", new Object[0]);
                }
                bl = false;
            }
        }
        object = serverHandshakeContext.sslConfig.identificationProtocol;
        if (bl && object != null && !((String)object).equalsIgnoreCase(string = sSLSessionImpl.getIdentificationProtocol())) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                SSLLogger.finest("Can't resume, endpoint id algorithm does not match, requested: " + (String)object + ", cached: " + string, new Object[0]);
            }
            bl = false;
        }
        if (!(!bl || serverHandshakeContext.isNegotiable(sSLSessionImpl.getSuite()) && clientHelloMessage.cipherSuites.contains((Object)sSLSessionImpl.getSuite()))) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                SSLLogger.finest("Can't resume, unavailable session cipher suite", new Object[0]);
            }
            bl = false;
        }
        return bl;
    }

    private static void checkBinder(ServerHandshakeContext serverHandshakeContext, SSLSessionImpl sSLSessionImpl, HandshakeHash handshakeHash, byte[] byArray) throws IOException {
        SecretKey secretKey = sSLSessionImpl.getPreSharedKey();
        if (secretKey == null) {
            throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Session has no PSK");
        }
        SecretKey secretKey2 = PreSharedKeyExtension.deriveBinderKey(serverHandshakeContext, secretKey, sSLSessionImpl);
        byte[] byArray2 = PreSharedKeyExtension.computeBinder((HandshakeContext)serverHandshakeContext, secretKey2, sSLSessionImpl, handshakeHash);
        if (!Arrays.equals(byArray, byArray2)) {
            throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Incorect PSK binder value");
        }
    }

    private static byte[] computeBinder(HandshakeContext handshakeContext, SecretKey secretKey, SSLSessionImpl sSLSessionImpl, HandshakeHash handshakeHash) throws IOException {
        handshakeHash.determine(sSLSessionImpl.getProtocolVersion(), sSLSessionImpl.getSuite());
        handshakeHash.update();
        byte[] byArray = handshakeHash.digest();
        return PreSharedKeyExtension.computeBinder(handshakeContext, secretKey, sSLSessionImpl, byArray);
    }

    private static byte[] computeBinder(HandshakeContext handshakeContext, SecretKey secretKey, HandshakeHash handshakeHash, SSLSessionImpl sSLSessionImpl, HandshakeContext handshakeContext2, ClientHello.ClientHelloMessage clientHelloMessage, CHPreSharedKeySpec cHPreSharedKeySpec) throws IOException {
        PartialClientHelloMessage partialClientHelloMessage = new PartialClientHelloMessage(handshakeContext2, clientHelloMessage, cHPreSharedKeySpec);
        SSLEngineOutputRecord sSLEngineOutputRecord = new SSLEngineOutputRecord(handshakeHash);
        HandshakeOutStream handshakeOutStream = new HandshakeOutStream(sSLEngineOutputRecord);
        partialClientHelloMessage.write(handshakeOutStream);
        handshakeHash.determine(sSLSessionImpl.getProtocolVersion(), sSLSessionImpl.getSuite());
        handshakeHash.update();
        byte[] byArray = handshakeHash.digest();
        return PreSharedKeyExtension.computeBinder(handshakeContext, secretKey, sSLSessionImpl, byArray);
    }

    private static byte[] computeBinder(HandshakeContext handshakeContext, SecretKey secretKey, SSLSessionImpl sSLSessionImpl, byte[] byArray) throws IOException {
        try {
            CipherSuite.HashAlg hashAlg = sSLSessionImpl.getSuite().hashAlg;
            HKDF hKDF = new HKDF(hashAlg.name);
            byte[] byArray2 = "tls13 finished".getBytes();
            byte[] byArray3 = SSLSecretDerivation.createHkdfInfo(byArray2, new byte[0], hashAlg.hashLength);
            SecretKey secretKey2 = hKDF.expand(secretKey, byArray3, hashAlg.hashLength, "TlsBinderKey");
            String string = "Hmac" + hashAlg.name.replace("-", "");
            try {
                Mac mac = JsseJce.getMac(string);
                mac.init(secretKey2);
                return mac.doFinal(byArray);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                throw handshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, generalSecurityException);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw handshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, generalSecurityException);
        }
    }

    private static SecretKey deriveBinderKey(HandshakeContext handshakeContext, SecretKey secretKey, SSLSessionImpl sSLSessionImpl) throws IOException {
        try {
            CipherSuite.HashAlg hashAlg = sSLSessionImpl.getSuite().hashAlg;
            HKDF hKDF = new HKDF(hashAlg.name);
            byte[] byArray = new byte[hashAlg.hashLength];
            SecretKey secretKey2 = hKDF.extract(byArray, secretKey, "TlsEarlySecret");
            byte[] byArray2 = "tls13 res binder".getBytes();
            MessageDigest messageDigest = MessageDigest.getInstance(hashAlg.name);
            byte[] byArray3 = SSLSecretDerivation.createHkdfInfo(byArray2, messageDigest.digest(new byte[0]), hashAlg.hashLength);
            return hKDF.expand(secretKey2, byArray3, hashAlg.hashLength, "TlsBinderKey");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw handshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, generalSecurityException);
        }
    }

    private static final class SHPreSharedKeyProducer
    implements HandshakeProducer {
        private SHPreSharedKeyProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            SHPreSharedKeySpec sHPreSharedKeySpec = (SHPreSharedKeySpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.SH_PRE_SHARED_KEY);
            if (sHPreSharedKeySpec == null) {
                return null;
            }
            return sHPreSharedKeySpec.getEncoded();
        }
    }

    private static final class SHPreSharedKeyAbsence
    implements HandshakeAbsence {
        private SHPreSharedKeyAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Handling pre_shared_key absence.", new Object[0]);
            }
            clientHandshakeContext.resumingSession = null;
            clientHandshakeContext.isResumption = false;
        }
    }

    private static final class SHPreSharedKeyConsumer
    implements SSLExtension.ExtensionConsumer {
        private SHPreSharedKeyConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.handshakeExtensions.containsKey(SSLExtension.CH_PRE_SHARED_KEY)) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Server sent unexpected pre_shared_key extension");
            }
            SHPreSharedKeySpec sHPreSharedKeySpec = new SHPreSharedKeySpec(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Received pre_shared_key extension: ", sHPreSharedKeySpec);
            }
            if (sHPreSharedKeySpec.selectedIdentity != 0) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Selected identity index is not in correct range.");
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Resuming session: ", clientHandshakeContext.resumingSession);
            }
        }
    }

    private static final class CHPreSharedKeyOnTradeAbsence
    implements HandshakeAbsence {
        private CHPreSharedKeyOnTradeAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!(!serverHandshakeContext.negotiatedProtocol.useTLS13PlusSpec() || serverHandshakeContext.handshakeExtensions.containsKey(SSLExtension.CH_SIGNATURE_ALGORITHMS) && serverHandshakeContext.handshakeExtensions.containsKey(SSLExtension.CH_SUPPORTED_GROUPS))) {
                throw serverHandshakeContext.conContext.fatal(Alert.MISSING_EXTENSION, "No supported_groups or signature_algorithms extension when pre_shared_key extension is not present");
            }
        }
    }

    private static final class CHPreSharedKeyOnLoadAbsence
    implements HandshakeAbsence {
        private CHPreSharedKeyOnLoadAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Handling pre_shared_key absence.", new Object[0]);
            }
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            serverHandshakeContext.resumingSession = null;
            serverHandshakeContext.isResumption = false;
        }
    }

    private static final class CHPreSharedKeyProducer
    implements HandshakeProducer {
        private CHPreSharedKeyProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.isResumption || clientHandshakeContext.resumingSession == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("No session to resume.", new Object[0]);
                }
                return null;
            }
            Collection<SignatureScheme> collection = clientHandshakeContext.resumingSession.getLocalSupportedSignatureSchemes();
            if (!clientHandshakeContext.localSupportedSignAlgs.containsAll(collection)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Existing session uses different signature algorithms", new Object[0]);
                }
                return null;
            }
            SecretKey secretKey = clientHandshakeContext.resumingSession.getPreSharedKey();
            if (secretKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Existing session has no PSK.", new Object[0]);
                }
                return null;
            }
            if (clientHandshakeContext.pskIdentity == null) {
                clientHandshakeContext.pskIdentity = clientHandshakeContext.resumingSession.consumePskIdentity();
            }
            if (clientHandshakeContext.pskIdentity == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("PSK has no identity, or identity was already used", new Object[0]);
                }
                return null;
            }
            SSLSessionContextImpl sSLSessionContextImpl = (SSLSessionContextImpl)clientHandshakeContext.sslContext.engineGetClientSessionContext();
            sSLSessionContextImpl.remove(clientHandshakeContext.resumingSession.getSessionId());
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Found resumable session. Preparing PSK message.", new Object[0]);
            }
            ArrayList<PskIdentity> arrayList = new ArrayList<PskIdentity>();
            int n = (int)(System.currentTimeMillis() - clientHandshakeContext.resumingSession.getTicketCreationTime());
            int n2 = n + clientHandshakeContext.resumingSession.getTicketAgeAdd();
            arrayList.add(new PskIdentity(clientHandshakeContext.pskIdentity, n2));
            SecretKey secretKey2 = PreSharedKeyExtension.deriveBinderKey(clientHandshakeContext, secretKey, clientHandshakeContext.resumingSession);
            ClientHello.ClientHelloMessage clientHelloMessage = (ClientHello.ClientHelloMessage)handshakeMessage;
            CHPreSharedKeySpec cHPreSharedKeySpec = this.createPskPrototype(clientHandshakeContext.resumingSession.getSuite().hashAlg.hashLength, arrayList);
            HandshakeHash handshakeHash = clientHandshakeContext.handshakeHash.copy();
            byte[] byArray = PreSharedKeyExtension.computeBinder(clientHandshakeContext, secretKey2, handshakeHash, clientHandshakeContext.resumingSession, clientHandshakeContext, clientHelloMessage, cHPreSharedKeySpec);
            ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
            arrayList2.add(byArray);
            CHPreSharedKeySpec cHPreSharedKeySpec2 = new CHPreSharedKeySpec(arrayList, arrayList2);
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_PRE_SHARED_KEY, cHPreSharedKeySpec2);
            return cHPreSharedKeySpec2.getEncoded();
        }

        private CHPreSharedKeySpec createPskPrototype(int n, List<PskIdentity> list) {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            byte[] byArray = new byte[n];
            for (PskIdentity pskIdentity : list) {
                arrayList.add(byArray);
            }
            return new CHPreSharedKeySpec(list, arrayList);
        }
    }

    static final class PartialClientHelloMessage
    extends SSLHandshake.HandshakeMessage {
        private final ClientHello.ClientHelloMessage msg;
        private final CHPreSharedKeySpec psk;

        PartialClientHelloMessage(HandshakeContext handshakeContext, ClientHello.ClientHelloMessage clientHelloMessage, CHPreSharedKeySpec cHPreSharedKeySpec) {
            super(handshakeContext);
            this.msg = clientHelloMessage;
            this.psk = cHPreSharedKeySpec;
        }

        @Override
        SSLHandshake handshakeType() {
            return this.msg.handshakeType();
        }

        private int pskTotalLength() {
            return this.psk.getIdsEncodedLength() + this.psk.getBindersEncodedLength() + 8;
        }

        @Override
        int messageLength() {
            if (this.msg.extensions.get(SSLExtension.CH_PRE_SHARED_KEY) != null) {
                return this.msg.messageLength();
            }
            return this.msg.messageLength() + this.pskTotalLength();
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            this.msg.sendCore(handshakeOutStream);
            int n = this.msg.extensions.length();
            if (this.msg.extensions.get(SSLExtension.CH_PRE_SHARED_KEY) == null) {
                n += this.pskTotalLength();
            }
            handshakeOutStream.putInt16(n - 2);
            for (SSLExtension sSLExtension : SSLExtension.values()) {
                byte[] byArray = this.msg.extensions.get(sSLExtension);
                if (byArray == null || sSLExtension == SSLExtension.CH_PRE_SHARED_KEY) continue;
                int n2 = sSLExtension.id;
                handshakeOutStream.putInt16(n2);
                handshakeOutStream.putBytes16(byArray);
            }
            int n3 = SSLExtension.CH_PRE_SHARED_KEY.id;
            handshakeOutStream.putInt16(n3);
            byte[] byArray = this.psk.getEncoded();
            handshakeOutStream.putInt16(byArray.length);
            handshakeOutStream.write(byArray, 0, this.psk.getIdsEncodedLength() + 2);
        }
    }

    private static final class CHPreSharedKeyUpdate
    implements HandshakeConsumer {
        private CHPreSharedKeyUpdate() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.isResumption || serverHandshakeContext.resumingSession == null) {
                return;
            }
            CHPreSharedKeySpec cHPreSharedKeySpec = (CHPreSharedKeySpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_PRE_SHARED_KEY);
            SHPreSharedKeySpec sHPreSharedKeySpec = (SHPreSharedKeySpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.SH_PRE_SHARED_KEY);
            if (cHPreSharedKeySpec == null || sHPreSharedKeySpec == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Required extensions are unavailable");
            }
            byte[] byArray = cHPreSharedKeySpec.binders.get(sHPreSharedKeySpec.selectedIdentity);
            HandshakeHash handshakeHash = serverHandshakeContext.handshakeHash.copy();
            byte[] byArray2 = handshakeHash.removeLastReceived();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            byteBuffer.position(4);
            ClientHello.ClientHelloMessage.readPartial(serverHandshakeContext.conContext, byteBuffer);
            int n = byteBuffer.position();
            byteBuffer.position(0);
            handshakeHash.receive(byteBuffer, n);
            PreSharedKeyExtension.checkBinder(serverHandshakeContext, serverHandshakeContext.resumingSession, handshakeHash, byArray);
        }
    }

    private static final class CHPreSharedKeyConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHPreSharedKeyConsumer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            ClientHello.ClientHelloMessage clientHelloMessage = (ClientHello.ClientHelloMessage)handshakeMessage;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_PRE_SHARED_KEY)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable pre_shared_key extension", new Object[0]);
                }
                return;
            }
            CHPreSharedKeySpec cHPreSharedKeySpec = null;
            try {
                cHPreSharedKeySpec = new CHPreSharedKeySpec(serverHandshakeContext, byteBuffer);
            }
            catch (IOException iOException) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
            }
            if (!serverHandshakeContext.handshakeExtensions.containsKey(SSLExtension.PSK_KEY_EXCHANGE_MODES)) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Client sent PSK but not PSK modes, or the PSK extension is not the last extension");
            }
            if (cHPreSharedKeySpec.identities.size() != cHPreSharedKeySpec.binders.size()) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "PSK extension has incorrect number of binders");
            }
            if (serverHandshakeContext.isResumption) {
                SSLSessionContextImpl sSLSessionContextImpl = (SSLSessionContextImpl)serverHandshakeContext.sslContext.engineGetServerSessionContext();
                int n = 0;
                for (PskIdentity pskIdentity : cHPreSharedKeySpec.identities) {
                    SSLSessionImpl sSLSessionImpl = null;
                    SSLSessionContextImpl sSLSessionContextImpl2 = sSLSessionContextImpl;
                    synchronized (sSLSessionContextImpl2) {
                        sSLSessionImpl = sSLSessionContextImpl.get(pskIdentity.identity);
                        if (sSLSessionImpl != null && PreSharedKeyExtension.canRejoin(clientHelloMessage, serverHandshakeContext, sSLSessionImpl)) {
                            sSLSessionContextImpl.remove(sSLSessionImpl.getSessionId());
                        } else {
                            sSLSessionImpl = null;
                        }
                    }
                    if (sSLSessionImpl != null) {
                        if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                            SSLLogger.fine("Resuming session: ", sSLSessionImpl);
                        }
                        serverHandshakeContext.resumingSession = sSLSessionImpl;
                        serverHandshakeContext.handshakeExtensions.put(SSLExtension.SH_PRE_SHARED_KEY, new SHPreSharedKeySpec(n));
                        break;
                    }
                    ++n;
                }
                if (n == cHPreSharedKeySpec.identities.size()) {
                    serverHandshakeContext.isResumption = false;
                    serverHandshakeContext.resumingSession = null;
                }
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_PRE_SHARED_KEY, cHPreSharedKeySpec);
        }
    }

    private static final class SHPreSharedKeyStringizer
    implements SSLStringizer {
        private SHPreSharedKeyStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new SHPreSharedKeySpec(null, byteBuffer).toString();
            }
            catch (Exception exception) {
                return exception.getMessage();
            }
        }
    }

    private static final class SHPreSharedKeySpec
    implements SSLExtension.SSLExtensionSpec {
        final int selectedIdentity;

        SHPreSharedKeySpec(int n) {
            this.selectedIdentity = n;
        }

        SHPreSharedKeySpec(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() < 2) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid pre_shared_key extension: insufficient selected_identity (length=" + byteBuffer.remaining() + ")");
            }
            this.selectedIdentity = Record.getInt16(byteBuffer);
        }

        byte[] getEncoded() throws IOException {
            return new byte[]{(byte)(this.selectedIdentity >> 8 & 0xFF), (byte)(this.selectedIdentity & 0xFF)};
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"PreSharedKey\": '{'\n  \"selected_identity\"      : \"{0}\",\n'}'", Locale.ENGLISH);
            Object[] objectArray = new Object[]{Utilities.byte16HexString(this.selectedIdentity)};
            return messageFormat.format(objectArray);
        }
    }

    private static final class CHPreSharedKeyStringizer
    implements SSLStringizer {
        private CHPreSharedKeyStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new CHPreSharedKeySpec(null, byteBuffer).toString();
            }
            catch (Exception exception) {
                return exception.getMessage();
            }
        }
    }

    private static final class CHPreSharedKeySpec
    implements SSLExtension.SSLExtensionSpec {
        final List<PskIdentity> identities;
        final List<byte[]> binders;

        CHPreSharedKeySpec(List<PskIdentity> list, List<byte[]> list2) {
            this.identities = list;
            this.binders = list2;
        }

        CHPreSharedKeySpec(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            int n;
            Object object;
            if (byteBuffer.remaining() < 44) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid pre_shared_key extension: insufficient data (length=" + byteBuffer.remaining() + ")");
            }
            int n2 = Record.getInt16(byteBuffer);
            if (n2 < 7) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid pre_shared_key extension: insufficient identities (length=" + n2 + ")");
            }
            this.identities = new ArrayList<PskIdentity>();
            for (int i = 0; i < n2; i += ((PskIdentity)object).getEncodedLength()) {
                byte[] byArray = Record.getBytes16(byteBuffer);
                if (byArray.length < 1) {
                    throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid pre_shared_key extension: insufficient identity (length=" + byArray.length + ")");
                }
                n = Record.getInt32(byteBuffer);
                object = new PskIdentity(byArray, n);
                this.identities.add((PskIdentity)object);
            }
            if (byteBuffer.remaining() < 35) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid pre_shared_key extension: insufficient binders data (length=" + byteBuffer.remaining() + ")");
            }
            int n3 = Record.getInt16(byteBuffer);
            if (n3 < 33) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid pre_shared_key extension: insufficient binders (length=" + n3 + ")");
            }
            this.binders = new ArrayList<byte[]>();
            for (n = 0; n < n3; n += 1 + ((Object)object).length) {
                object = Record.getBytes8(byteBuffer);
                if (((Object)object).length < 32) {
                    throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Invalid pre_shared_key extension: insufficient binder entry (length=" + ((Object)object).length + ")");
                }
                this.binders.add((byte[])object);
            }
        }

        int getIdsEncodedLength() {
            int n = 0;
            for (PskIdentity pskIdentity : this.identities) {
                n += pskIdentity.getEncodedLength();
            }
            return n;
        }

        int getBindersEncodedLength() {
            int n = 0;
            for (byte[] byArray : this.binders) {
                n += 1 + byArray.length;
            }
            return n;
        }

        byte[] getEncoded() throws IOException {
            int n = this.getIdsEncodedLength();
            int n2 = this.getBindersEncodedLength();
            int n3 = 4 + n + n2;
            byte[] byArray = new byte[n3];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Record.putInt16(byteBuffer, n);
            for (PskIdentity object : this.identities) {
                object.writeEncoded(byteBuffer);
            }
            Record.putInt16(byteBuffer, n2);
            for (byte[] byArray2 : this.binders) {
                Record.putBytes8(byteBuffer, byArray2);
            }
            return byArray;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"PreSharedKey\": '{'\n  \"identities\"    : \"{0}\",\n  \"binders\"       : \"{1}\",\n'}'", Locale.ENGLISH);
            Object[] objectArray = new Object[]{Utilities.indent(this.identitiesString()), Utilities.indent(this.bindersString())};
            return messageFormat.format(objectArray);
        }

        String identitiesString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (PskIdentity pskIdentity : this.identities) {
                stringBuilder.append(pskIdentity.toString() + "\n");
            }
            return stringBuilder.toString();
        }

        String bindersString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (byte[] byArray : this.binders) {
                stringBuilder.append("{" + Utilities.toHexString(byArray) + "}\n");
            }
            return stringBuilder.toString();
        }
    }

    private static final class PskIdentity {
        final byte[] identity;
        final int obfuscatedAge;

        PskIdentity(byte[] byArray, int n) {
            this.identity = byArray;
            this.obfuscatedAge = n;
        }

        int getEncodedLength() {
            return 2 + this.identity.length + 4;
        }

        void writeEncoded(ByteBuffer byteBuffer) throws IOException {
            Record.putBytes16(byteBuffer, this.identity);
            Record.putInt32(byteBuffer, this.obfuscatedAge);
        }

        public String toString() {
            return "{" + Utilities.toHexString(this.identity) + "," + this.obfuscatedAge + "}";
        }
    }
}

