/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.openjsse.sun.security.ssl.CipherSuite;
import org.openjsse.sun.security.ssl.SSLContextImpl;
import org.openjsse.sun.security.ssl.SSLServerSocketImpl;

public final class SSLServerSocketFactoryImpl
extends SSLServerSocketFactory {
    private static final int DEFAULT_BACKLOG = 50;
    private final SSLContextImpl context;

    public SSLServerSocketFactoryImpl() throws Exception {
        this.context = SSLContextImpl.DefaultSSLContext.getDefaultImpl();
    }

    SSLServerSocketFactoryImpl(SSLContextImpl context) {
        this.context = context;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return new SSLServerSocketImpl(this.context);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return new SSLServerSocketImpl(this.context, port, 50);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return new SSLServerSocketImpl(this.context, port, backlog);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        return new SSLServerSocketImpl(this.context, port, backlog, ifAddress);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return CipherSuite.namesOf(this.context.getDefaultCipherSuites(true));
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return CipherSuite.namesOf(this.context.getSupportedCipherSuites());
    }
}

