/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.ssl;

import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import org.openjsse.javax.net.ssl.SSLSocket;
import org.openjsse.sun.security.ssl.HandshakeContext;
import org.openjsse.sun.security.ssl.SSLAlgorithmDecomposer;
import org.openjsse.sun.security.ssl.SSLEngineImpl;
import org.openjsse.sun.security.ssl.SSLSocketImpl;
import sun.security.util.DisabledAlgorithmConstraints;

final class SSLAlgorithmConstraints
implements AlgorithmConstraints {
    private static final AlgorithmConstraints tlsDisabledAlgConstraints = new DisabledAlgorithmConstraints("jdk.tls.disabledAlgorithms", new SSLAlgorithmDecomposer());
    private static final AlgorithmConstraints x509DisabledAlgConstraints = new DisabledAlgorithmConstraints("jdk.certpath.disabledAlgorithms", new SSLAlgorithmDecomposer(true));
    private final AlgorithmConstraints userSpecifiedConstraints;
    private final AlgorithmConstraints peerSpecifiedConstraints;
    private final boolean enabledX509DisabledAlgConstraints;
    static final AlgorithmConstraints DEFAULT = new SSLAlgorithmConstraints(null);
    static final AlgorithmConstraints DEFAULT_SSL_ONLY = new SSLAlgorithmConstraints((SSLSocket)null, false);

    SSLAlgorithmConstraints(AlgorithmConstraints userSpecifiedConstraints) {
        this.userSpecifiedConstraints = userSpecifiedConstraints;
        this.peerSpecifiedConstraints = null;
        this.enabledX509DisabledAlgConstraints = true;
    }

    SSLAlgorithmConstraints(SSLSocket socket, boolean withDefaultCertPathConstraints) {
        this.userSpecifiedConstraints = SSLAlgorithmConstraints.getUserSpecifiedConstraints(socket);
        this.peerSpecifiedConstraints = null;
        this.enabledX509DisabledAlgConstraints = withDefaultCertPathConstraints;
    }

    SSLAlgorithmConstraints(SSLEngine engine, boolean withDefaultCertPathConstraints) {
        this.userSpecifiedConstraints = SSLAlgorithmConstraints.getUserSpecifiedConstraints(engine);
        this.peerSpecifiedConstraints = null;
        this.enabledX509DisabledAlgConstraints = withDefaultCertPathConstraints;
    }

    SSLAlgorithmConstraints(SSLSocket socket, String[] supportedAlgorithms, boolean withDefaultCertPathConstraints) {
        this.userSpecifiedConstraints = SSLAlgorithmConstraints.getUserSpecifiedConstraints(socket);
        this.peerSpecifiedConstraints = new SupportedSignatureAlgorithmConstraints(supportedAlgorithms);
        this.enabledX509DisabledAlgConstraints = withDefaultCertPathConstraints;
    }

    SSLAlgorithmConstraints(SSLEngine engine, String[] supportedAlgorithms, boolean withDefaultCertPathConstraints) {
        this.userSpecifiedConstraints = SSLAlgorithmConstraints.getUserSpecifiedConstraints(engine);
        this.peerSpecifiedConstraints = new SupportedSignatureAlgorithmConstraints(supportedAlgorithms);
        this.enabledX509DisabledAlgConstraints = withDefaultCertPathConstraints;
    }

    private static AlgorithmConstraints getUserSpecifiedConstraints(SSLEngine engine) {
        if (engine != null) {
            HandshakeContext hc;
            if (engine instanceof SSLEngineImpl && (hc = ((SSLEngineImpl)engine).conContext.handshakeContext) != null) {
                return hc.sslConfig.userSpecifiedAlgorithmConstraints;
            }
            return engine.getSSLParameters().getAlgorithmConstraints();
        }
        return null;
    }

    private static AlgorithmConstraints getUserSpecifiedConstraints(SSLSocket socket) {
        if (socket != null) {
            HandshakeContext hc;
            if (socket instanceof SSLSocketImpl && (hc = ((SSLSocketImpl)socket).conContext.handshakeContext) != null) {
                return hc.sslConfig.userSpecifiedAlgorithmConstraints;
            }
            return socket.getSSLParameters().getAlgorithmConstraints();
        }
        return null;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        boolean permitted = true;
        if (this.peerSpecifiedConstraints != null) {
            permitted = this.peerSpecifiedConstraints.permits(primitives, algorithm, parameters);
        }
        if (permitted && this.userSpecifiedConstraints != null) {
            permitted = this.userSpecifiedConstraints.permits(primitives, algorithm, parameters);
        }
        if (permitted) {
            permitted = tlsDisabledAlgConstraints.permits(primitives, algorithm, parameters);
        }
        if (permitted && this.enabledX509DisabledAlgConstraints) {
            permitted = x509DisabledAlgConstraints.permits(primitives, algorithm, parameters);
        }
        return permitted;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> primitives, Key key) {
        boolean permitted = true;
        if (this.peerSpecifiedConstraints != null) {
            permitted = this.peerSpecifiedConstraints.permits(primitives, key);
        }
        if (permitted && this.userSpecifiedConstraints != null) {
            permitted = this.userSpecifiedConstraints.permits(primitives, key);
        }
        if (permitted) {
            permitted = tlsDisabledAlgConstraints.permits(primitives, key);
        }
        if (permitted && this.enabledX509DisabledAlgConstraints) {
            permitted = x509DisabledAlgConstraints.permits(primitives, key);
        }
        return permitted;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        boolean permitted = true;
        if (this.peerSpecifiedConstraints != null) {
            permitted = this.peerSpecifiedConstraints.permits(primitives, algorithm, key, parameters);
        }
        if (permitted && this.userSpecifiedConstraints != null) {
            permitted = this.userSpecifiedConstraints.permits(primitives, algorithm, key, parameters);
        }
        if (permitted) {
            permitted = tlsDisabledAlgConstraints.permits(primitives, algorithm, key, parameters);
        }
        if (permitted && this.enabledX509DisabledAlgConstraints) {
            permitted = x509DisabledAlgConstraints.permits(primitives, algorithm, key, parameters);
        }
        return permitted;
    }

    private static class SupportedSignatureAlgorithmConstraints
    implements AlgorithmConstraints {
        private String[] supportedAlgorithms;

        SupportedSignatureAlgorithmConstraints(String[] supportedAlgorithms) {
            this.supportedAlgorithms = supportedAlgorithms != null ? (String[])supportedAlgorithms.clone() : null;
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
            if (algorithm == null || algorithm.length() == 0) {
                throw new IllegalArgumentException("No algorithm name specified");
            }
            if (primitives == null || primitives.isEmpty()) {
                throw new IllegalArgumentException("No cryptographic primitive specified");
            }
            if (this.supportedAlgorithms == null || this.supportedAlgorithms.length == 0) {
                return false;
            }
            int position = algorithm.indexOf("and");
            if (position > 0) {
                algorithm = algorithm.substring(0, position);
            }
            for (String supportedAlgorithm : this.supportedAlgorithms) {
                if (!algorithm.equalsIgnoreCase(supportedAlgorithm)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final boolean permits(Set<CryptoPrimitive> primitives, Key key) {
            return true;
        }

        @Override
        public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
            if (algorithm == null || algorithm.length() == 0) {
                throw new IllegalArgumentException("No algorithm name specified");
            }
            return this.permits(primitives, algorithm, parameters);
        }
    }
}

