/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.com.sun.net.ssl;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import org.openjsse.com.sun.net.ssl.KeyManagerFactorySpiWrapper;
import org.openjsse.com.sun.net.ssl.SSLContextSpiWrapper;
import org.openjsse.com.sun.net.ssl.TrustManagerFactorySpiWrapper;
import sun.security.jca.ProviderList;
import sun.security.jca.Providers;

final class SSLSecurity {
    private SSLSecurity() {
    }

    private static Provider.Service getService(String type, String alg) {
        ProviderList list = Providers.getProviderList();
        for (Provider p : list.providers()) {
            Provider.Service s = p.getService(type, alg);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object[] getImpl1(String algName, String engineType, Provider.Service service) throws NoSuchAlgorithmException {
        Class<?> implClass;
        Provider provider = service.getProvider();
        String className = service.getClassName();
        try {
            ClassLoader cl = provider.getClass().getClassLoader();
            implClass = cl == null ? Class.forName(className) : cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchAlgorithmException("Class " + className + " configured for " + engineType + " not found: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new NoSuchAlgorithmException("Class " + className + " configured for " + engineType + " cannot be accessed: " + e.getMessage());
        }
        try {
            Object obj = null;
            Class<?> typeClassJavax = Class.forName("javax.net.ssl." + engineType + "Spi");
            if (typeClassJavax != null && SSLSecurity.checkSuperclass(implClass, typeClassJavax)) {
                if (engineType.equals("SSLContext")) {
                    obj = new SSLContextSpiWrapper(algName, provider);
                } else if (engineType.equals("TrustManagerFactory")) {
                    obj = new TrustManagerFactorySpiWrapper(algName, provider);
                } else {
                    if (!engineType.equals("KeyManagerFactory")) throw new IllegalStateException("Class " + implClass.getName() + " unknown engineType wrapper:" + engineType);
                    obj = new KeyManagerFactorySpiWrapper(algName, provider);
                }
            } else {
                Class<?> typeClassCom = Class.forName("org.openjsse.com.sun.net.ssl." + engineType + "Spi");
                if (typeClassCom != null && SSLSecurity.checkSuperclass(implClass, typeClassCom)) {
                    obj = service.newInstance(null);
                }
            }
            if (obj == null) throw new NoSuchAlgorithmException("Couldn't locate correct object or wrapper: " + engineType + " " + algName);
            return new Object[]{obj, provider};
        }
        catch (ClassNotFoundException e) {
            IllegalStateException exc = new IllegalStateException("Engine Class Not Found for " + engineType);
            exc.initCause(e);
            throw exc;
        }
    }

    static Object[] getImpl(String algName, String engineType, String provName) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider.Service service;
        if (provName != null) {
            ProviderList list = Providers.getProviderList();
            Provider prov = list.getProvider(provName);
            if (prov == null) {
                throw new NoSuchProviderException("No such provider: " + provName);
            }
            service = prov.getService(engineType, algName);
        } else {
            service = SSLSecurity.getService(engineType, algName);
        }
        if (service == null) {
            throw new NoSuchAlgorithmException("Algorithm " + algName + " not available");
        }
        return SSLSecurity.getImpl1(algName, engineType, service);
    }

    static Object[] getImpl(String algName, String engineType, Provider prov) throws NoSuchAlgorithmException {
        Provider.Service service = prov.getService(engineType, algName);
        if (service == null) {
            throw new NoSuchAlgorithmException("No such algorithm: " + algName);
        }
        return SSLSecurity.getImpl1(algName, engineType, service);
    }

    private static boolean checkSuperclass(Class<?> subclass, Class<?> superclass) {
        if (subclass == null || superclass == null) {
            return false;
        }
        while (!subclass.equals(superclass)) {
            if ((subclass = subclass.getSuperclass()) != null) continue;
            return false;
        }
        return true;
    }

    static Object[] truncateArray(Object[] oldArray, Object[] newArray) {
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = oldArray[i];
        }
        return newArray;
    }
}

