/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.legacy8ujsse.sun.security.ssl;

import java.io.IOException;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.EnumSet;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import org.openjsse.legacy8ujsse.sun.security.ssl.EllipticCurvesExtension;
import org.openjsse.legacy8ujsse.sun.security.ssl.JsseJce;

final class ECDHCrypt {
    private PrivateKey privateKey;
    private ECPublicKey publicKey;

    ECDHCrypt(PrivateKey privateKey, PublicKey publicKey) {
        this.privateKey = privateKey;
        this.publicKey = (ECPublicKey)publicKey;
    }

    ECDHCrypt(int curveId, SecureRandom random) {
        try {
            KeyPairGenerator kpg = JsseJce.getKeyPairGenerator("EC");
            ECGenParameterSpec params = EllipticCurvesExtension.getECGenParamSpec(curveId);
            kpg.initialize(params, random);
            KeyPair kp = kpg.generateKeyPair();
            this.privateKey = kp.getPrivate();
            this.publicKey = (ECPublicKey)kp.getPublic();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not generate DH keypair", e);
        }
    }

    ECDHCrypt(ECParameterSpec params, SecureRandom random) {
        try {
            KeyPairGenerator kpg = JsseJce.getKeyPairGenerator("EC");
            kpg.initialize(params, random);
            KeyPair kp = kpg.generateKeyPair();
            this.privateKey = kp.getPrivate();
            this.publicKey = (ECPublicKey)kp.getPublic();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not generate DH keypair", e);
        }
    }

    PublicKey getPublicKey() {
        return this.publicKey;
    }

    SecretKey getAgreedSecret(PublicKey peerPublicKey) throws SSLHandshakeException {
        try {
            KeyAgreement ka = JsseJce.getKeyAgreement("ECDH");
            ka.init(this.privateKey);
            ka.doPhase(peerPublicKey, true);
            return ka.generateSecret("TlsPremasterSecret");
        }
        catch (GeneralSecurityException e) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(e);
        }
    }

    SecretKey getAgreedSecret(byte[] encodedPoint) throws SSLHandshakeException {
        try {
            ECParameterSpec params = this.publicKey.getParams();
            ECPoint point = JsseJce.decodePoint(encodedPoint, params.getCurve());
            KeyFactory kf = JsseJce.getKeyFactory("EC");
            ECPublicKeySpec spec = new ECPublicKeySpec(point, params);
            PublicKey peerPublicKey = kf.generatePublic(spec);
            return this.getAgreedSecret(peerPublicKey);
        }
        catch (IOException | GeneralSecurityException e) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(e);
        }
    }

    void checkConstraints(AlgorithmConstraints constraints, byte[] encodedPoint) throws SSLHandshakeException {
        try {
            ECParameterSpec params = this.publicKey.getParams();
            ECPoint point = JsseJce.decodePoint(encodedPoint, params.getCurve());
            ECPublicKeySpec spec = new ECPublicKeySpec(point, params);
            KeyFactory kf = JsseJce.getKeyFactory("EC");
            ECPublicKey publicKey = (ECPublicKey)kf.generatePublic(spec);
            if (!constraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), publicKey)) {
                throw new SSLHandshakeException("ECPublicKey does not comply to algorithm constraints");
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw (SSLHandshakeException)new SSLHandshakeException("Could not generate ECPublicKey").initCause(e);
        }
    }
}

