/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.shared.models.metrics;

import java.math.BigDecimal;

public enum CveMaxScore {
    CRITICAL,
    HIGH,
    MEDIUM,
    LOW,
    UNAFFECTED,
    UNSCANNED;


    public static CveMaxScore of(String value) {
        if (value == null) {
            return UNSCANNED;
        }
        BigDecimal converted = new BigDecimal(value);
        if (BigDecimal.ZERO.compareTo(converted) > 0) {
            return UNSCANNED;
        }
        if (BigDecimal.valueOf(10L).compareTo(converted) < 0) {
            throw new IllegalArgumentException("Cve max score cannot be greater than 10: cve max score=" + value);
        }
        if (BigDecimal.valueOf(9L).compareTo(converted) <= 0) {
            return CRITICAL;
        }
        if (BigDecimal.valueOf(7L).compareTo(converted) <= 0) {
            return HIGH;
        }
        if (BigDecimal.valueOf(4L).compareTo(converted) <= 0) {
            return MEDIUM;
        }
        if (BigDecimal.valueOf(0.1).compareTo(converted) <= 0) {
            return LOW;
        }
        return UNAFFECTED;
    }
}

