/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.shared.models;

import com.azul.crs.com.fasterxml.jackson.annotation.JsonInclude;
import com.azul.crs.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.azul.crs.shared.models.GenericPayload;
import com.azul.crs.shared.models.Payload;
import com.azul.crs.shared.models.TaskState;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TaskInfo
extends Payload {
    private String taskId;
    private String taskType;
    private String parentTaskId;
    private TaskState taskState;
    @JsonDeserialize(as=GenericPayload.class)
    private Payload taskPayload;
    @JsonDeserialize(as=GenericPayload.class)
    private Payload taskResult;

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public Payload getTaskPayload() {
        return this.taskPayload;
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public Payload getTaskResult() {
        return this.taskResult;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public void setTaskPayload(Payload taskPayload) {
        this.taskPayload = taskPayload;
    }

    public void setTaskState(TaskState taskState) {
        this.taskState = taskState;
    }

    public void setTaskResult(Payload taskResult) {
        this.taskResult = taskResult;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public TaskInfo taskId(String taskId) {
        this.setTaskId(taskId);
        return this;
    }

    public TaskInfo taskType(String type) {
        this.setTaskType(type);
        return this;
    }

    public TaskInfo parentTaskId(String parentTaskId) {
        this.setParentTaskId(parentTaskId);
        return this;
    }

    public TaskInfo taskPayload(Payload payload) {
        this.setTaskPayload(payload);
        return this;
    }

    public TaskInfo taskPayload(String json) {
        this.setTaskPayload(Payload.genericPayload(json));
        return this;
    }

    public TaskInfo taskState(TaskState state) {
        this.setTaskState(state);
        return this;
    }

    public TaskInfo taskState(Map state) {
        this.setTaskState(Payload.fromMap(state, TaskState.class));
        return this;
    }

    public TaskInfo taskState(String json) {
        this.setTaskState(Payload.fromJsonUnchecked(json, TaskState.class));
        return this;
    }

    public TaskInfo taskResult(Payload result) {
        this.setTaskResult(result);
        return this;
    }

    public TaskInfo taskResult(String json) {
        this.setTaskResult(Payload.genericPayload(json));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInfo taskInfo = (TaskInfo)o;
        return Objects.equals(this.taskId, taskInfo.taskId) && Objects.equals(this.taskType, taskInfo.taskType) && Objects.equals(this.parentTaskId, taskInfo.parentTaskId) && Objects.equals(this.taskPayload, taskInfo.taskPayload) && Objects.equals(this.taskState, taskInfo.taskState) && Objects.equals(this.taskResult, taskInfo.taskResult);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.taskType, this.parentTaskId, this.taskPayload, this.taskState, this.taskResult);
    }
}

