/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.shared.models;

import com.azul.crs.com.fasterxml.jackson.annotation.JsonCreator;
import com.azul.crs.com.fasterxml.jackson.annotation.JsonIgnore;
import com.azul.crs.com.fasterxml.jackson.annotation.JsonProperty;

public class EventAnalysisStats {
    private int totalEventCount;
    private int unresolvedEventCount;
    private long analysisTime;

    public EventAnalysisStats() {
    }

    @JsonCreator
    public EventAnalysisStats(@JsonProperty(value="totalEventCount") int totalEventCount, @JsonProperty(value="unresolvedEventCount") int unresolvedEventCount, @JsonProperty(value="analysisTime") long analysisTime) {
        this.totalEventCount = totalEventCount;
        this.unresolvedEventCount = unresolvedEventCount;
        this.analysisTime = analysisTime;
    }

    public int getTotalEventCount() {
        return this.totalEventCount;
    }

    public int getUnresolvedEventCount() {
        return this.unresolvedEventCount;
    }

    public long getAnalysisTime() {
        return this.analysisTime;
    }

    public void setAnalysisTime(long time) {
        this.analysisTime = time;
    }

    public void setTotalEventCount(int count) {
        this.totalEventCount = count;
    }

    public void setUnresolvedEventCount(int count) {
        this.unresolvedEventCount = count;
    }

    public EventAnalysisStats analysisTime(long time) {
        this.setAnalysisTime(time);
        return this;
    }

    public EventAnalysisStats totalEventCount(int count) {
        this.setTotalEventCount(count);
        return this;
    }

    public EventAnalysisStats unresolvedEventCount(int count) {
        this.setUnresolvedEventCount(count);
        return this;
    }

    public EventAnalysisStats addTotalEventCount(int count) {
        this.totalEventCount += count;
        return this;
    }

    public EventAnalysisStats addUnresolvedEventCount(int count) {
        this.unresolvedEventCount += count;
        return this;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.totalEventCount == 0;
    }

    public void merge(int totalEventCount, int unresolvedEventCount) {
        this.unresolvedEventCount += unresolvedEventCount;
        this.totalEventCount += totalEventCount;
        this.analysisTime = System.currentTimeMillis();
    }

    public void merge(EventAnalysisStats stats) {
        this.unresolvedEventCount += stats.unresolvedEventCount;
        this.totalEventCount += stats.totalEventCount;
        this.analysisTime = stats.analysisTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventAnalysisStats stats = (EventAnalysisStats)o;
        return this.totalEventCount == stats.totalEventCount && this.unresolvedEventCount == stats.unresolvedEventCount && this.analysisTime == stats.analysisTime;
    }

    public String toString() {
        return "Entry{totalEventCount=" + this.totalEventCount + ", unresolvedEventCount=" + this.unresolvedEventCount + ", analysisTime=" + this.analysisTime + '}';
    }
}

