/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.shared.models;

import com.azul.crs.com.fasterxml.jackson.annotation.JsonInclude;
import com.azul.crs.shared.models.Payload;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CVEImpact
extends Payload {
    private String vmId;
    private Float maxScore;
    private List<CVE> cves;
    private Long analysisTime;

    public String getVmId() {
        return this.vmId;
    }

    public Float getMaxScore() {
        return this.maxScore;
    }

    public List<CVE> getCves() {
        return this.cves;
    }

    public Long getAnalysisTime() {
        return this.analysisTime;
    }

    public void setVmId(String vmId) {
        this.vmId = vmId;
    }

    public void setMaxScore(Float maxScore) {
        this.maxScore = maxScore;
    }

    public void setCves(List<CVE> cves) {
        this.cves = cves;
    }

    public void setAnalysisTime(Long analysisTime) {
        this.analysisTime = analysisTime;
    }

    public CVEImpact vmId(String vmId) {
        this.setVmId(vmId);
        return this;
    }

    public CVEImpact maxScore(Float maxScore) {
        this.setMaxScore(maxScore);
        return this;
    }

    public CVEImpact cves(List<CVE> cves) {
        this.setCves(cves);
        return this;
    }

    public CVEImpact analysisTime(Long analysisTime) {
        this.setAnalysisTime(analysisTime);
        return this;
    }

    public CVEImpact cve(CVE cve) {
        if (this.cves == null || this.cves == Collections.EMPTY_LIST) {
            this.cves = new LinkedList<CVE>();
        }
        this.cves.add(cve);
        return this;
    }

    public CVEImpact cve(String json) {
        try {
            this.cve(Payload.fromJson(json, CVE.class));
            return this;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    public void merge(CVEImpact newImpact) {
        if (newImpact == null) {
            return;
        }
        String vmId = newImpact.getVmId();
        Float oldMaxScore = this.getMaxScore();
        Float newMaxScore = newImpact.getMaxScore();
        this.setVmId(vmId);
        this.setAnalysisTime(newImpact.getAnalysisTime());
        this.setMaxScore(this.max(newMaxScore, oldMaxScore));
        this.setCves(CVEImpact.mergeCves(this.getCves(), newImpact.getCves()));
    }

    private Float max(Float newMaxScore, Float oldMaxScore) {
        if (newMaxScore == null) {
            return oldMaxScore;
        }
        if (oldMaxScore == null) {
            return newMaxScore;
        }
        return Float.valueOf(Math.max(newMaxScore.floatValue(), oldMaxScore.floatValue()));
    }

    private static List<CVE> mergeCves(List<CVE> oldCves, List<CVE> newCves) {
        if (oldCves == null) {
            return newCves;
        }
        if (newCves == null) {
            return oldCves;
        }
        Map<String, CVE> mergedCves = oldCves.stream().collect(Collectors.toMap(CVE::getCveId, cve -> cve));
        for (CVE newCve : newCves) {
            String cveId = newCve.getCveId();
            CVE oldCve = mergedCves.get(cveId);
            if (oldCve != null) {
                CVE mergedCve = oldCve.merge(newCve);
                mergedCves.put(cveId, mergedCve);
                continue;
            }
            mergedCves.put(cveId, newCve);
        }
        return new ArrayList<CVE>(mergedCves.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CVEImpact impact = (CVEImpact)o;
        return Objects.equals(this.vmId, impact.vmId) && Objects.equals(this.maxScore, impact.maxScore) && Objects.equals(this.cves, impact.cves) && Objects.equals(this.analysisTime, impact.analysisTime);
    }

    public int hashCode() {
        return Objects.hash(this.vmId, this.maxScore, this.cves, this.analysisTime);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class CVE
    extends Payload {
        private String cveId;
        private String bugId;
        private Float score;
        private String subsystem;
        private List<Component> components;
        private List<VMClass> classes;

        public String getCveId() {
            return this.cveId;
        }

        public String getBugId() {
            return this.bugId;
        }

        public Float getScore() {
            return this.score;
        }

        public String getSubsystem() {
            return this.subsystem;
        }

        public List<Component> getComponents() {
            return this.components;
        }

        public List<VMClass> getClasses() {
            return this.classes;
        }

        public void setCveId(String cveId) {
            this.cveId = cveId;
        }

        public void setBugId(String bugId) {
            this.bugId = bugId;
        }

        public void setScore(Float score) {
            this.score = score;
        }

        public void setSubsystem(String subsystem) {
            this.subsystem = subsystem;
        }

        public void setComponents(List<Component> components) {
            this.components = components;
        }

        public void setClasses(List<VMClass> classes) {
            this.classes = classes;
        }

        public CVE cveId(String cveId) {
            this.setCveId(cveId);
            return this;
        }

        public CVE bugId(String bugId) {
            this.setBugId(bugId);
            return this;
        }

        public CVE score(Float score) {
            this.setScore(score);
            return this;
        }

        public CVE subsystem(String subsystem) {
            this.setSubsystem(subsystem);
            return this;
        }

        public CVE components(List<Component> components) {
            this.setComponents(components);
            return this;
        }

        public CVE classes(List<VMClass> classes) {
            this.setClasses(classes);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CVE cve = (CVE)o;
            return Objects.equals(this.cveId, cve.cveId) && Objects.equals(this.bugId, cve.bugId) && Objects.equals(this.score, cve.score) && Objects.equals(this.subsystem, cve.subsystem) && Objects.equals(this.components, cve.components) && Objects.equals(this.classes, cve.classes);
        }

        public int hashCode() {
            return Objects.hash(this.cveId, this.bugId, this.score, this.subsystem, this.components, this.classes);
        }

        public CVE merge(CVE newCve) {
            String newCveId = newCve.getCveId();
            if (this.cveId == null || newCveId == null) {
                throw new IllegalStateException("cveId must not be null: cveId=" + this.cveId + ", newCveId=" + newCveId);
            }
            if (!this.cveId.equals(newCveId)) {
                throw new IllegalStateException("CVEs must have equal cveId values: cveId=" + this.cveId + ", newCveId=" + newCveId);
            }
            String newCveComponent = newCve.getSubsystem();
            return new CVE().cveId(this.cveId).bugId(newCve.getBugId()).score(newCve.getScore()).subsystem(newCveComponent != null ? newCveComponent : this.subsystem).components(this.mergeComponents(newCve.getComponents()));
        }

        private List<Component> mergeComponents(List<Component> newComponents) {
            HashSet<Component> mergedComponents = new HashSet<Component>(this.components);
            mergedComponents.addAll(newComponents);
            return new ArrayList<Component>(mergedComponents);
        }
    }

    public static class Component
    extends Payload {
        private String name;
        private Integer version;

        public String getName() {
            return this.name;
        }

        public Integer getVersion() {
            return this.version;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public Component name(String name) {
            this.setName(name);
            return this;
        }

        public Component version(Integer version) {
            this.setVersion(version);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Component component1 = (Component)o;
            return Objects.equals(this.name, component1.name) && Objects.equals(this.version, component1.version);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.version);
        }
    }

    public static class VMClass
    extends Payload {
        private String className;
        private Integer version;

        public String getClassName() {
            return this.className;
        }

        public Integer getVersion() {
            return this.version;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public VMClass className(String className) {
            this.setClassName(className);
            return this;
        }

        public VMClass version(Integer version) {
            this.setVersion(version);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VMClass vmClass = (VMClass)o;
            return Objects.equals(this.className, vmClass.className) && Objects.equals(this.version, vmClass.version);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.version);
        }
    }
}

