/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Unsafe;

public final class InnocuousThread
extends Thread {
    private static final Unsafe UNSAFE;
    private static final long THREAD_LOCALS;
    private static final long INHERITABLE_THREAD_LOCALS;
    private static final ThreadGroup INNOCUOUSTHREADGROUP;
    private static final AccessControlContext ACC;
    private static final long INHERITEDACCESSCONTROLCONTEXT;
    private static final long CONTEXTCLASSLOADER;
    private static final AtomicInteger threadNumber;
    private volatile boolean hasRun;

    private static String newName() {
        return "InnocuousThread-" + threadNumber.getAndIncrement();
    }

    public static Thread newSystemThread(Runnable runnable) {
        return InnocuousThread.newSystemThread(InnocuousThread.newName(), runnable);
    }

    public static Thread newSystemThread(String string, Runnable runnable) {
        return new InnocuousThread(INNOCUOUSTHREADGROUP, runnable, string, null);
    }

    public InnocuousThread(Runnable runnable) {
        super(INNOCUOUSTHREADGROUP, runnable, InnocuousThread.newName());
        UNSAFE.putOrderedObject(this, INHERITEDACCESSCONTROLCONTEXT, ACC);
        this.eraseThreadLocals();
    }

    private InnocuousThread(ThreadGroup threadGroup, Runnable runnable, String string, ClassLoader classLoader) {
        super(threadGroup, runnable, string, 0L);
        UNSAFE.putOrderedObject(this, INHERITEDACCESSCONTROLCONTEXT, ACC);
        UNSAFE.putOrderedObject(this, CONTEXTCLASSLOADER, classLoader);
        this.eraseThreadLocals();
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
    }

    @Override
    public void setContextClassLoader(ClassLoader classLoader) {
        throw new SecurityException("setContextClassLoader");
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this && !this.hasRun) {
            this.hasRun = true;
            super.run();
        }
    }

    public void eraseThreadLocals() {
        UNSAFE.putObject((Object)this, THREAD_LOCALS, null);
        UNSAFE.putObject((Object)this, INHERITABLE_THREAD_LOCALS, null);
    }

    static {
        threadNumber = new AtomicInteger(1);
        try {
            ThreadGroup threadGroup;
            ACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> clazz = Thread.class;
            Class<ThreadGroup> clazz2 = ThreadGroup.class;
            THREAD_LOCALS = UNSAFE.objectFieldOffset(clazz.getDeclaredField("threadLocals"));
            INHERITABLE_THREAD_LOCALS = UNSAFE.objectFieldOffset(clazz.getDeclaredField("inheritableThreadLocals"));
            INHERITEDACCESSCONTROLCONTEXT = UNSAFE.objectFieldOffset(clazz.getDeclaredField("inheritedAccessControlContext"));
            CONTEXTCLASSLOADER = UNSAFE.objectFieldOffset(clazz.getDeclaredField("contextClassLoader"));
            long l = UNSAFE.objectFieldOffset(clazz.getDeclaredField("group"));
            long l2 = UNSAFE.objectFieldOffset(clazz2.getDeclaredField("parent"));
            ThreadGroup threadGroup2 = (ThreadGroup)UNSAFE.getObject((Object)Thread.currentThread(), l);
            while (threadGroup2 != null && (threadGroup = (ThreadGroup)UNSAFE.getObject((Object)threadGroup2, l2)) != null) {
                threadGroup2 = threadGroup;
            }
            threadGroup = threadGroup2;
            INNOCUOUSTHREADGROUP = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    return new ThreadGroup(threadGroup, "InnocuousThreadGroup");
                }
            });
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

