/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLKeyAgreementGenerator;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLMasterKeyDerivation;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLPossessionGenerator;

public class KrbKeyExchange {
    static final SSLPossessionGenerator poGenerator = new KrbPossessionGenerator();
    static final SSLKeyAgreementGenerator kaGenerator = new KrbKAGenerator();

    private static final class KrbKAGenerator
    implements SSLKeyAgreementGenerator {
        private KrbKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
            KrbPremasterSecret krbPremasterSecret = null;
            if (handshakeContext instanceof ClientHandshakeContext) {
                for (SSLPossession sSLPossession : handshakeContext.handshakePossessions) {
                    if (!(sSLPossession instanceof KrbPremasterSecret)) continue;
                    krbPremasterSecret = (KrbPremasterSecret)sSLPossession;
                    break;
                }
            } else {
                for (SSLCredentials sSLCredentials : handshakeContext.handshakeCredentials) {
                    if (!(sSLCredentials instanceof KrbPremasterSecret)) continue;
                    krbPremasterSecret = (KrbPremasterSecret)sSLCredentials;
                    break;
                }
            }
            if (krbPremasterSecret == null) {
                throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient KRB key agreement parameters negotiated");
            }
            return new KRBKAKeyDerivation(handshakeContext, krbPremasterSecret.premasterSecret);
        }

        private static final class KRBKAKeyDerivation
        implements SSLKeyDerivation {
            private final HandshakeContext context;
            private final byte[] secretBytes;

            KRBKAKeyDerivation(HandshakeContext handshakeContext, byte[] byArray) {
                this.context = handshakeContext;
                this.secretBytes = byArray;
            }

            @Override
            public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
                try {
                    SecretKeySpec secretKeySpec = new SecretKeySpec(this.secretBytes, "TlsPremasterSecret");
                    SSLMasterKeyDerivation sSLMasterKeyDerivation = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                    if (sSLMasterKeyDerivation == null) {
                        throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                    }
                    SSLKeyDerivation sSLKeyDerivation = sSLMasterKeyDerivation.createKeyDerivation(this.context, secretKeySpec);
                    return sSLKeyDerivation.deriveKey("MasterSecret", algorithmParameterSpec);
                }
                catch (Exception exception) {
                    throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(exception);
                }
            }
        }
    }

    static final class KrbPremasterSecret
    implements SSLPossession,
    SSLCredentials {
        final byte[] premasterSecret;

        KrbPremasterSecret(byte[] byArray) {
            this.premasterSecret = byArray;
        }
    }

    private static final class KrbPossessionGenerator
    implements SSLPossessionGenerator {
        private KrbPossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            return new KrbPremasterSecret(null);
        }
    }
}

