/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.crypto.SecretKey;
import javax.net.ssl.SNIHostName;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.KrbKeyExchange;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLTrafficKeyDerivation;
import sun.security.ssl.ServerHandshakeContext;

public class KrbClientKeyExchange {
    static final SSLConsumer krbHandshakeConsumer = new KrbClientKeyExchangeConsumer();
    static final HandshakeProducer krbHandshakeProducer = new KrbClientKeyExchangeProducer();

    private static final class KrbClientKeyExchangeConsumer
    implements SSLConsumer {
        private KrbClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            SSLKeyExchange sSLKeyExchange;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            KerberosClientKeyExchange kerberosClientKeyExchange = new KerberosClientKeyExchange(serverHandshakeContext, serverHandshakeContext.negotiatedProtocol, ProtocolVersion.valueOf(serverHandshakeContext.clientHelloVersion), serverHandshakeContext.sslContext.getSecureRandom(), byteBuffer, serverHandshakeContext.conContext.acc, this.setupKerberosKeys(serverHandshakeContext));
            serverHandshakeContext.handshakeSession.setPeerPrincipal(kerberosClientKeyExchange.getPeerPrincipal());
            serverHandshakeContext.handshakeSession.setLocalPrincipal(kerberosClientKeyExchange.getLocalPrincipal());
            KrbKeyExchange.KrbPremasterSecret krbPremasterSecret = new KrbKeyExchange.KrbPremasterSecret(kerberosClientKeyExchange.getUnencryptedPreMasterSecret());
            serverHandshakeContext.handshakeCredentials.add(krbPremasterSecret);
            if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                kerberosClientKeyExchange.print();
            }
            if ((sSLKeyExchange = SSLKeyExchange.valueOf(serverHandshakeContext.negotiatedCipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol)) == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation sSLKeyDerivation = sSLKeyExchange.createKeyDerivation(serverHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
            serverHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
            }
            serverHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(serverHandshakeContext, secretKey);
        }

        Object setupKerberosKeys(ServerHandshakeContext serverHandshakeContext) {
            Object object = null;
            try {
                final AccessControlContext accessControlContext = serverHandshakeContext.conContext.acc;
                object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return Krb5Helper.getServiceCreds(accessControlContext);
                    }
                });
                if (object != null) {
                    String string;
                    if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                        SSLLogger.fine("Using Kerberos creds", new Object[0]);
                    }
                    if ((string = Krb5Helper.getServerPrincipalName(object)) != null) {
                        SecurityManager securityManager = System.getSecurityManager();
                        try {
                            if (securityManager != null) {
                                securityManager.checkPermission(Krb5Helper.getServicePermission(string, "accept"), accessControlContext);
                            }
                        }
                        catch (SecurityException securityException) {
                            object = null;
                            if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                                SSLLogger.fine("Permission to access Kerberos secret key denied", new Object[0]);
                            }
                            return null;
                        }
                    }
                }
                return object;
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                    SSLLogger.fine("Attempt to obtain Kerberos key failed: " + privilegedActionException.toString(), new Object[0]);
                }
                return null;
            }
        }
    }

    private static final class KrbClientKeyExchangeProducer
    implements HandshakeProducer {
        private KrbClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object;
            SSLHandshake.HandshakeMessage handshakeMessage2;
            ClientHandshakeContext clientHandshakeContext;
            block13: {
                clientHandshakeContext = (ClientHandshakeContext)connectionContext;
                handshakeMessage2 = null;
                String string = null;
                if (clientHandshakeContext.negotiatedServerName != null) {
                    if (clientHandshakeContext.negotiatedServerName.getType() == 0) {
                        block12: {
                            object = null;
                            if (clientHandshakeContext.negotiatedServerName instanceof SNIHostName) {
                                object = (SNIHostName)clientHandshakeContext.negotiatedServerName;
                            } else {
                                try {
                                    object = new SNIHostName(clientHandshakeContext.negotiatedServerName.getEncoded());
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,trustmanager")) break block12;
                                    SSLLogger.fine("Illegal server name: " + clientHandshakeContext.negotiatedServerName, new Object[0]);
                                }
                            }
                        }
                        if (object != null) {
                            string = ((SNIHostName)object).getAsciiName();
                        }
                    }
                } else {
                    string = clientHandshakeContext.handshakeSession.getPeerHost();
                }
                try {
                    handshakeMessage2 = new KerberosClientKeyExchange(clientHandshakeContext, string, clientHandshakeContext.conContext.acc, clientHandshakeContext.negotiatedProtocol, clientHandshakeContext.sslContext.getSecureRandom());
                    object = new KrbKeyExchange.KrbPremasterSecret(((KerberosClientKeyExchange)handshakeMessage2).getUnencryptedPreMasterSecret());
                    clientHandshakeContext.handshakePossessions.add(object);
                }
                catch (IOException iOException) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("handshake")) break block13;
                    SSLLogger.fine("Warning, cannot use Server Name Indication: " + iOException.getMessage(), new Object[0]);
                }
            }
            handshakeMessage2.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            clientHandshakeContext.handshakeSession.setPeerPrincipal(((KerberosClientKeyExchange)handshakeMessage2).getPeerPrincipal());
            clientHandshakeContext.handshakeSession.setLocalPrincipal(((KerberosClientKeyExchange)handshakeMessage2).getLocalPrincipal());
            object = SSLKeyExchange.valueOf(clientHandshakeContext.negotiatedCipherSuite.keyExchange, clientHandshakeContext.negotiatedProtocol);
            if (object == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation sSLKeyDerivation = ((SSLKeyExchange)object).createKeyDerivation(clientHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
            clientHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
            }
            clientHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, secretKey);
            return null;
        }
    }
}

