/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLHandshake;

public class KerberosClientKeyExchange
extends SSLHandshake.HandshakeMessage {
    private static final String IMPL_CLASS = "sun.security.ssl.krb5.KerberosClientKeyExchangeImpl";
    private static final Class<?> implClass = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

        @Override
        public Class<?> run() {
            try {
                return Class.forName(KerberosClientKeyExchange.IMPL_CLASS, true, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    });
    private final KerberosClientKeyExchange impl;

    private KerberosClientKeyExchange createImpl(HandshakeContext handshakeContext) {
        if (implClass != null && this.getClass() == KerberosClientKeyExchange.class) {
            try {
                Class[] classArray = new Class[]{HandshakeContext.class};
                return (KerberosClientKeyExchange)implClass.getDeclaredConstructor(classArray).newInstance(handshakeContext);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                throw new AssertionError((Object)reflectiveOperationException);
            }
        }
        return null;
    }

    protected KerberosClientKeyExchange(HandshakeContext handshakeContext) {
        super(handshakeContext);
        this.impl = this.createImpl(handshakeContext);
    }

    public KerberosClientKeyExchange(HandshakeContext handshakeContext, String string, AccessControlContext accessControlContext, ProtocolVersion protocolVersion, SecureRandom secureRandom) throws IOException {
        this(handshakeContext);
        if (this.impl == null) {
            throw new IllegalStateException("Kerberos is unavailable");
        }
        this.init(string, accessControlContext, protocolVersion, secureRandom);
    }

    public KerberosClientKeyExchange(HandshakeContext handshakeContext, ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, ByteBuffer byteBuffer, AccessControlContext accessControlContext, Object object) throws IOException {
        this(handshakeContext);
        if (this.impl == null) {
            throw new IllegalStateException("Kerberos is unavailable");
        }
        this.init(protocolVersion, protocolVersion2, secureRandom, byteBuffer, accessControlContext, object);
    }

    @Override
    SSLHandshake handshakeType() {
        return SSLHandshake.CLIENT_KEY_EXCHANGE;
    }

    @Override
    public int messageLength() {
        return this.impl.messageLength();
    }

    @Override
    public void send(HandshakeOutStream handshakeOutStream) throws IOException {
        this.impl.send(handshakeOutStream);
    }

    public void print() throws IOException {
        this.impl.print();
    }

    public void init(String string, AccessControlContext accessControlContext, ProtocolVersion protocolVersion, SecureRandom secureRandom) throws IOException {
        if (this.impl != null) {
            this.impl.init(string, accessControlContext, protocolVersion, secureRandom);
        }
    }

    public void init(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, ByteBuffer byteBuffer, AccessControlContext accessControlContext, Object object) throws IOException {
        if (this.impl != null) {
            this.impl.init(protocolVersion, protocolVersion2, secureRandom, byteBuffer, accessControlContext, object);
        }
    }

    public byte[] getUnencryptedPreMasterSecret() {
        return this.impl.getUnencryptedPreMasterSecret();
    }

    public Principal getPeerPrincipal() {
        return this.impl.getPeerPrincipal();
    }

    public Principal getLocalPrincipal() {
        return this.impl.getLocalPrincipal();
    }
}

